/*
 * Created on 30-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.caret.GoDownAction;
import org.herac.tuxguitar.gui.actions.caret.GoLeftAction;
import org.herac.tuxguitar.gui.actions.caret.GoRightAction;
import org.herac.tuxguitar.gui.actions.caret.GoUpAction;
import org.herac.tuxguitar.gui.actions.duration.DecrementDurationAction;
import org.herac.tuxguitar.gui.actions.duration.IncrementDurationAction;
import org.herac.tuxguitar.gui.actions.mouse.SelectComponentAction;
import org.herac.tuxguitar.gui.actions.note.ChangeNoteAction;
import org.herac.tuxguitar.gui.actions.note.InsertNoteAction;
import org.herac.tuxguitar.gui.actions.note.RemoveNoteAction;
import org.herac.tuxguitar.gui.clipboard.ClipBoard;
import org.herac.tuxguitar.gui.config.PropertyNames;
import org.herac.tuxguitar.gui.helper.MemoryHelper;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.tab.layout.PageViewLayout;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.undo.UndoManager;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TablatureEditor {
    private SongManager songManager;
    private Tablature tablature;  
    private UndoManager undoManager;
    private ClipBoard clipBoard;
    private MemoryHelper memory;
    
    public TablatureEditor(SongManager songManager) {
        this.songManager = songManager;        
        this.undoManager = new UndoManager();
        this.clipBoard = new ClipBoard();
        this.memory = new MemoryHelper();
    }

    public void showTablature(Composite parent) {
        this.tablature = new Tablature(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.DOUBLE_BUFFERED);     
        this.tablature.initGUI();
        this.tablature.setSongManager(this.songManager);
        this.tablature.initDefaults(getDefaultLayout());
        this.tablature.updateTablature();
        this.tablature.initCaret();
        
        this.initMouseActions();
        this.initKeyActions();
    }
    
    private ViewLayout getDefaultLayout(){
    	boolean multitrack = TuxGuitar.instance().getConfig().getBooleanConfigValue(PropertyNames.SHOW_MULTITRACK);
    	boolean scoreEnabled = TuxGuitar.instance().getConfig().getBooleanConfigValue(PropertyNames.SHOW_SCORE);
    	int mode = TuxGuitar.instance().getConfig().getIntConfigValue(PropertyNames.LAYOUT_MODE);    	
    	switch(mode){
        	case ViewLayout.MODE_PAGE:
        		return new PageViewLayout(this.tablature,this.songManager,multitrack,scoreEnabled);
        	case ViewLayout.MODE_LINEAR:
        		return new LinearViewLayout(this.tablature,this.songManager,multitrack,scoreEnabled);
    	}
    	return null;
    }    
    
    private void initMouseActions(){
        this.tablature.addMouseListener(TuxGuitar.instance().getAction(SelectComponentAction.NAME));
    }
    
    private void initKeyActions(){
    	this.tablature.addKeyListener(new TablatureKeyListener());
    	TuxGuitar.instance().getkeyBindingManager().appendListenersTo(tablature);
    }    
    
    public void resetDefaults(){        
        getSongManager().getPlayer().reset();
        getUndoManager().discardAllEdits();
        getTablature().resetScroll();
        getTablature().updateTablature();
        getTablature().initCaret();        
        TuxGuitar.instance().updateItems();
    }

    public Tablature getTablature() {
        return this.tablature;
    }
    
    public SongManager getSongManager(){
        return this.songManager;
    }

    public UndoManager getUndoManager(){
        return this.undoManager;
    }    
    
    public ClipBoard getClipBoard(){
        return this.clipBoard;
    }        
    
    public void notifyMemoryHelper(String fileName){
        this.memory.notifyOperation(fileName);
    }    
    
    public void clearMemoryHelper(){
        this.memory.clear();
    }    
    
    public MemoryHelper getMemoryHelper(){
        return this.memory;
    }
        
    private class TablatureKeyListener extends KeyAdapter{
    	    	
        public void keyPressed(KeyEvent e) {        
        	Action action = switchAction(e);
    		
    		if(action != null){
    			action.process(e);
    		}
        }    	
    	
    	private Action switchAction(KeyEvent event){
    		Action action = null;
    		if(event.stateMask == 0 && isNumber(event.character)){
    			action = TuxGuitar.instance().getAction(ChangeNoteAction.NAME);
    		}
    		else if (event.stateMask == 0 && event.keyCode == SWT.INSERT ){
    			action = TuxGuitar.instance().getAction(InsertNoteAction.NAME);
    		}
    		else if (event.stateMask == 0 && (event.keyCode == SWT.DEL || event.keyCode == SWT.BS)){
    			action = TuxGuitar.instance().getAction(RemoveNoteAction.NAME);
    		}
    		else if (event.stateMask == 0 && event.keyCode == SWT.ARROW_UP){
    			action = TuxGuitar.instance().getAction(GoUpAction.NAME);
    		}
    		else if (event.stateMask == 0 && event.keyCode == SWT.ARROW_DOWN){
    			action = TuxGuitar.instance().getAction(GoDownAction.NAME);
    		}
    		else if (event.stateMask == 0 && event.keyCode == SWT.ARROW_RIGHT){
    			action = TuxGuitar.instance().getAction(GoRightAction.NAME);
    		}
    		else if (event.stateMask == 0 && event.keyCode == SWT.ARROW_LEFT){
    			action = TuxGuitar.instance().getAction(GoLeftAction.NAME);
    		}
    		else if (event.stateMask == 0 && event.character == '+'){
    			action = TuxGuitar.instance().getAction(IncrementDurationAction.NAME);
    		}
    		else if (event.stateMask == 0 && event.character == '-'){
    			action = TuxGuitar.instance().getAction(DecrementDurationAction.NAME);
    		}
    		return action;
    	}
    	
        private boolean isNumber(char c){
            return (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9');
        }
    }
}