package org.herac.tuxguitar.gui;

import java.io.File;

import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.song.models.Duration;

public class SystemImages {
	
	public static final String PREFIX = new File(TuxGuitar.getResourcePath("files")).getAbsolutePath() + File.separator; 
	
	private static final Image[] DURATIONS = new Image[]{ 
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "1.png"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "2.png"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "4.png"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "8.png"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "16.png"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "32.png"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "64.png")
	};	
	private static final Image[] SILENCES = new Image[]{ 
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "silence1.gif"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "silence2.gif"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "silence4.gif"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "silence8.gif"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "silence16.gif"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "silence32.gif"),
		new Image(TuxGuitar.instance().getDisplay(),PREFIX + "silence64.gif")
	};
	
	public static final Image CLEF_TREBLE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "clef_treble.gif");
	public static final Image CLEF_BASS = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "clef_bass.gif");
	public static final Image CLEF_TENOR = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "clef_tenor.gif");
	public static final Image CLEF_ALTO = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "clef_alto.gif");
	
	public static final Image KEY_NATURAL = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "natural.gif");
	public static final Image KEY_SHARP = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "sharp.gif");
	public static final Image KEY_FLAT = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "flat.gif");
	
	public static final Image TEMPO_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "tempo.png");
	
	public static final Image TRANSPORT_FIRST_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_first_1.png");
	public static final Image TRANSPORT_FIRST_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_first_2.png");
	public static final Image TRANSPORT_LAST_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_last_1.png");
	public static final Image TRANSPORT_LAST_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_last_2.png");
	public static final Image TRANSPORT_PREVIOUS_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_previous_1.png");
	public static final Image TRANSPORT_PREVIOUS_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_previous_2.png");
	public static final Image TRANSPORT_NEXT_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_next_1.png");
	public static final Image TRANSPORT_NEXT_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_next_2.png");
	public static final Image TRANSPORT_STOP_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_stop_1.png");
	public static final Image TRANSPORT_STOP_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_stop_2.png");
	public static final Image TRANSPORT_PLAY_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_play_1.png");
	public static final Image TRANSPORT_PLAY_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_play_2.png");
	public static final Image TRANSPORT_PAUSE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_pause.png");

	
	public static final Image TRANSPORT_ICON_FIRST_1 =new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_first_1.png");
	public static final Image TRANSPORT_ICON_FIRST_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_first_2.png");
	public static final Image TRANSPORT_ICON_LAST_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_last_1.png");
	public static final Image TRANSPORT_ICON_LAST_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_last_2.png");
	public static final Image TRANSPORT_ICON_PREVIOUS_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_previous_1.png");
	public static final Image TRANSPORT_ICON_PREVIOUS_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_previous_2.png");
	public static final Image TRANSPORT_ICON_NEXT_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_next_1.png");
	public static final Image TRANSPORT_ICON_NEXT_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_next_2.png");
	public static final Image TRANSPORT_ICON_STOP_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_stop_1.png");
	public static final Image TRANSPORT_ICON_STOP_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_stop_2.png");
	public static final Image TRANSPORT_ICON_PLAY_1 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_play_1.png");
	public static final Image TRANSPORT_ICON_PLAY_2 = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_play_2.png");
	public static final Image TRANSPORT_ICON_PAUSE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport_icon_pause.png");
	
	public static final Image TUXGUITAR_ICON = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "icon.png");
	public static final Image TUXGUITAR_SPLASH = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "splash.png");
	
	public static final Image OPTION_VIEW = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "viewoption.gif");
	public static final Image OPTION_LANGUAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "langoption.gif");
	
	public static final Image BEND_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "bend1.gif");	
	public static final Image FRETBOARD_FIRST_FRET_IMAGE = new Image(TuxGuitar.instance().getDisplay(), PREFIX + "firstfret.png");
	public static final Image FRETBOARD_FRET_IMAGE = new Image(TuxGuitar.instance().getDisplay(), PREFIX + "fret.png");			
	
	
	public static final Image TIME_SIGNATURE_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "timesignature.png");
	public static final Image DOTTED_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "dotted.png");
	public static final Image DOUBLE_DOTTED_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "doubledotted.png");
	public static final Image TUPLETO_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "tupleto.png");
	public static final Image UNDO_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "undo.png");
	public static final Image REDO_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "redo.png");
	public static final Image NEW_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "new.png");
	public static final Image OPEN_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "open.png");
	public static final Image SAVE_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "save.png");
	public static final Image SAVE_AS_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "save-as.png");
	public static final Image PRINT_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "print.png");
	public static final Image PRINT_PREVIEW_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "print-preview.png");
	public static final Image CHORD_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "chord.png");
	public static final Image TIED_NOTE_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "tiednote.png");
	public static final Image DEAD_NOTE_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "deadnote.png");
	public static final Image OPEN_REPEAT_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "openrepeat.png");
	public static final Image CLOSE_REPEAT_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "closerepeat.png");
	public static final Image FRETBOARD_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "fretboard.png");
	public static final Image MIXER_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "mixer.png");
	public static final Image TRANSPORT_IMAGE = new Image(TuxGuitar.instance().getDisplay(),PREFIX + "transport.png");
	
	
	public static final Image getDuration(int value){
		switch(value){
		case Duration.WHOLE:
			return DURATIONS[0];
		case Duration.HALF:
			return DURATIONS[1];			
		case Duration.QUARTER:
			return DURATIONS[2];
		case Duration.EIGHTH:
			return DURATIONS[3];
		case Duration.SIXTEENTH:
			return DURATIONS[4];
		case Duration.THIRTY_SECOND:
			return DURATIONS[5];
		case Duration.SIXTY_FOURTH:
			return DURATIONS[6];			
		}
		return null;
	}	
	
	public static final Image getSilence(int value){
		switch(value){
		case Duration.WHOLE:
			return SILENCES[0];
		case Duration.HALF:
			return SILENCES[1];			
		case Duration.QUARTER:
			return SILENCES[2];
		case Duration.EIGHTH:
			return SILENCES[3];
		case Duration.SIXTEENTH:
			return SILENCES[4];
		case Duration.THIRTY_SECOND:
			return SILENCES[5];
		case Duration.SIXTY_FOURTH:
			return SILENCES[6];			
		}
		return null;
	}
	
	public static void disposeImages(){
		for(int i = 0;i < DURATIONS.length;i++){
			DURATIONS[i].dispose();
		}
		for(int i = 0;i < SILENCES.length;i++){
			SILENCES[i].dispose();
		}
		CLEF_TREBLE.dispose();
		CLEF_BASS.dispose();
		CLEF_TENOR.dispose();
		CLEF_ALTO.dispose();
		KEY_NATURAL.dispose();
		KEY_SHARP.dispose();
		KEY_FLAT.dispose();
		TEMPO_IMAGE.dispose();
		TRANSPORT_FIRST_1.dispose();
		TRANSPORT_FIRST_2.dispose();
		TRANSPORT_LAST_1.dispose();
		TRANSPORT_LAST_2.dispose();
		TRANSPORT_PREVIOUS_1.dispose();
		TRANSPORT_PREVIOUS_2.dispose();
		TRANSPORT_NEXT_1.dispose();
		TRANSPORT_NEXT_2.dispose();
		TRANSPORT_STOP_1.dispose();
		TRANSPORT_STOP_2.dispose();
		TRANSPORT_PLAY_1.dispose();
		TRANSPORT_PLAY_2.dispose();
		TRANSPORT_PAUSE.dispose();
		
		TRANSPORT_ICON_FIRST_1.dispose();
		TRANSPORT_ICON_FIRST_2.dispose();
		TRANSPORT_ICON_LAST_1.dispose();
		TRANSPORT_ICON_LAST_2.dispose();
		TRANSPORT_ICON_PREVIOUS_1.dispose();
		TRANSPORT_ICON_PREVIOUS_2.dispose();
		TRANSPORT_ICON_NEXT_1.dispose();
		TRANSPORT_ICON_NEXT_2.dispose();
		TRANSPORT_ICON_STOP_1.dispose();
		TRANSPORT_ICON_STOP_2.dispose();
		TRANSPORT_ICON_PLAY_1.dispose();
		TRANSPORT_ICON_PLAY_2.dispose();
		TRANSPORT_ICON_PAUSE.dispose();		
		
		TUXGUITAR_SPLASH.dispose();
		TUXGUITAR_ICON.dispose();
		OPTION_VIEW.dispose();
		OPTION_LANGUAGE.dispose();
		BEND_IMAGE.dispose();
		FRETBOARD_FIRST_FRET_IMAGE.dispose();
		FRETBOARD_FRET_IMAGE.dispose();		
		TIME_SIGNATURE_IMAGE.dispose();
		DOTTED_IMAGE.dispose();
		DOUBLE_DOTTED_IMAGE.dispose();
		TUPLETO_IMAGE.dispose();
		UNDO_IMAGE.dispose();
		REDO_IMAGE.dispose();
		NEW_IMAGE.dispose();
		OPEN_IMAGE.dispose();
		SAVE_IMAGE.dispose();
		SAVE_AS_IMAGE.dispose();
		PRINT_IMAGE.dispose();
		PRINT_PREVIEW_IMAGE.dispose();
		CHORD_IMAGE.dispose();
		TIED_NOTE_IMAGE.dispose();
		DEAD_NOTE_IMAGE.dispose();
		//PLAY_IMAGE.dispose();
		//STOP_IMAGE.dispose();
		OPEN_REPEAT_IMAGE.dispose();
		CLOSE_REPEAT_IMAGE.dispose();
		FRETBOARD_IMAGE.dispose();
		MIXER_IMAGE.dispose();
		TRANSPORT_IMAGE.dispose();
	}
}
