/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.midiplayer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.midiplayer.MeasureStartMetaEventListener;
import org.herac.tuxguitar.play.models.midiplayer.SongSequence;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongPlayer
implements Player {
    private static int DELAY = 100;
    private SongManager songManager;
    private Sequencer sequencer;
    private Synthesizer synthesizer;
    private Soundbank soundbank;
    private MeasureStartMetaEventListener controller;
    private boolean realTimeSequencer;
    private boolean running;
    private boolean changeTickPosition;
    private long tickPosition;

    public SongPlayer(SongManager songManager) {
        this.songManager = songManager;
        this.controller = new MeasureStartMetaEventListener();
        this.init();
        this.reset();
    }

    private Sequencer getSequencer() {
        try {
            if (this.sequencer == null) {
                this.sequencer = MidiSystem.getSequencer();
                this.sequencer.addMetaEventListener(this.controller);
            }
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
            }
            return this.sequencer;
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Synthesizer getSynthesizer() {
        try {
            if (this.synthesizer == null) {
                Sequencer sequencer = this.getSequencer();
                if (sequencer instanceof Synthesizer) {
                    this.synthesizer = MidiSystem.getSynthesizer();
                    this.synthesizer.open();
                    this.realTimeSequencer = false;
                } else {
                    this.synthesizer = MidiSystem.getSynthesizer();
                    this.synthesizer.open();
                    this.realTimeSequencer = true;
                    Receiver receiver = this.synthesizer.getReceiver();
                    Transmitter transmitter = sequencer.getTransmitter();
                    transmitter.setReceiver(receiver);
                }
            }
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        return this.synthesizer;
    }

    public Soundbank getDefaultSoundbank() {
        if (this.soundbank == null) {
            Synthesizer synthesizer = this.getSynthesizer();
            this.soundbank = synthesizer.getDefaultSoundbank();
        }
        return this.soundbank;
    }

    public void init() {
        this.getSynthesizer();
        this.getSequencer();
    }

    public void reset() {
        this.stop();
        this.tickPosition = 1000L;
        this.setChangeTickPosition(false);
        this.controller.reset();
    }

    public void close() {
        Sequencer sequencer;
        Synthesizer synthesizer = this.getSynthesizer();
        if (synthesizer != null) {
            synthesizer.close();
        }
        if ((sequencer = this.getSequencer()) != null) {
            sequencer.close();
        }
        this.setRunning(false);
    }

    public void stop() {
        Sequencer sequencer = this.getSequencer();
        if (sequencer != null && sequencer.isRunning()) {
            sequencer.stop();
        }
        this.setRunning(false);
    }

    public boolean isRealTimeSequencer() {
        return this.realTimeSequencer;
    }

    public void play() {
        this.stop();
        this.setRunning(true);
        new Thread(new Runnable(){

            public void run() {
                try {
                    try {
                        SongPlayer.this.addSecuence();
                        SongPlayer.this.setChangeTickPosition(true);
                        SongPlayer.this.getSequencer().start();
                        while (SongPlayer.this.getSequencer().isRunning()) {
                            if (SongPlayer.this.isChangeTickPosition()) {
                                SongPlayer.this.getSequencer().setTickPosition(SongPlayer.this.tickPosition - (long)DELAY);
                                SongPlayer.this.updateChannels();
                                SongPlayer.this.setChangeTickPosition(false);
                            }
                            Thread.sleep(10L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidMidiDataException e) {
                        SongPlayer.this.close();
                        SongPlayer.this.init();
                        e.printStackTrace();
                    }
                }
                finally {
                    SongPlayer.this.reset();
                }
            }
        }).start();
    }

    public void setTickPosition(long position) {
        this.tickPosition = position;
        this.setChangeTickPosition(true);
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    private boolean isChangeTickPosition() {
        return this.changeTickPosition;
    }

    private void setChangeTickPosition(boolean changeTickPosition) {
        this.changeTickPosition = changeTickPosition;
    }

    public long getTickPosition() {
        if (this.sequencer.getTickPosition() >= this.tickPosition + (long)DELAY) {
            return this.sequencer.getTickPosition() - this.controller.getStartMove();
        }
        return 0L;
    }

    public void addSecuence() throws InvalidMidiDataException {
        SongSequence songSequence = new SongSequence(this.songManager);
        songSequence.createSongSecuence(this.isRealTimeSequencer(), true);
        this.getSequencer().setSequence(songSequence.getSongSecuence());
    }

    public void loadSoundbank(File file) {
        try {
            Soundbank soundbank = MidiSystem.getSoundbank(file);
            if (soundbank != null && this.getSynthesizer().isSoundbankSupported(soundbank)) {
                this.getSynthesizer().loadAllInstruments(soundbank);
                this.soundbank = soundbank;
            }
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateChannels() {
        if (this.isRealTimeSequencer()) {
            for (SongTrack track : this.songManager.getSong().getTracks()) {
                this.updateChannel(track.getChannel());
            }
        }
    }

    public void updateChannel(SongChannel channel) {
        double gain = (double)this.songManager.getSong().getVolume() / 10.0;
        int volume = (int)(gain * (double)channel.getVolume());
        short balance = channel.getBalance();
        boolean solo = channel.isSolo();
        boolean mute = channel.isMute();
        Synthesizer synthesizer = this.getSynthesizer();
        MidiChannel[] channels = synthesizer.getChannels();
        channels[channel.getChannel()].controlChange(7, volume);
        channels[channel.getChannel()].controlChange(10, balance);
        channels[channel.getChannel()].setSolo(solo);
        channels[channel.getChannel()].setMute(mute);
        if (channel.getChannel() != channel.getEffectChannel()) {
            channels[channel.getEffectChannel()].controlChange(7, volume);
            channels[channel.getEffectChannel()].controlChange(10, balance);
            channels[channel.getEffectChannel()].setSolo(solo);
            channels[channel.getEffectChannel()].setMute(mute);
        }
    }

    public void playBeat(final SongTrack track, List notes) {
        final MidiChannel[] channels = this.getSynthesizer().getChannels();
        for (Note note : notes) {
            final int noteValue = note.getValue() + ((InstrumentString)track.getStrings().get(note.getString() - 1)).getValue();
            final short channel = note.getEffect().hasEffects() ? track.getChannel().getEffectChannel() : track.getChannel().getChannel();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        channels[channel].controlChange(7, 127);
                        channels[channel].controlChange(10, 64);
                        channels[channel].programChange(track.getChannel().getInstrument());
                        channels[channel].noteOn(noteValue, 64);
                        Thread.sleep(750L);
                        channels[channel].noteOff(noteValue, 32);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void write(OutputStream out) {
        try {
            SongSequence songSequence = new SongSequence(this.songManager);
            songSequence.createSongSecuence(false, false);
            int type = this.songManager.countTracks() > 1 ? 1 : 0;
            MidiSystem.write(songSequence.getSongSecuence(), type, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

