/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg.old;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.io.tg.old.TGFormat;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TGWriter {
    public static void writeSong(String string, Song song) {
        File file = new File(string);
        Document document = TGWriter.createDocument();
        TGWriter.writeSong(document, file, song);
    }

    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public static void writeSong(Document document, File file, Song song) {
        TGWriter.clearDocument(document);
        TGWriter.createSongNode(document, document, song);
        TGWriter.saveDocument(document, file);
    }

    public static void createSongNode(Document document, Node node, Song song) {
        Element element = document.createElement(TGFormat.MODEL_SONG);
        node.appendChild(element);
        for (SongTrack songTrack : song.getTracks()) {
            TGWriter.createTrackNode(document, element, songTrack);
        }
        TGWriter.createTextNode(document, element, TGFormat.PARAM_NAME, song.getName());
    }

    public static void createTrackNode(Document document, Node node, SongTrack songTrack) {
        Element element = document.createElement(TGFormat.MODEL_TRACK);
        node.appendChild(element);
        for (Object object : songTrack.getMeasures()) {
            TGWriter.createMeasureNode(document, element, (Measure)object);
        }
        for (InstrumentString instrumentString : songTrack.getStrings()) {
            TGWriter.createInstrumentStringNode(document, element, instrumentString);
        }
        TGWriter.createTextNode(document, element, TGFormat.PARAM_CHANNEL, Integer.toString(songTrack.getChannel().getChannel()));
        TGWriter.createTextNode(document, element, TGFormat.PARAM_INSTRUMENT, Integer.toString(songTrack.getChannel().getInstrument()));
    }

    public static void createMeasureNode(Document document, Node node, Measure measure) {
        Element element = document.createElement(TGFormat.MODEL_MEASURE);
        node.appendChild(element);
        for (Object object : measure.getNotes()) {
            TGWriter.createNoteNode(document, element, (Note)object);
        }
        for (Silence silence : measure.getSilences()) {
            TGWriter.createSilenceNode(document, element, silence);
        }
        TGWriter.createTextNode(document, element, TGFormat.PARAM_START, Long.toString(measure.getStart()));
        TGWriter.createTextNode(document, element, TGFormat.PARAM_REPEATSTART, Boolean.toString(measure.isRepeatStart()));
        TGWriter.createTextNode(document, element, TGFormat.PARAM_NUMBEROFREPETITIONS, Integer.toString(measure.getNumberOfRepetitions()));
        TGWriter.createTimeSignatureNode(document, element, measure.getTimeSignature());
        TGWriter.createTempo(document, element, measure.getTempo());
    }

    public static void createNoteNode(Document document, Node node, Note note) {
        Element element = document.createElement(TGFormat.MODEL_NOTE);
        node.appendChild(element);
        TGWriter.createTextNode(document, element, TGFormat.PARAM_START, Long.toString(note.getStart()));
        TGWriter.createTextNode(document, element, TGFormat.PARAM_VALUE, Integer.toString(note.getValue()));
        TGWriter.createTextNode(document, element, TGFormat.PARAM_VELOCITY, Integer.toString(note.getVelocity()));
        TGWriter.createTextNode(document, element, TGFormat.PARAM_TIEDNOTE, Boolean.toString(note.isTiedNote()));
        TGWriter.createDurationNode(document, element, note.getDuration());
    }

    public static void createSilenceNode(Document document, Node node, Silence silence) {
        Element element = document.createElement(TGFormat.MODEL_SILENCE);
        node.appendChild(element);
        TGWriter.createTextNode(document, element, TGFormat.PARAM_START, Long.toString(silence.getStart()));
        TGWriter.createDurationNode(document, element, silence.getDuration());
    }

    public static void createTimeSignatureNode(Document document, Node node, TimeSignature timeSignature) {
        Element element = document.createElement(TGFormat.MODEL_TIMESIGNATURE);
        node.appendChild(element);
        TGWriter.createTextNode(document, element, TGFormat.PARAM_NUMERATOR, Integer.toString(timeSignature.getNumerator()));
        TGWriter.createDurationNode(document, element, timeSignature.getDenominator());
    }

    public static void createTempo(Document document, Node node, Tempo tempo) {
        Element element = document.createElement(TGFormat.MODEL_TEMPO);
        node.appendChild(element);
        TGWriter.createTextNode(document, element, TGFormat.PARAM_VALUE, Integer.toString(tempo.getValue()));
    }

    public static void createDurationNode(Document document, Node node, Duration duration) {
        Element element = document.createElement(TGFormat.MODEL_DURATION);
        node.appendChild(element);
        TGWriter.createTextNode(document, element, TGFormat.PARAM_VALUE, Integer.toString(duration.getValue()));
        TGWriter.createTextNode(document, element, TGFormat.PARAM_DOTTED, Boolean.toString(duration.isDotted()));
        TGWriter.createTupletoNode(document, element, duration.getTupleto());
    }

    public static void createInstrumentStringNode(Document document, Node node, InstrumentString instrumentString) {
        Element element = document.createElement(TGFormat.MODEL_INSTRUMENTSTRING);
        node.appendChild(element);
        TGWriter.createTextNode(document, element, TGFormat.PARAM_NUMBER, Integer.toString(instrumentString.getNumber()));
        TGWriter.createTextNode(document, element, TGFormat.PARAM_VALUE, Integer.toString(instrumentString.getValue()));
    }

    public static void createTupletoNode(Document document, Node node, Tupleto tupleto) {
        Element element = document.createElement(TGFormat.MODEL_TUPLETO);
        node.appendChild(element);
        TGWriter.createTextNode(document, element, TGFormat.PARAM_ENTERS, Integer.toString(tupleto.getEnters()));
        TGWriter.createTextNode(document, element, TGFormat.PARAM_TIMES, Integer.toString(tupleto.getTimes()));
    }

    private static void createTextNode(Document document, Node node, String string, String string2) {
        Element element = document.createElement(string);
        element.appendChild(document.createTextNode(string2));
        node.appendChild(element);
    }

    public static void clearDocument(Document document) {
        Node node = document.getFirstChild();
        if (node != null) {
            document.removeChild(node);
        }
    }

    public static void saveDocument(Document document, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }
}

