/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg.old;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.io.tg.old.TGFormat;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TGLoader {
    public static Song openSong(String string) {
        File file = new File(string);
        Document document = TGLoader.getDocument(file);
        return TGLoader.readSong(document.getFirstChild());
    }

    private static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    private static Song readSong(Node node) {
        ArrayList<SongTrack> arrayList = new ArrayList<SongTrack>();
        String string = "";
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (string2.equals(TGFormat.PARAM_NAME)) {
                string = TGLoader.readValue(node2);
                continue;
            }
            if (!string2.equals(TGFormat.MODEL_TRACK)) continue;
            arrayList.add(TGLoader.readTrack(node2));
        }
        return new Song(string, "", "", "", arrayList, 10);
    }

    private static SongTrack readTrack(Node node) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        ArrayList<InstrumentString> arrayList2 = new ArrayList<InstrumentString>();
        int n = 0;
        int n2 = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(TGFormat.PARAM_CHANNEL)) {
                n = Integer.parseInt(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.PARAM_INSTRUMENT)) {
                n2 = Integer.parseInt(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.MODEL_MEASURE)) {
                arrayList.add(TGLoader.readMeasure(node2));
                continue;
            }
            if (!string.equals(TGFormat.MODEL_INSTRUMENTSTRING)) continue;
            arrayList2.add(TGLoader.readInstrumentString(node2));
        }
        return new SongTrack(0L, "", null, arrayList, arrayList2, null);
    }

    private static Measure readMeasure(Node node) {
        ArrayList<Note> arrayList = new ArrayList<Note>();
        ArrayList<Silence> arrayList2 = new ArrayList<Silence>();
        TimeSignature timeSignature = null;
        Tempo tempo = null;
        long l = 0L;
        boolean bl = false;
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(TGFormat.PARAM_START)) {
                l = Long.parseLong(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.PARAM_REPEATSTART)) {
                bl = Boolean.valueOf(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.PARAM_NUMBEROFREPETITIONS)) {
                n = Integer.parseInt(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.MODEL_NOTE)) {
                arrayList.add(TGLoader.readNote(node2));
                continue;
            }
            if (string.equals(TGFormat.MODEL_SILENCE)) {
                arrayList2.add(TGLoader.readSilence(node2));
                continue;
            }
            if (string.equals(TGFormat.MODEL_TIMESIGNATURE)) {
                timeSignature = TGLoader.readTimeSignature(node2);
                continue;
            }
            if (!string.equals(TGFormat.MODEL_TEMPO)) continue;
            tempo = TGLoader.readTempo(node2);
        }
        return new Measure(0, l, arrayList, arrayList2, timeSignature, tempo, bl, n);
    }

    private static Note readNote(Node node) {
        int n = 0;
        long l = 0L;
        Duration duration = null;
        int n2 = 0;
        InstrumentString instrumentString = null;
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(TGFormat.PARAM_VALUE)) {
                n = Integer.parseInt(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.PARAM_START)) {
                l = Long.parseLong(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.PARAM_VELOCITY)) {
                n2 = Integer.parseInt(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.PARAM_TIEDNOTE)) {
                bl = Boolean.valueOf(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.MODEL_DURATION)) {
                duration = TGLoader.readDuration(node2);
                continue;
            }
            if (!string.equals(TGFormat.MODEL_INSTRUMENTSTRING)) continue;
            instrumentString = TGLoader.readInstrumentString(node2);
        }
        return new Note(n, l, duration, n2, instrumentString.getNumber(), bl, new NoteEffect());
    }

    private static Silence readSilence(Node node) {
        long l = 0L;
        Duration duration = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(TGFormat.PARAM_START)) {
                l = Long.parseLong(TGLoader.readValue(node2));
                continue;
            }
            if (!string.equals(TGFormat.MODEL_DURATION)) continue;
            duration = TGLoader.readDuration(node2);
        }
        return new Silence(l, duration);
    }

    private static InstrumentString readInstrumentString(Node node) {
        int n = 0;
        int n2 = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(TGFormat.PARAM_NUMBER)) {
                n = Integer.parseInt(TGLoader.readValue(node2));
                continue;
            }
            if (!string.equals(TGFormat.PARAM_VALUE)) continue;
            n2 = Integer.parseInt(TGLoader.readValue(node2));
        }
        return new InstrumentString(n, n2);
    }

    private static Tempo readTempo(Node node) {
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equals(TGFormat.PARAM_VALUE)) continue;
            n = Integer.parseInt(TGLoader.readValue(node2));
        }
        return new Tempo(n);
    }

    private static TimeSignature readTimeSignature(Node node) {
        Duration duration = null;
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(TGFormat.PARAM_NUMERATOR)) {
                n = Integer.parseInt(TGLoader.readValue(node2));
                continue;
            }
            if (!string.equals(TGFormat.MODEL_DURATION)) continue;
            duration = TGLoader.readDuration(node2);
        }
        return new TimeSignature(n, duration);
    }

    private static Duration readDuration(Node node) {
        int n = 0;
        boolean bl = false;
        Tupleto tupleto = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(TGFormat.PARAM_VALUE)) {
                n = Integer.parseInt(TGLoader.readValue(node2));
                continue;
            }
            if (string.equals(TGFormat.PARAM_DOTTED)) {
                bl = Boolean.valueOf(TGLoader.readValue(node2));
                continue;
            }
            if (!string.equals(TGFormat.MODEL_TUPLETO)) continue;
            tupleto = TGLoader.readTupleto(node2);
        }
        return new Duration(n, bl, false, tupleto);
    }

    private static Tupleto readTupleto(Node node) {
        int n = 0;
        int n2 = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(TGFormat.PARAM_ENTERS)) {
                n = Integer.parseInt(TGLoader.readValue(node2));
                continue;
            }
            if (!string.equals(TGFormat.PARAM_TIMES)) continue;
            n2 = Integer.parseInt(TGLoader.readValue(node2));
        }
        return new Tupleto(n, n2);
    }

    private static String readValue(Node node) {
        Node node2 = node.getFirstChild();
        return node2.getNodeValue();
    }
}

