/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableInsertMeasure
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long insertPosition;
    private List undoableMeasures;
    private int undoableNumber;
    private int copyCount;

    public UndoableInsertMeasure() {
        Caret caret = UndoableInsertMeasure.getCaret();
        this.doAction = 1;
        this.undoCaret = new UndoableCaretHelper();
        this.insertPosition = caret.getPosition();
        this.undoableNumber = caret.getMeasureCoords().getMeasure().getNumber();
        this.undoableMeasures = new ArrayList();
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        SongCoords songCoords = UndoableInsertMeasure.getCaret().getSongCoords();
        for (UndoableMeasures undoableMeasures : this.undoableMeasures) {
            SongTrackCoords songTrackCoords = songCoords.getTrack(undoableMeasures.getTrackNumber());
            songCoords.getSongManager().getTrackManager().insertMeasures(songTrackCoords.getTrack(), undoableMeasures.getMeasures(), this.undoableNumber);
        }
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        for (int i = 0; i < this.copyCount; ++i) {
            TuxGuitar.instance().getSongManager().removeMeasure(this.insertPosition);
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public void addUndo(long l, List list) {
        this.undoableMeasures.add(new UndoableMeasures(l, list));
    }

    public UndoableInsertMeasure endUndo(int n) {
        this.redoCaret = new UndoableCaretHelper();
        this.copyCount = n;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private class UndoableMeasures {
        private long trackNumber;
        private List measures;

        public UndoableMeasures(long l, List list) {
            this.trackNumber = l;
            this.measures = this.cloneMeasures(list);
        }

        public List getMeasures() {
            return this.cloneMeasures(this.measures);
        }

        public long getTrackNumber() {
            return this.trackNumber;
        }

        private List cloneMeasures(List list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Measure measure : list) {
                arrayList.add(measure.clone());
            }
            return arrayList;
        }
    }
}

