/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableChangeMeasure
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private List undoableMeasures;

    public UndoableChangeMeasure() {
        Caret caret = UndoableChangeMeasure.getCaret();
        this.doAction = 1;
        this.undoCaret = new UndoableCaretHelper();
        this.undoableMeasures = new ArrayList();
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        SongCoords songCoords = UndoableChangeMeasure.getCaret().getSongCoords();
        for (UndoableMeasure undoableMeasure : this.undoableMeasures) {
            SongTrackCoords songTrackCoords = songCoords.getTrack(undoableMeasure.getTrackNumber());
            TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(songTrackCoords.getTrack(), (Measure)undoableMeasure.getRedo().clone());
        }
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        SongCoords songCoords = UndoableChangeMeasure.getCaret().getSongCoords();
        for (UndoableMeasure undoableMeasure : this.undoableMeasures) {
            SongTrackCoords songTrackCoords = songCoords.getTrack(undoableMeasure.getTrackNumber());
            TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(songTrackCoords.getTrack(), (Measure)undoableMeasure.getUndo().clone());
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public void addUndo(long l, Measure measure, Measure measure2) {
        this.undoableMeasures.add(new UndoableMeasure(l, measure, measure2));
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    public UndoableChangeMeasure endUndo() {
        this.redoCaret = new UndoableCaretHelper();
        return this;
    }

    private class UndoableMeasure {
        private long trackNumber;
        private Measure undo;
        private Measure redo;

        public UndoableMeasure(long l, Measure measure, Measure measure2) {
            this.trackNumber = l;
            this.undo = (Measure)measure.clone();
            this.redo = (Measure)measure2.clone();
        }

        public Measure getUndo() {
            return this.undo;
        }

        public Measure getRedo() {
            return this.redo;
        }

        public long getTrackNumber() {
            return this.trackNumber;
        }
    }
}

