/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.QuarterSpanHelper;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongTrack;

public abstract class ViewLayout {
    public static final int MODE_PAGE = 1;
    public static final int MODE_LINEAR = 2;
    protected static final int DEFAULT_FIRST_TRACK_SPAN = 50;
    protected static final int DEFAULT_TRACK_SPAN = 150;
    protected static final int DEFAULT_STRING_SPAN = 12;
    protected static Font FONT_DEFAULT = new Font((Device)TuxGuitar.instance().getDisplay(), "Sans", 9, 0);
    protected static Font FONT_NOTE = new Font((Device)TuxGuitar.instance().getDisplay(), "Sans", 9, 0);
    protected static Font FONT_TIME_SIGNATURE = new Font((Device)TuxGuitar.instance().getDisplay(), "Arial", 14, 1);
    private Tablature tablature;
    private SongManager songManager;
    private boolean multitrack;
    private List quarterSpanHelpers;
    private int width;
    private int height;

    public ViewLayout(Tablature tablature, SongManager songManager, boolean bl) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.multitrack = bl;
        this.quarterSpanHelpers = new ArrayList();
    }

    public abstract void paintSong(GC var1, Rectangle var2, int var3, int var4);

    public abstract void paintTracks(List var1, GC var2, Rectangle var3, int var4, int var5);

    public abstract void paintMeasures(SongTrackCoords var1, List var2, GC var3, int var4, int var5, Rectangle var6);

    public abstract SongTrackCoords getTrackAt(List var1, int var2, int var3);

    public abstract void followMeasure(MeasureCoords var1, boolean var2);

    public void paintMeasure(MeasureCoords measureCoords, GC gC, int n, int n2, int n3, Rectangle rectangle) {
        measureCoords.setSpan(n3);
        measureCoords.paintMeasure(this, gC, n, n2, rectangle);
    }

    public void updateSong() {
        this.createTracks();
        this.updateTracks();
        this.updateCaret();
    }

    public void createTracks() {
        this.getTablature().getSongCoords().getTrackCoords().clear();
        this.getQuarterSpans().clear();
        for (int i = 0; i < this.getSongManager().getSong().getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)this.getSongManager().getSong().getTracks().get(i);
            SongTrackCoords songTrackCoords = new SongTrackCoords(this.getTablature(), this.getSongManager(), songTrack);
            this.createMeasures(songTrackCoords);
            this.getTablature().getSongCoords().getTrackCoords().add(songTrackCoords);
        }
    }

    public void updateTracks() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.getTablature().getSongCoords().getTrackCoords().size(); ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)this.getTablature().getSongCoords().getTrackCoords().get(i);
            this.updateMeasures(songTrackCoords);
            if (songTrackCoords.getWidth() > n2) {
                n2 = songTrackCoords.getWidth();
            }
            n += songTrackCoords.getHeight() + 150;
        }
        this.songManager.calculateMeasureStartWidthRepetitions();
    }

    public void createMeasures(SongTrackCoords songTrackCoords) {
        long l = this.getTablature().getCaret().getPosition();
        songTrackCoords.getMeasuresCoords().clear();
        for (int i = 0; i < songTrackCoords.getTrack().getMeasures().size(); ++i) {
            Measure measure = (Measure)songTrackCoords.getTrack().getMeasures().get(i);
            MeasureCoords measureCoords = new MeasureCoords(this.getSongManager(), this.getTablature(), measure, songTrackCoords);
            measureCoords.create(this);
            songTrackCoords.getMeasuresCoords().add(measureCoords);
            if (this.getQuarterSpans().size() > i) {
                this.getQuarterSpan(i).setQuarterSpan(measureCoords.getQuarterSpan());
                continue;
            }
            this.addQuarterSpan(new QuarterSpanHelper(measureCoords.getQuarterSpan()));
        }
    }

    public void updateMeasures(SongTrackCoords songTrackCoords) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < songTrackCoords.getMeasuresCoords().size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(i);
            measureCoords.setQuarterSpan(this.getQuarterSpan(this.getQuarterSpan(i), measureCoords));
            measureCoords.setPosX(n);
            measureCoords.setPosY(0);
            measureCoords.update(this);
            n += measureCoords.getWidth();
            if (measureCoords.getHeight() <= n2) continue;
            n2 = measureCoords.getHeight();
        }
        songTrackCoords.setWidth(n);
        songTrackCoords.setHeight(n2);
    }

    private void updateCaret() {
        this.tablature.getCaret().update();
    }

    public void fireUpdate(int n, boolean bl) {
        SongTrackCoords songTrackCoords;
        int n2;
        int n3 = n - 1;
        QuarterSpanHelper quarterSpanHelper = null;
        if (this.getQuarterSpans().size() > n3) {
            quarterSpanHelper = this.getQuarterSpan(n3);
            quarterSpanHelper.reset();
        } else {
            quarterSpanHelper = new QuarterSpanHelper();
            this.getQuarterSpans().add(quarterSpanHelper);
        }
        for (n2 = 0; n2 < this.getTablature().getSongCoords().getTrackCoords().size(); ++n2) {
            songTrackCoords = (SongTrackCoords)this.getTablature().getSongCoords().getTrackCoords().get(n2);
            songTrackCoords.fireChanges(this, n3, quarterSpanHelper, bl);
        }
        for (n2 = 0; n2 < this.getTablature().getSongCoords().getTrackCoords().size(); ++n2) {
            songTrackCoords = (SongTrackCoords)this.getTablature().getSongCoords().getTrackCoords().get(n2);
            songTrackCoords.fireUpdate(this, n3, quarterSpanHelper);
        }
        this.updateCaret();
    }

    public int getSpanForQuarter(Duration duration) {
        double d = 1000.0 / (double)duration.getTime() * (double)this.getMinSpan(duration);
        return (int)d;
    }

    private int getMinSpan(Duration duration) {
        int n = 0;
        switch (duration.getValue()) {
            case 1: {
                n = 50;
                break;
            }
            case 2: {
                n = 30;
                break;
            }
            case 4: {
                n = 25;
                break;
            }
            case 8: {
                n = 20;
                break;
            }
            default: {
                n = 18;
            }
        }
        return n;
    }

    public boolean isCaretVisible() {
        return true;
    }

    public boolean isPlayModeEnabled() {
        return true;
    }

    public void setDefaultStyle(GC gC) {
        gC.setFont(FONT_DEFAULT);
    }

    public void setNoteStyle(GC gC) {
        gC.setFont(FONT_NOTE);
    }

    public void setTimeSignatureStyle(GC gC) {
        gC.setFont(FONT_TIME_SIGNATURE);
    }

    public Point getNoteOrientation(int n, int n2, Note note) {
        Point point = new Point(n, n2);
        point.y -= 7;
        point.x -= 3;
        if (!note.isTiedNote() && !note.getEffect().isDeadNote() && note.getValue() > 9) {
            point.x -= 4;
        }
        return point;
    }

    protected boolean isMultiTrack() {
        return true;
    }

    protected int getTrackCount() {
        if (this.multitrack) {
            return this.songManager.getSong().getTracks().size();
        }
        return 1;
    }

    public int getQuarterSpan(QuarterSpanHelper quarterSpanHelper, MeasureCoords measureCoords) {
        if (this.isMultitrack()) {
            return quarterSpanHelper.getQuarterSpan();
        }
        return measureCoords.getQuarterSpan();
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public void setTablature(Tablature tablature) {
        this.tablature = tablature;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public boolean isMultitrack() {
        return this.multitrack;
    }

    public void setMultitrack(boolean bl) {
        this.multitrack = bl;
    }

    public List getQuarterSpans() {
        return this.quarterSpanHelpers;
    }

    public QuarterSpanHelper getQuarterSpan(int n) {
        return (QuarterSpanHelper)this.quarterSpanHelpers.get(n);
    }

    public void addQuarterSpan(QuarterSpanHelper quarterSpanHelper) {
        this.quarterSpanHelpers.add(quarterSpanHelper);
    }

    public int getStringSpan() {
        return 12;
    }

    public static void disposeFonts() {
        FONT_DEFAULT.dispose();
        FONT_NOTE.dispose();
        FONT_TIME_SIGNATURE.dispose();
    }
}

