/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.tab.SilenceCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.TablatureUtil;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.TimeSignature;

public class MeasureCoords {
    public static final int DEFAULT_LEFT_SPAN = 15;
    public static final int DEFAULT_RIGHT_SPAN = 15;
    public static final int DEFAULT_TIME_SIGNATURE_SPAN = 40;
    public static final int DEFAULT_QUARTER_SPAN = 30;
    private Tablature tablature;
    private int posX;
    private int posY;
    private int lastFromX;
    private int lastFromY;
    private int width;
    private int height;
    private int quarterSpan;
    private long beatLength;
    private boolean paintTimeSignature;
    private boolean paintTempo;
    private List measureComponents;
    private Measure measure;
    private SongTrackCoords trackCoords;
    private SongManager songManager;
    private boolean outOfBounds;
    private Caret caret;
    private int span;

    public MeasureCoords(SongManager songManager, Tablature tablature, Measure measure, SongTrackCoords songTrackCoords) {
        this.measure = measure;
        this.trackCoords = songTrackCoords;
        this.tablature = tablature;
        this.songManager = songManager;
        this.measureComponents = new ArrayList();
    }

    public void create(ViewLayout viewLayout) {
        this.measureComponents.clear();
        this.beatLength = TablatureUtil.getBeatLength(this.getMeasure().getTimeSignature());
        this.autoCompleteSilences();
        this.calculateQuarterSpan(viewLayout);
    }

    public void update(ViewLayout viewLayout) {
        this.orderNotes();
        this.calculateTimeSignature();
        this.calculateTempo();
        this.calculateWidth();
        this.calculateHeight(viewLayout);
        this.calcuateComponents(viewLayout);
        this.updateComponents();
        this.orderComponents();
    }

    private void calculateQuarterSpan(ViewLayout viewLayout) {
        if (this.measure.getNotes().isEmpty() && this.measure.getSilences().isEmpty()) {
            this.quarterSpan = 30;
        } else {
            Component component;
            int n;
            Component component2;
            Duration duration = null;
            if (!this.measure.getNotes().isEmpty()) {
                component2 = null;
                for (n = 0; n < this.measure.getNotes().size(); ++n) {
                    component = (Note)this.measure.getNotes().get(n);
                    if (component2 != null && ((Note)component).getDuration().getTime() > ((Note)component2).getDuration().getTime()) continue;
                    component2 = component;
                }
                duration = ((Note)component2).getDuration();
            }
            if (!this.measure.getSilences().isEmpty()) {
                component2 = null;
                for (n = 0; n < this.measure.getSilences().size(); ++n) {
                    component = (Silence)this.measure.getSilences().get(n);
                    if (component2 != null && ((Silence)component).getDuration().getTime() > ((Silence)component2).getDuration().getTime()) continue;
                    component2 = component;
                }
                if (duration == null || ((Silence)component2).getDuration().getTime() <= duration.getTime()) {
                    duration = ((Silence)component2).getDuration();
                }
            }
            this.quarterSpan = viewLayout.getSpanForQuarter(duration);
        }
    }

    public void calculateTimeSignature() {
        this.paintTimeSignature = false;
        MeasureCoords measureCoords = this.trackCoords.getPrevMeasure(this);
        if (measureCoords == null) {
            this.paintTimeSignature = true;
        } else {
            int n = this.getMeasure().getTimeSignature().getNumerator();
            int n2 = this.getMeasure().getTimeSignature().getDenominator().getValue();
            int n3 = measureCoords.getMeasure().getTimeSignature().getNumerator();
            int n4 = measureCoords.getMeasure().getTimeSignature().getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                this.paintTimeSignature = true;
            }
        }
    }

    private void calculateTempo() {
        this.paintTempo = false;
        MeasureCoords measureCoords = this.trackCoords.getPrevMeasure(this);
        if (measureCoords == null) {
            this.paintTempo = true;
        } else if (this.getMeasure().getTempo().getValue() != measureCoords.getMeasure().getTempo().getValue()) {
            this.paintTempo = true;
        }
    }

    private void calcuateComponents(ViewLayout viewLayout) {
        this.measureComponents.clear();
        this.calculateComponentsCoords(viewLayout);
    }

    private void calculateComponentsCoords(ViewLayout viewLayout) {
        Component component;
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.measure.getNotes().size(); ++n) {
            component = (Note)this.measure.getNotes().get(n);
            n3 = ((Note)component).getString() * viewLayout.getStringSpan();
            n2 = TablatureUtil.getStartPosition(this.measure, ((Note)component).getStart(), this.quarterSpan) + 10;
            this.measureComponents.add(new NoteCoords(this.tablature, this.trackCoords, this, (Note)component, n2 + this.getTimeSignatureSpan(), n3));
        }
        for (n = 0; n < this.measure.getSilences().size(); ++n) {
            component = (Silence)this.measure.getSilences().get(n);
            n2 = TablatureUtil.getStartPosition(this.measure, ((Silence)component).getStart(), this.quarterSpan) + 5;
            this.measureComponents.add(new SilenceCoords(this.tablature, this, (Silence)component, n2 + this.getTimeSignatureSpan(), 30));
        }
    }

    private void autoCompleteSilences() {
        this.songManager.getMeasureManager().autoCompleteSilences(this.measure);
    }

    private void updateComponents() {
        for (MeasureComponent measureComponent : this.measureComponents) {
            measureComponent.update();
        }
    }

    public void calculateWidth() {
        TimeSignature timeSignature = this.getMeasure().getTimeSignature();
        double d = 1.0 / (double)timeSignature.getDenominator().getValue() * 4.0 * (double)timeSignature.getNumerator();
        this.width = (int)((double)this.quarterSpan * d);
        this.width += this.getTimeSignatureSpan();
        this.width += 15;
        this.width += 15;
    }

    public void calculateHeight(ViewLayout viewLayout) {
        this.height = this.trackCoords.getTrack().getStrings().size() * viewLayout.getStringSpan();
    }

    private void orderNotes() {
        this.songManager.getMeasureManager().orderNotes(this.measure);
    }

    private void orderComponents() {
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent = null;
            for (int j = i; j < this.measureComponents.size(); ++j) {
                MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(j);
                if (measureComponent != null && measureComponent2.getStart() >= measureComponent.getStart()) continue;
                measureComponent = measureComponent2;
            }
            this.measureComponents.remove(measureComponent);
            this.measureComponents.add(i, measureComponent);
        }
    }

    public void paintMeasure(ViewLayout viewLayout, GC gC, int n, int n2, Rectangle rectangle, int n3) {
        this.setOutOfBounds(false);
        this.paintTempo(viewLayout, gC, n, n2);
        this.paintTimeSignature(viewLayout, gC, n, n2);
        this.paintComponents(viewLayout, gC, n, n2, rectangle);
        this.paintDivisions(viewLayout, gC, n, n2);
        this.paintCaret(viewLayout, gC, n, n2);
        this.paintPlayMode(viewLayout, gC, n, n2);
        this.lastFromX = n;
        this.lastFromY = n2;
    }

    public void paintMeasure(ViewLayout viewLayout, GC gC, int n, int n2, Rectangle rectangle) {
        this.paintMeasure(viewLayout, gC, n, n2, rectangle, 0);
    }

    public void paintComponents(ViewLayout viewLayout, GC gC, int n, int n2, Rectangle rectangle) {
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent = (MeasureComponent)this.measureComponents.get(i);
            measureComponent.setSpan(this.getSpanForComponent(measureComponent));
            measureComponent.paint(viewLayout, gC, n + 15, n2);
        }
    }

    public void paintCaret(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (viewLayout.isCaretVisible() && this.hasCaret()) {
            this.caret.paintCaret(gC, n + 15 + this.getTimeSignatureSpan(), n2);
        }
    }

    private void paintDivisions(ViewLayout viewLayout, GC gC, int n, int n2) {
        int n3 = n2 + viewLayout.getStringSpan();
        int n4 = n2 + this.trackCoords.getTrack().getStrings().size() * viewLayout.getStringSpan();
        if (this.measure.isRepeatStart()) {
            gC.setLineWidth(3);
            gC.drawLine(n, n3, n, n4);
            gC.drawOval(n + 7, n3 + (n4 - n3) / 2 - 7, 1, 2);
            gC.drawOval(n + 7, n3 + (n4 - n3) / 2 + 7, 1, 2);
            gC.setLineWidth(1);
            gC.drawLine(n + 3, n3, n + 3, n4);
        } else if (this.isFirstMeasure()) {
            gC.setLineWidth(3);
            gC.drawLine(n, n3, n, n4);
            gC.setLineWidth(1);
            gC.drawLine(n + 3, n3, n + 3, n4);
        } else {
            gC.drawLine(n, n3, n, n4);
        }
        if (this.measure.getNumberOfRepetitions() > 0) {
            gC.setLineWidth(3);
            gC.drawLine(n + this.getWidth() + this.getSpan(), n3, n + this.getWidth() + this.getSpan(), n4);
            gC.drawOval(n + this.getWidth() - 8 + this.getSpan(), n3 + (n4 - n3) / 2 - 7, 2, 2);
            gC.drawOval(n + this.getWidth() - 8 + this.getSpan(), n3 + (n4 - n3) / 2 + 7, 2, 2);
            gC.setLineWidth(1);
            gC.drawLine(n + this.getWidth() - 3 + this.getSpan(), n3, n + this.getWidth() - 3 + this.getSpan(), n4);
            gC.drawString("x" + Integer.toString(this.measure.getNumberOfRepetitions()), n + this.getWidth() - 10 + this.getSpan(), n2 - 5);
        } else if (this.isLastMeasure()) {
            gC.setLineWidth(3);
            gC.drawLine(n + this.getWidth() + this.getSpan(), n3, n + this.getWidth() + this.getSpan(), n4);
            gC.setLineWidth(1);
            gC.drawLine(n + this.getWidth() - 3 + this.getSpan(), n3, n + this.getWidth() - 3 + this.getSpan(), n4);
        } else {
            gC.drawLine(n + this.getWidth() + this.getSpan(), n3, n + this.getWidth() + this.getSpan(), n4);
        }
    }

    private void paintTimeSignature(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (this.paintTimeSignature) {
            viewLayout.setTimeSignatureStyle(gC);
            int n3 = this.getHeight() / 2;
            int n4 = n + 15 + 10;
            int n5 = n2 + (n3 - 12);
            int n6 = n2 + (n3 + 5);
            gC.drawString(Integer.toString(this.getMeasure().getTimeSignature().getNumerator()), n4, n5);
            gC.drawString(Integer.toString(this.getMeasure().getTimeSignature().getDenominator().getValue()), n4, n6);
            viewLayout.setDefaultStyle(gC);
        }
    }

    private void paintTempo(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (this.paintTempo) {
            int n3 = n;
            int n4 = n2 - 10;
            String string = "Tempo: " + this.getMeasure().getTempo().getValue();
            gC.drawString(string, n3, n4);
        }
    }

    private void paintPlayMode(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (viewLayout.isPlayModeEnabled() && this.isPlaying()) {
            gC.setLineStyle(2);
            gC.drawRectangle(n + 5, n2, this.getWidth() + this.getSpan() - 10, this.getHeight() + 10);
            gC.setLineStyle(1);
        }
    }

    public boolean isPlaying() {
        long l;
        return this.songManager.getPlayer().isRunning() && this.getTrackCoords().hasCaret() && (l = this.songManager.getPlayer().getTickPosition()) >= this.getMeasure().getStart() && l < this.getMeasure().getStart() + this.getMeasure().getLength();
    }

    public int getSpanForComponent(MeasureComponent measureComponent) {
        return (int)((measureComponent.getStart() - this.getMeasure().getStart()) * (long)this.getSpan() / this.getMeasure().getLength());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTimeSignatureSpan() {
        int n = 0;
        if (this.paintTimeSignature) {
            n = 40;
        }
        return n;
    }

    public MeasureComponent getPreviousComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent3.getStart() >= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() > measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getFirstComponent() {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent != null && measureComponent2.getStart() >= measureComponent.getStart()) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public MeasureComponent getLastComponent() {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent != null && measureComponent.getStart() >= measureComponent2.getStart()) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public MeasureComponent getComponent(long l) {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent2.getStart() > l || measureComponent2.getStart() + measureComponent2.getDuration().getTime() <= l) continue;
            measureComponent = measureComponent2;
            break;
        }
        return measureComponent;
    }

    public List getComponents(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        for (MeasureComponent measureComponent : this.measureComponents) {
            if (measureComponent.getStart() != l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public MeasureComponent getComponent(long l, int n) {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            NoteCoords noteCoords;
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent2 instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent2).getStart() > l || noteCoords.getStart() + noteCoords.getDuration().getTime() <= l || noteCoords.getNote().getString() != n) continue;
            measureComponent = measureComponent2;
            break;
        }
        return measureComponent;
    }

    public MeasureComponent getComponentOrSilence(long l, int n) {
        MeasureComponent measureComponent = this.getComponent(l, n);
        if (measureComponent == null && !((measureComponent = this.getComponent(l)) instanceof SilenceCoords)) {
            measureComponent = null;
        }
        return measureComponent;
    }

    public List getComponentsBeforeEnd(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        for (MeasureComponent measureComponent : this.measureComponents) {
            if (measureComponent.getStart() < l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public List getComponents() {
        return this.measureComponents;
    }

    public MeasureComponent getNextNoteComponent(MeasureComponent measureComponent, int n) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            Note note;
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof NoteCoords) || (note = ((NoteCoords)measureComponent3).getNote()).getString() != n || note.getStart() <= measureComponent.getStart() || measureComponent2 != null && note.getStart() >= measureComponent2.getStart()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextNoteComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof NoteCoords) || measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextSilenceComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof SilenceCoords) || measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getComponentAt(int n) {
        MeasureComponent measureComponent = null;
        for (MeasureComponent measureComponent2 : this.measureComponents) {
            if (measureComponent == null) {
                measureComponent = measureComponent2;
                continue;
            }
            int n2 = Math.abs(n - measureComponent.getPointX());
            int n3 = Math.abs(n - measureComponent2.getPointX());
            if (n3 >= n2) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public InstrumentString getStringAt(int n) {
        InstrumentString instrumentString = null;
        int n2 = this.tablature.getViewLayout().getStringSpan();
        int n3 = 0;
        for (InstrumentString instrumentString2 : this.trackCoords.getTrack().getStrings()) {
            int n4 = Math.abs(n - (instrumentString2.getNumber() * n2 + this.lastFromY));
            if (instrumentString != null && n4 >= n3) continue;
            instrumentString = instrumentString2;
            n3 = n4;
        }
        return instrumentString;
    }

    public long getBeatLength() {
        return this.beatLength;
    }

    public boolean areInSameBeat(MeasureComponent measureComponent, MeasureComponent measureComponent2) {
        return this.songManager.getMeasureManager().areInSameBeat(this.measure, measureComponent.getComponent(), measureComponent2.getComponent());
    }

    public boolean isFirstMeasure() {
        return this.songManager.getTrackManager().isFirstMeasure(this.measure);
    }

    public boolean isLastMeasure() {
        return this.songManager.getTrackManager().isLastMeasure(this.trackCoords.getTrack(), this.measure);
    }

    public void playBeat(long l) {
        if (!this.songManager.getPlayer().isRunning()) {
            List list = this.songManager.getMeasureManager().getNotes(this.measure, l);
            this.songManager.getPlayer().playBeat(this.getTrackCoords().getTrack(), list);
        }
    }

    public boolean hasCaret() {
        return this.caret != null;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        this.caret = caret;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public int getLastFromX() {
        return this.lastFromX;
    }

    public int getLastFromY() {
        return this.lastFromY;
    }

    public void setQuarterSpan(int n) {
        this.quarterSpan = n;
    }

    public int getQuarterSpan() {
        return this.quarterSpan;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int n) {
        this.span = n;
    }

    public boolean isOutOfBounds() {
        return this.outOfBounds;
    }

    public void setOutOfBounds(boolean bl) {
        this.outOfBounds = bl;
    }

    public SongTrackCoords getTrackCoords() {
        return this.trackCoords;
    }
}

