/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;

public class FileToolItems
implements ItemContainer {
    public static final String NAME = "FILE_ITEMS";
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;
    private ToolItem newSong;
    private ToolItem openSong;
    private ToolItem saveSong;

    public FileToolItems(TablatureEditor tablatureEditor, ToolBar toolBar) {
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
    }

    public void showItems() {
        this.newSong = new ToolItem(this.toolBar, 8);
        this.newSong.setImage(SystemImages.NEW_IMAGE);
        this.newSong.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("NEW_FILE"));
        this.openSong = new ToolItem(this.toolBar, 8);
        this.openSong.setImage(SystemImages.OPEN_IMAGE);
        this.openSong.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("OPEN_FILE"));
        this.saveSong = new ToolItem(this.toolBar, 8);
        this.saveSong.setImage(SystemImages.SAVE_IMAGE);
        this.saveSong.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SAVE_FILE"));
        this.loadProperties();
    }

    public void update() {
    }

    public void loadProperties() {
        this.newSong.setToolTipText(TuxGuitar.getProperty("file.new"));
        this.openSong.setToolTipText(TuxGuitar.getProperty("file.open"));
        this.saveSong.setToolTipText(TuxGuitar.getProperty("file.save"));
    }
}

