/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Tupleto;

public class DurationToolItems
implements ItemContainer {
    public static final String NAME = "DURATION_ITEMS";
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;
    private ToolItem[] durationItems;
    private ToolItem dotted;
    private ToolItem doubleDotted;
    private TupletoMenuItem tupletoItems;

    public DurationToolItems(TablatureEditor tablatureEditor, ToolBar toolBar) {
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
        this.durationItems = new ToolItem[7];
    }

    public void showItems() {
        this.durationItems[0] = new ToolItem(this.toolBar, 16);
        this.durationItems[0].setImage(SystemImages.getDuration(1));
        this.durationItems[0].setToolTipText("Redonda");
        this.durationItems[0].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_WHOLE_DURATION"));
        this.durationItems[1] = new ToolItem(this.toolBar, 16);
        this.durationItems[1].setImage(SystemImages.getDuration(2));
        this.durationItems[1].setToolTipText("Blanca");
        this.durationItems[1].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_HALF_DURATION"));
        this.durationItems[2] = new ToolItem(this.toolBar, 16);
        this.durationItems[2].setImage(SystemImages.getDuration(4));
        this.durationItems[2].setToolTipText("Negra");
        this.durationItems[2].setSelection(true);
        this.durationItems[2].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_QUARTER_DURATION"));
        this.durationItems[3] = new ToolItem(this.toolBar, 16);
        this.durationItems[3].setImage(SystemImages.getDuration(8));
        this.durationItems[3].setToolTipText("Corchea");
        this.durationItems[3].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_EIGHTH_DURATION"));
        this.durationItems[4] = new ToolItem(this.toolBar, 16);
        this.durationItems[4].setImage(SystemImages.getDuration(16));
        this.durationItems[4].setToolTipText("Semi-Corchea");
        this.durationItems[4].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_SIXTEENTH_DURATION"));
        this.durationItems[5] = new ToolItem(this.toolBar, 16);
        this.durationItems[5].setImage(SystemImages.getDuration(32));
        this.durationItems[5].setToolTipText("Fusa");
        this.durationItems[5].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_THIRTY_SECOND_DURATION"));
        this.durationItems[6] = new ToolItem(this.toolBar, 16);
        this.durationItems[6].setImage(SystemImages.getDuration(64));
        this.durationItems[6].setToolTipText("Semi-Fusa");
        this.durationItems[6].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_SIXTY_FOURTH_DURATION"));
        new ToolItem(this.toolBar, 2);
        this.dotted = new ToolItem(this.toolBar, 32);
        this.dotted.setImage(SystemImages.DOTTED_IMAGE);
        this.dotted.setToolTipText("Puntillo");
        this.dotted.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_DOTTED_DURATION"));
        this.doubleDotted = new ToolItem(this.toolBar, 32);
        this.doubleDotted.setImage(SystemImages.DOUBLE_DOTTED_IMAGE);
        this.doubleDotted.setToolTipText("Doble Puntillo");
        this.doubleDotted.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_DOUBLE_DOTTED_DURATION"));
        this.tupletoItems = new TupletoMenuItem();
        this.tupletoItems.addItems();
        this.loadProperties();
    }

    public void update() {
        int n;
        Duration duration = this.tablatureEditor.getTablature().getCaret().getDuration();
        for (n = 0; n < this.durationItems.length; ++n) {
            this.durationItems[n].setSelection(false);
        }
        n = 0;
        int n2 = duration.getValue();
        while (n2 > 1) {
            n2 /= 2;
            ++n;
        }
        this.durationItems[n].setSelection(true);
        this.dotted.setSelection(duration.isDotted());
        this.doubleDotted.setSelection(duration.isDoubleDotted());
        this.tupletoItems.update();
    }

    public void loadProperties() {
        this.durationItems[0].setToolTipText(TuxGuitar.getProperty("duration.whole"));
        this.durationItems[1].setToolTipText(TuxGuitar.getProperty("duration.half"));
        this.durationItems[2].setToolTipText(TuxGuitar.getProperty("duration.quarter"));
        this.durationItems[3].setToolTipText(TuxGuitar.getProperty("duration.eighth"));
        this.durationItems[4].setToolTipText(TuxGuitar.getProperty("duration.sixteenth"));
        this.durationItems[5].setToolTipText(TuxGuitar.getProperty("duration.thirtysecond"));
        this.durationItems[6].setToolTipText(TuxGuitar.getProperty("duration.sixtyfourth"));
        this.dotted.setToolTipText(TuxGuitar.getProperty("duration.dotted"));
        this.doubleDotted.setToolTipText(TuxGuitar.getProperty("duration.doubledotted"));
        this.tupletoItems.setText(TuxGuitar.getProperty("duration.tupleto"));
    }

    private class TupletoMenuItem
    extends SelectionAdapter {
        private ToolItem tupleto;
        private Menu subMenu;
        private MenuItem[] subMenuItems;

        public TupletoMenuItem() {
            this.tupleto = new ToolItem(DurationToolItems.this.toolBar, 4);
            this.tupleto.setImage(SystemImages.TUPLETO_IMAGE);
            this.tupleto.addSelectionListener((SelectionListener)this);
            this.tupleto.setData((Object)new Tupleto(3, 2));
            this.subMenu = new Menu((Control)this.tupleto.getParent().getShell());
        }

        public void setText(String string) {
            this.tupleto.setToolTipText(string);
        }

        public void addItems() {
            this.subMenuItems = new MenuItem[8];
            this.subMenuItems[0] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[0].setText("3");
            this.subMenuItems[0].setData((Object)new Tupleto(3, 2));
            this.subMenuItems[0].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
            this.subMenuItems[1] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[1].setText("5");
            this.subMenuItems[1].setData((Object)new Tupleto(5, 4));
            this.subMenuItems[1].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
            this.subMenuItems[2] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[2].setText("6");
            this.subMenuItems[2].setData((Object)new Tupleto(6, 4));
            this.subMenuItems[2].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
            this.subMenuItems[3] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[3].setText("7");
            this.subMenuItems[3].setData((Object)new Tupleto(7, 4));
            this.subMenuItems[3].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
            this.subMenuItems[4] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[4].setText("9");
            this.subMenuItems[4].setData((Object)new Tupleto(9, 8));
            this.subMenuItems[4].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
            this.subMenuItems[5] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[5].setText("10");
            this.subMenuItems[5].setData((Object)new Tupleto(10, 8));
            this.subMenuItems[5].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
            this.subMenuItems[6] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[6].setText("11");
            this.subMenuItems[6].setData((Object)new Tupleto(11, 8));
            this.subMenuItems[6].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
            this.subMenuItems[7] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[7].setText("12");
            this.subMenuItems[7].setData((Object)new Tupleto(12, 8));
            this.subMenuItems[7].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION"));
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.detail == 4) {
                ToolItem toolItem = (ToolItem)selectionEvent.widget;
                Rectangle rectangle = toolItem.getBounds();
                Point point = toolItem.getParent().toDisplay(new Point(rectangle.x, rectangle.y));
                this.subMenu.setLocation(point.x, point.y + rectangle.height);
                this.subMenu.setVisible(true);
            } else {
                Duration duration = DurationToolItems.this.tablatureEditor.getTablature().getCaret().getDuration();
                if (duration.getTupleto().isEqual(Duration.NO_TUPLETO)) {
                    ((Tupleto)this.tupleto.getData()).setEnters(3);
                    ((Tupleto)this.tupleto.getData()).setTimes(2);
                } else {
                    ((Tupleto)this.tupleto.getData()).setEnters(1);
                    ((Tupleto)this.tupleto.getData()).setTimes(1);
                }
                TuxGuitar.instance().getAction("CHANGE_TUPLETO_DURATION").process((TypedEvent)selectionEvent);
                this.update();
            }
        }

        public void update() {
            Duration duration = DurationToolItems.this.tablatureEditor.getTablature().getCaret().getDuration();
            for (int i = 0; i < this.subMenuItems.length; ++i) {
                Tupleto tupleto = (Tupleto)this.subMenuItems[i].getData();
                this.subMenuItems[i].setSelection(tupleto.isEqual(duration.getTupleto()));
            }
        }
    }
}

