/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;

public class FileMenuItem
implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem fileMenuItem;
    private Menu menu;
    private Menu exportMenu;
    private MenuItem newSong;
    private MenuItem open;
    private MenuItem save;
    private MenuItem saveAs;
    private MenuItem export;
    private MenuItem exportMidi;
    private MenuItem exportPDF;
    private MenuItem printPreview;
    private MenuItem print;
    private MenuItem exit;

    public FileMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.fileMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.newSong = new MenuItem(this.menu, 8);
        this.newSong.setImage(SystemImages.NEW_IMAGE);
        this.newSong.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("NEW_FILE"));
        this.open = new MenuItem(this.menu, 8);
        this.open.setImage(SystemImages.OPEN_IMAGE);
        this.open.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("OPEN_FILE"));
        new MenuItem(this.menu, 2);
        this.save = new MenuItem(this.menu, 8);
        this.save.setImage(SystemImages.SAVE_IMAGE);
        this.save.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SAVE_FILE"));
        this.saveAs = new MenuItem(this.menu, 8);
        this.saveAs.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SAVE_AS_FILE"));
        new MenuItem(this.menu, 2);
        this.export = new MenuItem(this.menu, 64);
        this.exportMenu = new Menu((Decorations)this.menu.getShell(), 4);
        this.exportMidi = new MenuItem(this.exportMenu, 8);
        this.exportMidi.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("EXPORT_MIDI"));
        this.exportPDF = new MenuItem(this.exportMenu, 8);
        this.exportPDF.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("EXPORT_PDF"));
        new MenuItem(this.menu, 2);
        this.printPreview = new MenuItem(this.menu, 8);
        this.printPreview.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("PRINT_PREVIEW"));
        this.print = new MenuItem(this.menu, 8);
        this.print.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("PRINT"));
        new MenuItem(this.menu, 2);
        this.exit = new MenuItem(this.menu, 8);
        this.exit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileMenuItem.this.tablatureEditor.getTablature().dispose();
                FileMenuItem.this.tablatureEditor.getSongManager().getPlayer().close();
                System.exit(0);
            }
        });
        this.export.setMenu(this.exportMenu);
        this.fileMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
    }

    public void loadProperties() {
        this.fileMenuItem.setText(TuxGuitar.getProperty("file"));
        this.newSong.setText(TuxGuitar.getProperty("file.new"));
        this.open.setText(TuxGuitar.getProperty("file.open"));
        this.save.setText(TuxGuitar.getProperty("file.save"));
        this.saveAs.setText(TuxGuitar.getProperty("file.save-as"));
        this.export.setText(TuxGuitar.getProperty("file.export"));
        this.exportMidi.setText(TuxGuitar.getProperty("file.export-midi"));
        this.exportPDF.setText(TuxGuitar.getProperty("file.export-pdf"));
        this.printPreview.setText(TuxGuitar.getProperty("file.print-preview"));
        this.print.setText(TuxGuitar.getProperty("file.print"));
        this.exit.setText(TuxGuitar.getProperty("file.exit"));
    }
}

