/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.clipboard.MeasureTransferable;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.Measure;

public class CopyMeasureAction
extends Action {
    public static final String NAME = "COPY_MEASURE";
    private boolean copyAllTracks;

    public CopyMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    private void copyCurrentMeasure() {
        Caret caret = this.getEditor().getTablature().getCaret();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        if (measureCoords != null) {
            long l = measureCoords.getMeasure().getStart();
            long l2 = measureCoords.getMeasure().getStart();
            MeasureTransferable measureTransferable = new MeasureTransferable(this.getEditor(), l, l2, true);
            this.getEditor().getClipBoard().addTransferable(measureTransferable);
        }
    }

    public void showDialog(Shell shell) {
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measureCoords != null) {
            Button button;
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout((Layout)new GridLayout());
            shell2.setText(TuxGuitar.getProperty("edit.copy"));
            Composite composite = new Composite((Composite)shell2, 0);
            composite.setLayout((Layout)new GridLayout(4, false));
            int n = this.getSongManager().countMeasures();
            GridData gridData = new GridData();
            gridData.widthHint = 26;
            gridData.verticalAlignment = 0x1000000;
            gridData.grabExcessVerticalSpace = true;
            Label label = new Label(composite, 0);
            label.setText(TuxGuitar.getProperty("edit.from"));
            final Spinner spinner = new Spinner(composite, 2048);
            spinner.setLayoutData((Object)gridData);
            spinner.setMinimum(1);
            spinner.setMaximum(n);
            spinner.setSelection(measureCoords.getMeasure().getNumber());
            Label label2 = new Label(composite, 0);
            label2.setText(TuxGuitar.getProperty("edit.to"));
            final Spinner spinner2 = new Spinner(composite, 2048);
            spinner2.setLayoutData((Object)gridData);
            spinner2.setMinimum(1);
            spinner2.setMaximum(n);
            spinner2.setSelection(measureCoords.getMeasure().getNumber());
            final int n2 = songTrackCoords.getMeasuresCoords().size();
            spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = spinner.getSelection();
                    int n2 = spinner2.getSelection();
                    if (n < 1) {
                        spinner.setSelection(1);
                    } else if (n > n2) {
                        spinner.setSelection(n2);
                    }
                }
            });
            spinner2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n;
                    int n22 = spinner2.getSelection();
                    if (n22 < (n = spinner.getSelection())) {
                        spinner2.setSelection(n);
                    } else if (n22 > n2) {
                        spinner2.setSelection(n2);
                    }
                }
            });
            Composite composite2 = new Composite((Composite)shell2, 0);
            composite2.setLayout((Layout)new GridLayout());
            this.copyAllTracks = false;
            if (this.getEditor().getSongManager().countTracks() > 1) {
                button = new Button(composite2, 32);
                button.setText(TuxGuitar.getProperty("edit.all-tracks"));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        CopyMeasureAction.this.copyAllTracks = button.getSelection();
                    }
                });
            }
            button = new Composite((Composite)shell2, 0);
            button.setLayout((Layout)new GridLayout(2, false));
            button.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
            Button button2 = new Button((Composite)button, 8);
            button2.setText(TuxGuitar.getProperty("ok"));
            button2.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CopyMeasureAction.this.copyMeasures(spinner.getSelection(), spinner2.getSelection(), CopyMeasureAction.this.copyAllTracks);
                    shell2.dispose();
                }
            });
            Button button3 = new Button((Composite)button, 8);
            button3.setText(TuxGuitar.getProperty("cancel"));
            button3.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
            button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n3 = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n4 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n3, n4);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
    }

    private void copyMeasures(int n, int n2, boolean bl) {
        if (n > 0 && n <= n2) {
            Caret caret = this.getEditor().getTablature().getCaret();
            Measure measure = this.getSongManager().getTrackManager().getMeasure(caret.getSongTrackCoords().getTrack(), n);
            Measure measure2 = this.getSongManager().getTrackManager().getMeasure(caret.getSongTrackCoords().getTrack(), n2);
            if (measure != null && measure2 != null) {
                long l = measure.getStart();
                long l2 = measure2.getStart();
                MeasureTransferable measureTransferable = new MeasureTransferable(this.getEditor(), l, l2, bl);
                this.getEditor().getClipBoard().addTransferable(measureTransferable);
            }
        }
    }
}

