/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintPreview;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class PrintPreviewAction
extends Action {
    public static final String NAME = "PRINT_PREVIEW";

    public PrintPreviewAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        new SyncThread(new Runnable(){

            public void run() {
                try {
                    PrintPreviewAction.this.getEditor().getTablature().changeCursor(1);
                    PrintPreview printPreview = new PrintPreview(PrintPreviewAction.this.makePrintDocument());
                    PrintPreviewAction.this.getEditor().getTablature().changeCursor(0);
                    printPreview.showPreview(PrintPreviewAction.this.getEditor().getTablature().getShell());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    PrintPreviewAction.this.getEditor().getTablature().changeCursor(0);
                    PrintPreviewAction.this.showErrorMessage(outOfMemoryError);
                }
            }
        }).start();
        return true;
    }

    public PrintDocument makePrintDocument() {
        Tablature tablature = new Tablature(this.getEditor().getTablature(), 0);
        tablature.setSongManager(this.getEditor().getSongManager());
        PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, this.getEditor().getSongManager(), false);
        tablature.initDefaults(printerViewLayout);
        tablature.updateTablature();
        tablature.getCaret().update(this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        PrintDocument printDocument = printerViewLayout.makeDocument();
        tablature.dispose();
        return printDocument;
    }

    private void showErrorMessage(final Error error) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    String string = error.getClass().getName();
                    String string2 = error.getMessage();
                    new MessageDialog(string, string2, 33).show(PrintPreviewAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

