/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintPage;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class PrintAction
extends Action {
    public static final String NAME = "PRINT";

    public PrintAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        PrintDialog printDialog = new PrintDialog(this.getEditor().getTablature().getShell());
        final PrinterData printerData = printDialog.open();
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    if (printerData != null) {
                        PrintAction.this.getEditor().getTablature().changeCursor(1);
                        Printer printer = new Printer(printerData);
                        if (printer.startJob("test")) {
                            try {
                                PrintDocument printDocument = PrintAction.this.makePrintDocument();
                                for (PrintPage printPage : printDocument.getPages()) {
                                    if (!printer.startPage()) continue;
                                    Image image = new Image((Device)TuxGuitar.instance().getDisplay(), printPage.getData());
                                    GC gC = new GC((Drawable)printer);
                                    gC.fillRectangle(printDocument.getPageSize());
                                    gC.drawImage(image, 0, 0);
                                    gC.dispose();
                                    image.dispose();
                                    printPage.setData(null);
                                    printer.endPage();
                                }
                                printer.endJob();
                                printer.dispose();
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                printer.dispose();
                                PrintAction.this.showErrorMessage(outOfMemoryError);
                                PrintAction.this.getEditor().getTablature().changeCursor(0);
                            }
                        }
                    }
                    PrintAction.this.getEditor().getTablature().changeCursor(0);
                }
            }
        }).start();
        return true;
    }

    public PrintDocument makePrintDocument() {
        Tablature tablature = new Tablature(this.getEditor().getTablature(), 0);
        tablature.setSongManager(this.getEditor().getSongManager());
        PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, this.getEditor().getSongManager(), false);
        tablature.initDefaults(printerViewLayout);
        tablature.updateTablature();
        tablature.getCaret().update(this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        PrintDocument printDocument = printerViewLayout.makeDocument();
        tablature.dispose();
        return printDocument;
    }

    private void showErrorMessage(final Error error) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    String string = error.getClass().getName();
                    String string2 = error.getMessage();
                    new MessageDialog(string, string2, 33).show(PrintAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

