/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.component.UndoableComponentGeneric;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Tupleto;

public class ChangeTupletoDurationAction
extends Action {
    public static final String NAME = "CHANGE_TUPLETO_DURATION";

    public ChangeTupletoDurationAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        UndoableComponentGeneric undoableComponentGeneric = UndoableComponentGeneric.startUndo();
        boolean bl = false;
        if (typedEvent instanceof KeyEvent) {
            bl = true;
        }
        if (!bl) {
            Tupleto tupleto = this.defaultTupleto();
            if (typedEvent.widget.getData() != null && typedEvent.widget.getData() instanceof Tupleto) {
                tupleto = (Tupleto)typedEvent.widget.getData();
            }
            if (this.getSelectedDuration().getTupleto().isEqual(tupleto)) {
                this.setTupleto(this.noTupleto());
            } else {
                this.setTupleto(tupleto);
            }
        } else if (this.getSelectedDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
            this.setTupleto(this.defaultTupleto());
        } else {
            this.setTupleto(this.noTupleto());
        }
        this.setDurations();
        this.getEditor().getUndoManager().addEdit(undoableComponentGeneric.endUndo());
        return true;
    }

    private Tupleto noTupleto() {
        return new Tupleto(1, 1);
    }

    private Tupleto defaultTupleto() {
        return new Tupleto(3, 2);
    }

    private void setTupleto(Tupleto tupleto) {
        this.getSelectedDuration().getTupleto().setEnters(tupleto.getEnters());
        this.getSelectedDuration().getTupleto().setTimes(tupleto.getTimes());
    }

    private void setDurations() {
        Caret caret = this.getEditor().getTablature().getCaret();
        caret.changeDuration((Duration)this.getSelectedDuration().clone());
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }

    public Duration getSelectedDuration() {
        return this.getEditor().getTablature().getCaret().getDuration();
    }
}

