/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.postscript;

import com.lowagie.text.pdf.codec.postscript.PACommand;
import com.lowagie.text.pdf.codec.postscript.PAContext;
import com.lowagie.text.pdf.codec.postscript.PAToken;
import com.lowagie.text.pdf.codec.postscript.PainterException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class PAEngine {
    public static final int MODE_STACK = 0;
    public static final int MODE_PROCEDURE = 1;
    public static final int MODE_ARRAY = 2;
    protected PAContext context;
    protected int mode;
    protected Stack procedure;
    protected int innerProcedures;

    public PAEngine(PAContext pAContext) {
        this.context = pAContext;
        this.mode = 0;
    }

    public void startProcedure() throws PainterException {
        this.procedure = new Stack();
        this.mode = 1;
        this.innerProcedures = 0;
    }

    public void endProcedure() throws PainterException {
        this.context.operands.push(new PAToken(this.procedure, 2));
        this.mode = 0;
    }

    public void bindProcedure(PAToken pAToken) {
        Stack stack = (Stack)pAToken.value;
        Stack<Object> stack2 = new Stack<Object>();
        int n = stack.size();
        for (int i = 0; i < n; ++i) {
            Object e = stack.elementAt(i);
            if (e instanceof PAToken && ((PAToken)e).type == 0) {
                Object object = this.context.findIdentifier(((PAToken)e).value);
                if (object == null) {
                    stack2.push(e);
                    continue;
                }
                stack2.push(object);
                continue;
            }
            stack2.push(e);
        }
        pAToken.value = stack2;
    }

    public void process(Object object) throws PainterException {
        block20: {
            block18: {
                block21: {
                    block19: {
                        if (object == null) {
                            throw new IllegalStateException("Null token encountered; last unknown identifier was " + this.context.getLastUnknownIdentifier());
                        }
                        if (object instanceof PAToken && ((PAToken)object).type == 6) {
                            Object object2 = this.context.findIdentifier(((PAToken)object).value);
                            this.process(object2);
                            return;
                        }
                        if (this.mode != 0) break block18;
                        if (!(object instanceof PACommand)) break block19;
                        ((PACommand)object).execute(this.context);
                        break block20;
                    }
                    if (!(object instanceof PAToken)) break block21;
                    PAToken pAToken = (PAToken)object;
                    switch (pAToken.type) {
                        case 0: {
                            this.process(this.context.findIdentifier(pAToken.value));
                            break block20;
                        }
                        case 1: 
                        case 3: 
                        case 7: {
                            this.context.operands.push(object);
                            break block20;
                        }
                        case 2: {
                            Enumeration enumeration = ((Vector)pAToken.value).elements();
                            while (enumeration.hasMoreElements()) {
                                this.process(enumeration.nextElement());
                            }
                            break block20;
                        }
                        case 4: {
                            this.startProcedure();
                            break block20;
                        }
                        case 8: {
                            this.context.collectArray();
                            break block20;
                        }
                        default: {
                            throw new IllegalStateException("Unknown token encountered" + object);
                        }
                    }
                }
                this.context.operands.push(object);
                break block20;
            }
            if (this.mode == 1) {
                if (object instanceof PAToken) {
                    PAToken pAToken = (PAToken)object;
                    switch (pAToken.type) {
                        case 4: {
                            ++this.innerProcedures;
                            this.procedure.push(object);
                            break;
                        }
                        case 5: {
                            if (this.innerProcedures > 0) {
                                --this.innerProcedures;
                                this.procedure.push(object);
                                break;
                            }
                            this.endProcedure();
                            break;
                        }
                        default: {
                            this.procedure.push(object);
                            break;
                        }
                    }
                } else {
                    this.procedure.push(object);
                }
            }
        }
    }
}

