/*
 * Created on 05-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.song.util;

import java.util.ArrayList;
import java.util.List;

import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class UndoableUtil {

    public static Song cloneSong(Song song) {

        List tracks = new ArrayList();
        for (int tIdx = 0; tIdx < song.getTracks().size(); tIdx++) {
            SongTrack track = (SongTrack) song.getTracks().get(tIdx);

            List measures = new ArrayList();
            for (int mIdx = 0; mIdx < track.getMeasures().size(); mIdx++) {
                Measure measure = (Measure) track.getMeasures().get(mIdx);

                TimeSignature timeSignature = (TimeSignature) measure.getTimeSignature().clone();
                Tempo tempo = (Tempo)measure.getTempo().clone();
                
                List notes = new ArrayList();
                for (int nIdx = 0; nIdx < measure.getNotes().size(); nIdx++) {
                    Note note = (Note) measure.getNotes().get(nIdx);
                    notes.add((Note) note.clone());
                }
                List silences = new ArrayList();
                for (int sIdx = 0; sIdx < measure.getSilences().size(); sIdx++) {
                    Silence silence = (Silence) measure.getSilences().get(sIdx);
                    silences.add((Silence) silence.clone());
                }

                measures.add(new Measure(measure.getNumber(),measure.getStart(), notes, silences, timeSignature,tempo,measure.isRepeatStart(),measure.getNumberOfRepetitions()));

            }

            List strings = new ArrayList();
            for (int sIdx = 0; sIdx < track.getStrings().size(); sIdx++) {
                InstrumentString string = (InstrumentString) track.getStrings().get(sIdx);
                strings.add((InstrumentString) string.clone());
            }

            tracks.add(new SongTrack(track.getNumber(),track.getName(),track.getChannel(), measures, strings,track.getColor()));
        }

        return new Song(song.getName(),song.getInterpret(),song.getAlbum(),song.getAuthor(), tracks,Song.MAX_VOLUME);
    }
}