package org.herac.tuxguitar.gui.util;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;

public class HomePath {				
	 
	public static String getFilePath(String fileName) {
		return HomePath.getHomePath() + fileName;
	}
	
	public static String getHomePath(){
		File file = new File(getURL().getFile());
		if(file.isFile()){
			return file.getParent() + File.separator;
		}		
		return file.getAbsolutePath() + File.separator;
	}
	
    private static URL getURL() {
        CodeSource cs = HomePath.class.getProtectionDomain().getCodeSource();                                                     
        if (cs != null) {
            URL url = cs.getLocation();
            return url;
        }
        return null;
    }
    
}
