package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableChangeMeasure implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;			
	private List undoableMeasures;
	
	public UndoableChangeMeasure(){
    	Caret caret = getCaret();    	    	
    	this.doAction = UNDO_ACTION;
    	this.undoCaret = new UndoableCaretHelper();	    	    	
    	this.undoableMeasures = new ArrayList();
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}   
		SongCoords songCoords = getCaret().getSongCoords();	
		Iterator it = this.undoableMeasures.iterator();
		while(it.hasNext()){
			UndoableMeasure undoable = (UndoableMeasure)it.next();		
			SongTrackCoords currTrackCoords = songCoords.getTrack(undoable.getTrackNumber());				
			TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(currTrackCoords.getTrack(),(Measure)undoable.getRedo().clone());
		}
		TuxGuitar.instance().fireUpdate();
		this.redoCaret.update();
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}							
		SongCoords songCoords = getCaret().getSongCoords();	
		Iterator it = this.undoableMeasures.iterator();
		while(it.hasNext()){
			UndoableMeasure undoable = (UndoableMeasure)it.next();		
			SongTrackCoords currTrackCoords = songCoords.getTrack(undoable.getTrackNumber());				
			TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(currTrackCoords.getTrack(),(Measure)undoable.getUndo().clone());
		}
		TuxGuitar.instance().fireUpdate();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public void addUndo(long trackNumber,Measure undo,Measure redo){
    	undoableMeasures.add(new UndoableMeasure(trackNumber,undo,redo));
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  

    public UndoableChangeMeasure endUndo(){
    	this.redoCaret = new UndoableCaretHelper();
    	return this;
    }
    
    private class UndoableMeasure{
    	private long trackNumber;
    	private Measure undo;
    	private Measure redo;

    	public UndoableMeasure(long trackNumber,Measure undo,Measure redo) {
			this.trackNumber = trackNumber;
			this.undo = (Measure)undo.clone();
			this.redo = (Measure)redo.clone();
		}

		public Measure getUndo() {
			return undo;
		}
    	
		public Measure getRedo() {
			return redo;
		}

		public long getTrackNumber() {
			return trackNumber;
		}
    }
}
