/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.QuarterSpanHelper;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongTrack;


/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class ViewLayout {
	public static final int MODE_PAGE = 1;
	public static final int MODE_LINEAR = 2; 
    
	protected static final int DEFAULT_FIRST_TRACK_SPAN = 50;
	protected static final int DEFAULT_TRACK_SPAN = 150;
    protected static final int DEFAULT_STRING_SPAN = 12;
    
    protected static Font FONT_DEFAULT = new Font(TuxGuitar.instance().getDisplay(),"Sans",9, SWT.NORMAL);
    protected static Font FONT_NOTE = new Font(TuxGuitar.instance().getDisplay(),"Sans",9, SWT.NORMAL);
    protected static Font FONT_TIME_SIGNATURE = new Font(TuxGuitar.instance().getDisplay(),"Arial",14, SWT.BOLD);
    
    private Tablature tablature; 
    private SongManager songManager;
    private boolean multitrack;
    private List quarterSpanHelpers;
    private int width;
    private int height;
    
    public ViewLayout(Tablature tablature,SongManager songManager,boolean multitrack){
        this.tablature = tablature;
        this.songManager = songManager;
        this.multitrack = multitrack;
        this.quarterSpanHelpers = new ArrayList();
    }
    
    public abstract void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY);
    public abstract void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY);
    public abstract void paintMeasures(SongTrackCoords trackCoords,List measuresCoords,GC gc,int fromX, int fromY,Rectangle clientArea);    
    public abstract SongTrackCoords getTrackAt(List tracksCoords,int y,int vScroll);
    public abstract void followMeasure(MeasureCoords measure,boolean redraw);
    
    
    public void paintMeasure(MeasureCoords measureCoords,GC gc,int fromX,int fromY,int span,Rectangle clientArea) {
        measureCoords.setSpan(span);                
        measureCoords.paintMeasure(this,gc,fromX,fromY,clientArea);
    }    
    
    public void updateSong(){    	
        createTracks();
        updateTracks();       
        updateCaret();
    }
    
    public void createTracks() {
        getTablature().getSongCoords().getTrackCoords().clear();        
        getQuarterSpans().clear();   
        
        for (int trackIdx = 0; trackIdx < getSongManager().getSong().getTracks().size(); trackIdx++) {
            SongTrack track = (SongTrack) getSongManager().getSong().getTracks().get(trackIdx);
            SongTrackCoords trackCoords = new SongTrackCoords(getTablature(),getSongManager(), track);
            createMeasures(trackCoords);
            getTablature().getSongCoords().getTrackCoords().add(trackCoords);            
        }
    }    
    
    public void updateTracks() {
        int height = 0;
        int maxWidth = 0;

        for (int trackIdx = 0; trackIdx < getTablature().getSongCoords().getTrackCoords().size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)getTablature().getSongCoords().getTrackCoords().get(trackIdx);
            updateMeasures(trackCoords);
            if(trackCoords.getWidth() > maxWidth){
                maxWidth = trackCoords.getWidth();
            }
            height += trackCoords.getHeight() + DEFAULT_TRACK_SPAN;
           
        } 
        songManager.calculateMeasureStartWidthRepetitions();
    }    
    
    public void createMeasures(SongTrackCoords trackCoords) {
        long caretPosition = getTablature().getCaret().getPosition();
        
        trackCoords.getMeasuresCoords().clear();
        for (int measureIdx = 0; measureIdx < trackCoords.getTrack().getMeasures().size(); measureIdx++) {
            Measure measure = (Measure) trackCoords.getTrack().getMeasures().get(measureIdx);
            MeasureCoords measureCoords = new MeasureCoords(getSongManager(),getTablature(), measure,trackCoords);            
            measureCoords.create(this);                                    
            trackCoords.getMeasuresCoords().add(measureCoords);
            
            if(getQuarterSpans().size() > measureIdx){                                
                getQuarterSpan(measureIdx).setQuarterSpan(measureCoords.getQuarterSpan());
            }else{
                addQuarterSpan(new QuarterSpanHelper(measureCoords.getQuarterSpan()));
            }
        }
    }
    
    public void updateMeasures(SongTrackCoords trackCoords) {
        int width = 0;
        int maxHeight = 0;
        for (int measureIdx = 0; measureIdx < trackCoords.getMeasuresCoords().size(); measureIdx++) {
            MeasureCoords measureCoords =  (MeasureCoords) trackCoords.getMeasuresCoords().get(measureIdx);                             
            
            //si es en modo multitrack. asigno mayor quarterSpan para este compas.
            measureCoords.setQuarterSpan(getQuarterSpan(getQuarterSpan(measureIdx),measureCoords));     
            
            //asigno la posicion dentro del compas
            measureCoords.setPosX(width);
            measureCoords.setPosY(0);    
            
            measureCoords.update(this);
            
            width += measureCoords.getWidth();
            if(measureCoords.getHeight() > maxHeight){
                maxHeight = measureCoords.getHeight();
            }                    
        }
        
        trackCoords.setWidth(width);
        trackCoords.setHeight(maxHeight);
    }    

    private void updateCaret(){
    	tablature.getCaret().update();
    }
    
    
    public void fireUpdate(int measureNumber,boolean isNew){
    	int measureIndex = (measureNumber - 1);
    	
        QuarterSpanHelper quarterSpan = null;
        if(getQuarterSpans().size() > measureIndex){                                
            quarterSpan = getQuarterSpan(measureIndex);
            quarterSpan.reset();
        }else{
            quarterSpan = new QuarterSpanHelper();
            getQuarterSpans().add(quarterSpan);
        }         
        
        for (int trackIdx = 0; trackIdx < getTablature().getSongCoords().getTrackCoords().size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)getTablature().getSongCoords().getTrackCoords().get(trackIdx);
            trackCoords.fireChanges(this,measureIndex,quarterSpan,isNew);   
        } 
        for (int trackIdx = 0; trackIdx < getTablature().getSongCoords().getTrackCoords().size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)getTablature().getSongCoords().getTrackCoords().get(trackIdx);
            trackCoords.fireUpdate(this,measureIndex,quarterSpan);
        }     
        updateCaret();
    }    
    
    /**
     * Calcula el espacio minimo entre negras, dependiendo de la duracion de la nota 
     */
    public int getSpanForQuarter(Duration duration){        
        double span = ((double)Duration.QUARTER_TIME / (double)duration.getTime()) * getMinSpan(duration);
        return  (int)span;
    }   
    
    /**
     * Calcula el Espacio minimo que quedara entre nota y nota
     */
    private int getMinSpan(Duration duration){
        int minSpan = 0;
        switch(duration.getValue()){
        	case Duration.WHOLE:
        	    minSpan = 50;
        	    break;
        	case Duration.HALF:
        	    minSpan = 30;
        	    break;
        	case Duration.QUARTER:
        	    minSpan = 25;
        	    break;
        	case Duration.EIGHTH:
        	    minSpan = 20;
        	    break;       
        	default:
        	    minSpan = 18;
        	    break;
        }        
        return minSpan;        
    }    
    
    
    public boolean isCaretVisible(){
    	return true;
    }

    public boolean isPlayModeEnabled(){
    	return true;
    }
    
    public void setDefaultStyle(GC gc){
    	gc.setFont(FONT_DEFAULT);
    }
    
    public void setNoteStyle(GC gc){
    	gc.setFont(FONT_NOTE);    	
    }
    
    public void setTimeSignatureStyle(GC gc){
    	gc.setFont(FONT_TIME_SIGNATURE);    	
    }
    
    public Point getNoteOrientation(int x,int y,Note note){
    	Point point = new Point(x,y);
    	point.y -= 7;
    	point.x -= 3;
        if (!note.isTiedNote() && !note.getEffect().isDeadNote() && note.getValue() > 9) {
        	point.x -= 4;
        }        
        return point;
    }
    
    protected boolean isMultiTrack(){
        return true;
    }

    protected int getTrackCount(){
        if(multitrack){
            return songManager.getSong().getTracks().size();
        }
        return 1;
    }           
    
    
    public int getQuarterSpan(QuarterSpanHelper quarterSpan,MeasureCoords measure){
        if(isMultitrack()){
            return quarterSpan.getQuarterSpan();
        }else{
            return measure.getQuarterSpan();
        }
    }    
    
    
    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    public Tablature getTablature() {
        return tablature;
    }
    public void setTablature(Tablature tablature) {
        this.tablature = tablature;
    }
    public int getHeight() {
        return height;
    }
    public void setHeight(int height) {
        this.height = height;
    }
    public int getWidth() {
        return width;
    }
    public void setWidth(int width) {
        this.width = width;
    }
    
    
    public boolean isMultitrack() {
        return multitrack;
    }
    public void setMultitrack(boolean multitrack) {
        this.multitrack = multitrack;
    }

    

	public List getQuarterSpans(){
        return this.quarterSpanHelpers;
    }
    
    public QuarterSpanHelper getQuarterSpan(int i){
        return (QuarterSpanHelper)this.quarterSpanHelpers.get(i);
    }    

    public void addQuarterSpan(QuarterSpanHelper quarterSpan){
        this.quarterSpanHelpers.add(quarterSpan);
    }    
    
    public int getStringSpan(){
    	return DEFAULT_STRING_SPAN;
    }
        
    public static void disposeFonts(){
    	FONT_DEFAULT.dispose();
    	FONT_NOTE.dispose();
    	FONT_TIME_SIGNATURE.dispose();
    }
}
