/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.List;

import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongCoords {
    private Tablature tablature;
    private SongManager songManager;
    private List tracksCoords;
    
    public SongCoords(Tablature tablature,SongManager songManager) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.init();
    }	

    public void init(){
        this.tracksCoords = new ArrayList();
    }    

    public SongTrackCoords getTrackAt(int y,int vScroll){
        return this.tablature.getViewLayout().getTrackAt(this.tracksCoords,y,vScroll);
    }
    
    
    public SongTrackCoords getTrack(long number){
        SongTrackCoords trackCoords = null;        
        for (int i = 0; i < this.tracksCoords.size(); i++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(i);            
            if(currTrack.getTrack().getNumber() == number){
                trackCoords = currTrack;
                break;
            }
        }     
        return trackCoords;
    }      
    
    public SongTrackCoords getNextTrack(SongTrackCoords trackCoords){
        SongTrackCoords track = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.equals(trackCoords)){
                int nextIndex = trackIdx + 1;
                if(nextIndex < this.tracksCoords.size()){
                    track = (SongTrackCoords)this.tracksCoords.get(nextIndex);                    
                }
                break;
            }
        }     
        return track;
    }
    
    public SongTrackCoords getPrevTrack(SongTrackCoords trackCoords){
        SongTrackCoords track = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.equals(trackCoords)){
                int prevIndex = trackIdx - 1;
                if(prevIndex >= 0){
                    track = (SongTrackCoords)this.tracksCoords.get(prevIndex);                    
                }
                break;
            }
        }     
        return track;
    }    
    
    public SongTrackCoords getTrack(SongTrack songTrack){
        SongTrackCoords trackCoords = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.getTrack().equals(songTrack)){
                trackCoords = currTrack;
                break;
            }
        }     
        return trackCoords;
    }        
    
    
    public SongTrackCoords getFirstTrack(){
        SongTrackCoords track = null;
        if(!this.tracksCoords.isEmpty()){
            track = (SongTrackCoords)this.tracksCoords.get(0);
        }
        return track;
    }       

    public SongTrackCoords getLastTrack(){
        SongTrackCoords track = null;
        if(!this.tracksCoords.isEmpty()){
            track = (SongTrackCoords)this.tracksCoords.get(this.tracksCoords.size() - 1);
        }
        return track;
    }               
 
    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    public List getTrackCoords(){
        return this.tracksCoords;
    }

}