/*
 * Created on 26-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.TimeSignature;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureCoords {
    /**
     * Espacio por defecto a la izquierda
     */
    public static final int DEFAULT_LEFT_SPAN = 15;
    /**
     * Espacio por defecto a la derecha
     */
    public static final int DEFAULT_RIGHT_SPAN = 15;    
    /**
     * Espacio por defecto del timeSignature
     */
    public static final int DEFAULT_TIME_SIGNATURE_SPAN = 40;    
    /**
     * Espacio por defecto entre negra y negra
     */
    public static final int DEFAULT_QUARTER_SPAN = 30;
    /**
     * Widget de la tablatura
     */    
    private Tablature tablature;    
    /**
     * Posicion X dentro del compas
     */
    private int posX;
    /** 
     * Posicion Y dentro del compas
     */
    private int posY;
    /**
     * Ultima Posicion X
     */
    private int lastFromX;
    /**
     * Ultima Posicion Y
     */
    private int lastFromY;
    /**
     * Ancho del Compas
     */
    private int width;
    /**
     * Alto del Compas
     */
    private int height;
    /**
     * Espacio entre negras
     */
    private int quarterSpan;
    /**
     * Espacio entre pulsos
     */        
    private long beatLength;
    /**
     * Boolean para saber si hay que pintar el TimeSignature
     */
    private boolean paintTimeSignature;
    /**
     * Boolean para saber si hay que pintar el Tempo
     */
    private boolean paintTempo;    
    /**
     * Coordenadas de notas
     */
    private List measureComponents;
    /**
     * Compas de Referencia
     */
    private Measure measure;
    /**
     * Pista de Referencia
     */
    private SongTrackCoords trackCoords;
    /**
     * Tema de Referencia
     */
    private SongManager songManager;
    /**
     * El caret para editar la tablatura
     */
    /**
     * Boolean para saber si el compas esta en el area de pantalla
     */
    private boolean outOfBounds;
    
    private Caret caret;
    
    private int span;
       

    public MeasureCoords(SongManager songManager,Tablature tablature, Measure measure, SongTrackCoords trackCoords) {
        this.measure = measure;
        this.trackCoords = trackCoords;
        this.tablature = tablature;
        this.songManager = songManager;
        this.measureComponents = new ArrayList();
    }

    
    /**
     * Crea los valores necesarios
     */
    public void create(ViewLayout layout) {        
        this.measureComponents.clear();
        this.beatLength =  TablatureUtil.getBeatLength(getMeasure().getTimeSignature());
        autoCompleteSilences();        
        calculateQuarterSpan(layout);
    }    
    
    
    /**
     * Actualiza los valores para dibujar
     */
    public void update(ViewLayout layout) {        
        
    	orderNotes();
        calculateTimeSignature();
        calculateTempo();
        calculateWidth();
        calculateHeight(layout);
        calcuateComponents(layout);        
        updateComponents();        
        orderComponents();
    }

    /**
     * Calcula el espacio que debe haber entre negras
     */
    private void calculateQuarterSpan(ViewLayout layout) {        
        if (measure.getNotes().isEmpty() && measure.getSilences().isEmpty()) {
            this.quarterSpan = DEFAULT_QUARTER_SPAN;
        } else {
            Duration minDuration = null;
            if(!measure.getNotes().isEmpty()){
                Note minNote = null;
                for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
                    Note currentNote = (Note) measure.getNotes().get(noteIdx);

                    if (minNote == null || currentNote.getDuration().getTime() <= minNote.getDuration().getTime()) {
                        minNote = currentNote;
                    }
                }
                minDuration = minNote.getDuration();
            }
            if(!measure.getSilences().isEmpty()){
                Silence minSilence = null;
                for (int silenceIdx = 0; silenceIdx < measure.getSilences().size(); silenceIdx++) {
                    Silence currentSilence = (Silence) measure.getSilences().get(silenceIdx);

                    if (minSilence == null || currentSilence.getDuration().getTime() <= minSilence.getDuration().getTime()) {
                        minSilence = currentSilence;
                    }
                }            
                
                if(minDuration == null || minSilence.getDuration().getTime() <= minDuration.getTime()){
                    minDuration = minSilence.getDuration();
                }
            }
            this.quarterSpan = layout.getSpanForQuarter(minDuration);
        }
    }

    
    /**
     * Calcula si debe pintar el TimeSignature
     */
    public void calculateTimeSignature() {    
        this.paintTimeSignature = false;
        MeasureCoords prevMeasure = this.trackCoords.getPrevMeasure(this);
        if(prevMeasure == null){
            this.paintTimeSignature = true;
        }else{
            int thisNumerator = getMeasure().getTimeSignature().getNumerator();
            int thisValue = getMeasure().getTimeSignature().getDenominator().getValue();
            int prevNumerator = prevMeasure.getMeasure().getTimeSignature().getNumerator();
            int prevValue = prevMeasure.getMeasure().getTimeSignature().getDenominator().getValue();            
            if(thisNumerator != prevNumerator || thisValue != prevValue){
                this.paintTimeSignature = true;
            }
        }
    }
    
    /**
     * Calcula si debe pintar el Tempo
     */
    private void calculateTempo() {    
        this.paintTempo = false;
        MeasureCoords prevMeasure = this.trackCoords.getPrevMeasure(this);
        if(prevMeasure == null){
            this.paintTempo = true;
        }else{         
            if(getMeasure().getTempo().getValue() != prevMeasure.getMeasure().getTempo().getValue()){
                this.paintTempo = true;
            }            
        }
    }    
    
    /**
     * Calcula las coordenadas de los componentes
     */    
    private void calcuateComponents(ViewLayout layout){
        this.measureComponents.clear();
        calculateComponentsCoords(layout);
    }
    
    /**
     * Calcula las coordenadas de las notas y silencios
     */
    private void calculateComponentsCoords(ViewLayout layout) {
        int posX = 0;
        int posY = 0;        
        //---------------------------------Notas-------------------------------------
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            Note note = (Note) measure.getNotes().get(noteIdx);
            posY = note.getString() * layout.getStringSpan();
            posX = TablatureUtil.getStartPosition(measure, note.getStart(), this.quarterSpan) + 10;            
            measureComponents.add(new NoteCoords(this.tablature,this.trackCoords,this, note, posX + getTimeSignatureSpan(), posY));
        }
        //---------------------------------Silencios---------------------------------
        for (int silenceIdx = 0; silenceIdx < measure.getSilences().size(); silenceIdx++) {
            Silence silence = (Silence) measure.getSilences().get(silenceIdx);
            posX = TablatureUtil.getStartPosition(measure, silence.getStart(), this.quarterSpan) + 5;                        
            measureComponents.add(new SilenceCoords(this.tablature,this,silence,posX + getTimeSignatureSpan(),30));
        }        
    }

    /**
     * Calcula si hay espacios libres. y crea nuevos silencios
     */   
    private void autoCompleteSilences(){   
    	songManager.getMeasureManager().autoCompleteSilences(measure);
    }    
    
    /**
     * Llama a update de todas las notas del compas
     */
    private void updateComponents() {
        Iterator it = measureComponents.iterator();
        while (it.hasNext()) {
            MeasureComponent component = (MeasureComponent) it.next();
            component.update();
        }
    }

    /**
     * Calcula el width del compas
     */
    public void calculateWidth() {                
        TimeSignature timeSignature = getMeasure().getTimeSignature();
        
        double quartersInSignature = ((1.00 / (double)timeSignature.getDenominator().getValue()) * 4.00) * (double)timeSignature.getNumerator();
        
        this.width = (int)((double)this.quarterSpan * quartersInSignature);
        
        this.width += getTimeSignatureSpan();
        
        this.width += DEFAULT_LEFT_SPAN;
        this.width += DEFAULT_RIGHT_SPAN;        
    }

    /**
     * Calcula el width del compas
     */
    public void calculateHeight(ViewLayout layout) {
    	this.height = (trackCoords.getTrack().getStrings().size() * layout.getStringSpan());
    }

    
    private void orderNotes(){
    	songManager.getMeasureManager().orderNotes(measure);
    }
       
    private void orderComponents(){
        for(int i = 0;i < measureComponents.size();i++){
            MeasureComponent minComponent = null;
            for(int j = i;j < measureComponents.size();j++){
                MeasureComponent component = (MeasureComponent)measureComponents.get(j);
                if(minComponent == null || component.getStart() < minComponent.getStart()){
                    minComponent = component;
                }
            }
            measureComponents.remove(minComponent);
            measureComponents.add(i,minComponent);
        }
    }    
    
    /**
     * Pinta el compas
     */
    public void paintMeasure(ViewLayout layout,GC gc, int fromX, int fromY,Rectangle clientArea,int span) {                
        setOutOfBounds(false);
    	paintTempo(layout,gc, fromX, fromY);
        paintTimeSignature(layout,gc, fromX, fromY);
        paintComponents(layout,gc, fromX, fromY,clientArea);
        paintDivisions(layout,gc, fromX, fromY);
        paintCaret(layout,gc,fromX,fromY);
        paintPlayMode(layout,gc,fromX,fromY);
        this.lastFromX = fromX;
        this.lastFromY = fromY;        
    }
    
    public void paintMeasure(ViewLayout layout,GC gc, int fromX, int fromY,Rectangle clientArea) {
        paintMeasure(layout,gc,fromX,fromY,clientArea,0);
    }    

    /**
     * Pinta las notas
     */
    public void paintComponents(ViewLayout layout,GC gc, int fromX, int fromY,Rectangle clientArea) {             
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent component = (MeasureComponent) measureComponents.get(noteIdx);                         
            
            component.setSpan(getSpanForComponent(component));              
            component.paint(layout,gc, fromX + DEFAULT_LEFT_SPAN , fromY);            
        }
                
    }
    
    /**
     * Pinta las notas
     */
    public void paintCaret(ViewLayout layout,GC gc, int fromX, int fromY) {    	
    	if(layout.isCaretVisible() && hasCaret()){            
            caret.paintCaret(gc, fromX + DEFAULT_LEFT_SPAN + getTimeSignatureSpan() , fromY);
        }
    }    

    /**
     * Pinta las divisiones del compas
     */
    private void paintDivisions(ViewLayout layout,GC gc, int fromX, int fromY) {
        int y1 = fromY + layout.getStringSpan();
        int y2 = fromY + (trackCoords.getTrack().getStrings().size() * layout.getStringSpan());    	
        //principio
        if(measure.isRepeatStart()){
            gc.setLineWidth(3);
            gc.drawLine(fromX, y1, fromX, y2);
            
            gc.drawOval(fromX + 7, y1 + ((y2 - y1) / 2) - 7,1,2);
            gc.drawOval(fromX + 7, y1 + ((y2 - y1) / 2) + 7,1,2);
            
            gc.setLineWidth(1);
            gc.drawLine(fromX + 3, y1, fromX + 3, y2);
        }else if(isFirstMeasure()){
            gc.setLineWidth(3);
            gc.drawLine(fromX, y1, fromX, y2);    
            gc.setLineWidth(1);
            gc.drawLine(fromX + 3, y1, fromX + 3, y2);            
    	}else{
            gc.drawLine(fromX, y1, fromX, y2);
        }
        
        //fin
        if(measure.getNumberOfRepetitions() > 0){            
            gc.setLineWidth(3);
            gc.drawLine(fromX + getWidth() + getSpan(), y1, fromX + getWidth() + getSpan(), y2);            

            gc.drawOval(fromX + getWidth() -8 + getSpan(), y1 + ((y2 - y1) / 2) - 7,2,2);
            gc.drawOval(fromX + getWidth() -8 + getSpan(), y1 + ((y2 - y1) / 2) + 7,2,2);
            
            gc.setLineWidth(1);            
            gc.drawLine(fromX + getWidth() - 3 + getSpan(), y1, fromX + getWidth() - 3 + getSpan(), y2);
            
            gc.drawString("x" + Integer.toString(measure.getNumberOfRepetitions()),fromX + getWidth() - 10 + getSpan(),fromY - 5);
        }else if(isLastMeasure()){
            gc.setLineWidth(3);
            gc.drawLine(fromX + getWidth() + getSpan(), y1, fromX + getWidth() + getSpan(), y2);            
            gc.setLineWidth(1);            
            gc.drawLine(fromX + getWidth() - 3 + getSpan(), y1, fromX + getWidth() - 3 + getSpan(), y2);      
    	}else{        
            gc.drawLine(fromX + getWidth() + getSpan(), y1, fromX + getWidth() + getSpan(), y2);
        }
        
    }

    
    
    private void paintTimeSignature(ViewLayout layout,GC gc, int fromX, int fromY){
        if(this.paintTimeSignature){
        	layout.setTimeSignatureStyle(gc);
        	
        	int center =  (getHeight() / 2);
        	int x = fromX + DEFAULT_LEFT_SPAN + 10;
        	int y1 = fromY + (center - 12);
        	int y2 = fromY + (center + 5);        
        
        	gc.drawString(Integer.toString(getMeasure().getTimeSignature().getNumerator()),x,y1);
        	gc.drawString(Integer.toString(getMeasure().getTimeSignature().getDenominator().getValue()),x,y2);
    
        	layout.setDefaultStyle(gc);
        }
    }
    
    
    private void paintTempo(ViewLayout layout,GC gc, int fromX, int fromY){
        if(this.paintTempo){
            int x = fromX;
            int y = fromY - 10;
            String tempo = "Tempo: " + getMeasure().getTempo().getValue();
            gc.drawString(tempo,x,y);
        }
    }
    
    private void paintPlayMode(ViewLayout layout,GC gc, int fromX, int fromY){
        if(layout.isPlayModeEnabled() && isPlaying()){
            gc.setLineStyle(SWT.LINE_DASH);
            gc.drawRectangle(fromX + 5,fromY,getWidth() + getSpan() - 10,getHeight() + 10);
            gc.setLineStyle(SWT.LINE_SOLID);        
        }        
    }
    
    /**
     * Retorna true si se esta reproduciendo y la posicion del player esta en este compas.
     */    
    public boolean isPlaying(){
        if(this.songManager.getPlayer().isRunning() && getTrackCoords().hasCaret()){
            long playerTickPosition = this.songManager.getPlayer().getTickPosition();
            if(playerTickPosition >= getMeasure().getStart()  && playerTickPosition < getMeasure().getStart() + getMeasure().getLength()){            
                return true;
            }
        }        
        return false;
    }
    
    
    
    public int getSpanForComponent(MeasureComponent component){        
        return  (int)((component.getStart() - getMeasure().getStart())  * getSpan() / getMeasure().getLength());
    }    
    
    /**
     * Retorna el ancho del Compas
     */
    public int getWidth() {
        return this.width;
    }

    /**
     * Retorna el alto del Compas
     */
    public int getHeight() {
        return this.height;
    }

    public int getTimeSignatureSpan(){
        int span = 0;
        if(paintTimeSignature){
            span = DEFAULT_TIME_SIGNATURE_SPAN;
        }
        return span;
    }

    /**
     * Retorna el Componente Anterior
     */
    public MeasureComponent getPreviousComponent(MeasureComponent component) {
        MeasureComponent prevComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);

            if (currComponent.getStart() < component.getStart()) {
                if (prevComponent == null) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() > prevComponent.getStart()) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() == prevComponent.getStart()
                        && currComponent.getDuration().getTime() <= prevComponent.getDuration().getTime()) {
                    prevComponent = currComponent;
                }
            }
        }
        return prevComponent;
    }

    /**
     * Retorna el Siguiente Componente
     */
    public MeasureComponent getNextComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
        }
        return nextComponent;
    }

    
    /**
     * Retorna el Primer Componente
     */
    public MeasureComponent getFirstComponent() {
        MeasureComponent firstComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            if (firstComponent == null || currComponent.getStart() < firstComponent.getStart()) {
                firstComponent = currComponent;
            }
        }
        return firstComponent;
    }    
    
    /**
     * Retorna el Ultimo Componente
     */
    public MeasureComponent getLastComponent() {
        MeasureComponent lastComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            if (lastComponent == null || lastComponent.getStart() < currComponent.getStart()) {
                lastComponent = currComponent;
            }
        }
        return lastComponent;
    }     
    
    /**
     * Retorna Un Componente en la posicion start
     */
    public MeasureComponent getComponent(long start) {
        MeasureComponent component = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            
            if (currComponent.getStart() <= start && (currComponent.getStart() + currComponent.getDuration().getTime() > start)) {
                component = currComponent;
                break;
            }
        }
        return component;
    }        

    /**
     * Retorna Todos los Componentes en la posicion Start
     */
    public List getComponents(long start) {
        List components = new ArrayList();        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() == start) {
                components.add(currComponent);
            }
        }
        return components;
    }            
    
    
    /**
     * Retorna el Componente en la posicion Start, y en la cuerda
     */
    public MeasureComponent getComponent(long start,int string) {
        MeasureComponent component = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {            
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){
                NoteCoords note = (NoteCoords)currComponent;
                if (note.getStart() <= start && (note.getStart() + note.getDuration().getTime() > start) && note.getNote().getString() == string) {
                    component = currComponent;
                    break;
                }
            }
        }
        return component;
    }    
    
    /**
     * Retorna el Componente en la posicion Start, y en la cuerda
     */
    public MeasureComponent getComponentOrSilence(long start,int string) {
        MeasureComponent component = getComponent(start,string);
        if(component == null){
        	component = getComponent(start);
        	if(!(component instanceof SilenceCoords)){
        		component = null;
        	}
        }
        return component;
    }  
    
    /**
     * Retorna Todos los desde Start hasta el final del compas
     */
    public List getComponentsBeforeEnd(long fromStart) {
        List components = new ArrayList();        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() >= fromStart) {
                components.add(currComponent);
            }
        }
        return components;
    }            
    
    
    public List getComponents(){
        return this.measureComponents;
    }
    
    
    /**
     * Retorna el Siguiente Componente en la cuerda. que sea de una nota
     */
    public MeasureComponent getNextNoteComponent(MeasureComponent component,int string) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){                
                Note currNote = ((NoteCoords)currComponent).getNote();
                if(currNote.getString() == string && currNote.getStart() > component.getStart()){
                    if(nextComponent == null || currNote.getStart() < nextComponent.getStart()){
                        nextComponent = currComponent;
                    }
                }                
            }
        }
        return nextComponent;
    }      

    /**
     * Retorna el Siguiente Componente que sea de una nota
     */
    public MeasureComponent getNextNoteComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            }
        }
        return nextComponent;
    }    
    

    /**
     * Retorna el Siguiente Componente que sea de un silencio
     */
    public MeasureComponent getNextSilenceComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof SilenceCoords){
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            }
        }
        return nextComponent;
    }        
    
    
    /**
     * Retorna el componente mas cercano a X
     */    
    public MeasureComponent getComponentAt(int x){  
        MeasureComponent component = null;        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if(component == null){
                component = currComponent;
            }else{                                    
                int distanceX = Math.abs(x - (component.getPointX()));
                int currDistanceX = Math.abs(x - (currComponent.getPointX()));
                if(currDistanceX < distanceX){
                    component = currComponent;
                }
            }
            
        }
        return component;
    }          

    /**
     * Retorna la cuerda en la posicion y
     */
    public InstrumentString getStringAt(int y) {
        InstrumentString string = null;
        int stringSpan = this.tablature.getViewLayout().getStringSpan();
        int minorDistance = 0;
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString currString = (InstrumentString)it.next();                        
            int distanceX = Math.abs(y - ((currString.getNumber() * stringSpan) + this.lastFromY));
            if(string == null || distanceX < minorDistance){
                string = currString;
                minorDistance = distanceX;
            }
        }        
            
        return string;    
    }    
   
    
    public long getBeatLength(){
        return this.beatLength;
    }
        
    public boolean areInSameBeat(MeasureComponent arg0,MeasureComponent arg1){
    	return songManager.getMeasureManager().areInSameBeat(measure,arg0.getComponent(),arg1.getComponent());
    }
    
    /**
     * Retorna true si es el primer compas
     */         
    public boolean isFirstMeasure(){
    	return songManager.getTrackManager().isFirstMeasure(measure);
    }

    /**
     * Retorna true si es el ultimo compas
     */         
    public boolean isLastMeasure(){
    	return songManager.getTrackManager().isLastMeasure(trackCoords.getTrack(),measure);
    }    
    
    /**
     * Reproduce las notas en el pulso
     */
    public void playBeat(long start){
    	if(!this.songManager.getPlayer().isRunning()){
    		List notes = songManager.getMeasureManager().getNotes(measure,start);
    		songManager.getPlayer().playBeat(getTrackCoords().getTrack(),notes);
    	}
    }
    
    /**
     * Retorna true si el Caret esta en este compas
     */     
    public boolean hasCaret() {
        return caret != null;
    }    
    
    /**
     * Retorna el Caret
     */     
    public Caret getCaret() {
        return caret;
    }
    /**
     * Asigna el Caret a este compas 
     */    
    public void setCaret(Caret caret) {
        this.caret = caret;
    }
        
    
    /**
     * Retorna la posicion X dentro del compas 
     */        
    public int getPosX() {
        return posX;
    }
    
    /**
     * Asigna la posicion X dentro del compas 
     */        
    public void setPosX(int posX) {
        this.posX = posX;
    }
    
    /**
     * Retorna la posicion Y dentro del compas 
     */       
    public int getPosY() {
        return posY;
    }
    
    /**
     * Asigna la posicion Y dentro del compas 
     */    
    public void setPosY(int posY) {
        this.posY = posY;
    }
    
    /**
     * Retorna la ultima posicion X asignada 
     */
    public int getLastFromX() {
        return lastFromX;
    }
    /**
     * Retorna la ultima posicion Y asignada 
     */    
    public int getLastFromY() {
        return lastFromY;
    }
    
    
    /**
     * Asigna el span de negras
     */       
    public void setQuarterSpan(int quarterSpan){
        this.quarterSpan = quarterSpan;
    }    
    
    /**
     * Retorna el span de negras
     */       
    public int getQuarterSpan(){
        return this.quarterSpan;
    }
    
    /**
     * Retorna el Compas     
     */
    public Measure getMeasure(){
        return this.measure;
    }   
    
    public int getSpan() {
        return span;
    }
    public void setSpan(int span) {
        this.span = span;
    }
            
    public boolean isOutOfBounds() {
		return outOfBounds;
	}


	public void setOutOfBounds(boolean outOfBounds) {
		this.outOfBounds = outOfBounds;
	}


	public SongTrackCoords getTrackCoords(){
        return this.trackCoords;
    }
}