/*
 * Created on 30-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class Caret {
    private Tablature tablature;
    private SongManager songManager;
    private SongCoords songCoords;
    private SongTrackCoords selectedTrack;
    private MeasureCoords selectedMeasure;
    private MeasureComponent selectedComponent;
    private Duration selectedDuration;
    private int posX;
    private int posY;
    private long position;
    private int string;
    private boolean changes;
    
    public Caret(Tablature tablature,SongManager songManager, SongCoords songCoords) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.songCoords = songCoords;
        this.selectedDuration = new Duration(Duration.QUARTER);
        this.string = 1;
        this.changes = false;
    }

    private void setSelectedMeasureCoords(MeasureCoords selectedMeasure) {
        if (this.selectedMeasure != null) {
            this.selectedMeasure.setCaret(null);
        }
        this.selectedMeasure = selectedMeasure;        
        if (this.selectedMeasure != null) {
            this.selectedMeasure.setCaret(this);
        }
    }

    public synchronized void update(){
    	long trackNumber = (selectedTrack != null)?selectedTrack.getTrack().getNumber():1;    	
    	update(trackNumber,position,string);
    }    
    
    public synchronized void update(long trackNumber){    	
    	update(trackNumber,position,string);
    }      
    
    public synchronized void update(long trackNumber,long position,int string) {                
        SongTrackCoords trackCoords = songCoords.getTrack(trackNumber);
        if(trackCoords == null){
        	trackCoords = songCoords.getFirstTrack();
        }
        if(trackCoords != null){        	
        	MeasureCoords measureCoords = trackCoords.getMeasureCoords(position);
        	if(measureCoords == null){
        		measureCoords = trackCoords.getFirstMeasure();
        	}
        	if(measureCoords != null){
        		MeasureComponent component = measureCoords.getComponentOrSilence(position,string);
        		if (component == null) {
        			component = measureCoords.getComponent(position);
        		}        		
        		if (component == null) {
        			component = measureCoords.getFirstComponent();
        		}
        		moveTo(trackCoords, measureCoords, component,string);
        	}
        }
    }
        	

    public void paintCaret(GC gc, int fromX, int fromY) {
        if (selectedMeasure != null && selectedComponent != null) {
            long start = this.selectedComponent.getStart();
            this.posX = fromX + TablatureUtil.getStartPosition(selectedMeasure.getMeasure(), start, selectedMeasure.getQuarterSpan()) + this.selectedComponent.getSpan() + 4;
            this.posY = fromY + this.string * this.tablature.getViewLayout().getStringSpan() - 7;
            
            gc.drawRectangle(this.posX, this.posY, 13, 15);            
        }
        
    }

    public void setStringNumber(int string){
        this.string = string;
    }
    
    public boolean moveRight() {        
        if (this.selectedComponent != null) {
            MeasureComponent nextComponent = selectedMeasure.getNextComponent(this.selectedComponent);
            if (nextComponent != null) {
                this.selectedComponent = nextComponent;
            } else {
                //si no habia mas componentes. busco el siguiente compas
                MeasureCoords nextMeasureCoords = this.selectedTrack.getNextMeasure(this.selectedMeasure);
                if (nextMeasureCoords == null) {
                    return false;
                }else{
                    this.setSelectedMeasureCoords(nextMeasureCoords);
                    this.selectedComponent = this.selectedMeasure.getFirstComponent();
                }
            }
            this.updatePosition();
            this.updateDuration();  
            this.checkString();
            this.setChanges(true);
        }
        return true;
    }

    public void moveLeft() {
        if (this.selectedComponent != null) {
            MeasureComponent prevComponent = selectedMeasure.getPreviousComponent(this.selectedComponent);
            if (prevComponent != null) {
                this.selectedComponent = prevComponent;
            } else {
                //si no habia mas componentes. busco el compas anterior
                MeasureCoords prevMeasureCoords = this.selectedTrack.getPrevMeasure(this.selectedMeasure);
                if (prevMeasureCoords != null) {
                    this.setSelectedMeasureCoords(prevMeasureCoords);
                    this.selectedComponent = this.selectedMeasure.getLastComponent();
                }
            }
            this.updatePosition();
            this.updateDuration();
            this.checkString();
            this.setChanges(true);
        }
    }

    /**
     * Luego de mover el Caret. cambia la duracion seleccionada por la del componente. solo si lo que resta del compas no esta vacio
     */
    private void updateDuration() {
        if (this.selectedComponent != null) {
            boolean hasNotes = false;
            Iterator it = getMeasureCoords().getComponentsBeforeEnd(getSelectedComponent().getStart()).iterator();
            while (it.hasNext()) {
                MeasureComponent component = (MeasureComponent) it.next();
                if (component instanceof NoteCoords) {
                    hasNotes = true;
                    break;
                }
            }
            if (hasNotes) {
                if(this.selectedComponent instanceof SilenceCoords){
                    long length = this.selectedComponent.getDuration().getTime();
                    
                    MeasureComponent nextComponent = getMeasureCoords().getNextComponent(this.selectedComponent);
                    while(nextComponent != null && nextComponent instanceof SilenceCoords){
                        length += nextComponent.getDuration().getTime();                        
                        nextComponent = getMeasureCoords().getNextComponent(nextComponent);
                    }
                    
                    if(this.selectedDuration.getTime() > length){
                        this.selectedDuration = (Duration) this.selectedComponent.getDuration().clone();   
                    }
                }else{
                    this.selectedDuration = (Duration) this.selectedComponent.getDuration().clone();
                }                                
            }
        }
    }

    public void moveUp() {
        changeString(-1);
    }

    public void moveDown() {
        changeString(1);
    }

    private void changeString(int i) {
        int nextString = this.string + i;
        int trackStrings = this.selectedTrack.getTrack().getStrings().size();
        if (nextString < 1) {
            nextString = trackStrings;
        } else if (nextString > trackStrings) {
            nextString = 1;
        }
        this.string = nextString;
    }

    public long getPosition() {
        return this.position;
    }

    public SongCoords getSongCoords() {
        return this.songCoords;
    }

    public MeasureCoords getMeasureCoords() {
        return this.selectedMeasure;
    }

    public SongTrackCoords getSongTrackCoords() {
        return this.selectedTrack;
    }

    public MeasureComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public Duration getDuration() {
        return this.selectedDuration;
    }

    public void setSelectedDuration(Duration selectedDuration) {
        this.selectedDuration = selectedDuration;
    }

    public InstrumentString getSelectedString() {
        List strings = this.selectedTrack.getTrack().getStrings();
        Iterator it = strings.iterator();
        while (it.hasNext()) {
            InstrumentString instrumentString = (InstrumentString) it.next();
            if (instrumentString.getNumber() == this.string) {
                return instrumentString;
            }
        }
        return null;
    }
    
    public void moveTo(SongTrackCoords selectedTrack, MeasureCoords selectedMeasure, MeasureComponent selectedComponent) {
    	this.moveTo(selectedTrack,selectedMeasure,selectedComponent,this.string);
    }

    public void moveTo(SongTrackCoords selectedTrack, MeasureCoords selectedMeasure, MeasureComponent selectedComponent,int string) {        
    	this.selectedTrack = selectedTrack;
        this.selectedComponent = selectedComponent;
        this.string = string;
        this.setSelectedMeasureCoords(selectedMeasure);
        this.updatePosition();
        this.updateDuration();   
        this.checkString();
    }
    
    public void changeDuration(Duration duration){
    	getSongCoords().getSongManager().getMeasureManager().changeDuration(getMeasureCoords().getMeasure(),getSelectedComponent().getComponent(),duration);
        setChanges(true);
    }
    
    private void updatePosition(){
        this.position = getSelectedComponent().getStart();
    }
    
    private void checkString(){
        int stringCount = getSongTrackCoords().getTrack().getStrings().size();
        if(this.string > stringCount){
            this.string = stringCount;
        }
    }    
    
    public int getPosX(){
        return this.posX;
    }
    
    public int getPosY(){
        return this.posY;
    }    
    
    
    public boolean hasChanges() {
        return changes;
    }
    public void setChanges(boolean changes) {
        this.changes = changes;
    }
}