/*
 * Created on 31-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.chord;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.song.models.Chord;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ChordCreatorUtil {
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;

    private int[] tunning;
    private int[] requiredNotes;
    private int tonic; 
    private int fret1;
    private int fret2;  
    
    
    public ChordCreatorUtil(int[] tunning,int[] requiredNotes,int tonic,int fret1,int fret2) {
        this.tunning = tunning;
        this.requiredNotes = requiredNotes;
        this.tonic = tonic;
        this.fret1 = fret1;
        this.fret2 = fret2;
    }

   

    public Chord getChord() {
        StringValue tonicStringValue = findTonic();

        if (tonicStringValue != null && (tonicStringValue.getString() + 1) < tunning.length) {
            Chord chord = new Chord(this.tunning.length);
            List stringValues = new ArrayList();
            stringValues.add(tonicStringValue);                

            for (int string = (tonicStringValue.getString() + 1); string < tunning.length; string++) {
                StringValue currStringValue = null;
                
                currStringValue = find(string);                         
                
                if (currStringValue != null) {
                    stringValues.add(currStringValue);
                    
                }

            }


            
            Iterator it = stringValues.iterator();
            while(it.hasNext()){
                StringValue stringValue = (StringValue)it.next();
                int string = ((chord.getStrings().length - 1) - (stringValue.getString()));
                int fret = stringValue.getFret();
                chord.addFretValue(string,fret);
            }
            
            chord = check(chord);    
            if(chord.count() > 2){
                return chord;
            }
        }
        return null;
    }

    private StringValue findTonic() {
        for (int string = 0; string < tunning.length; string++) {

            for (int fret = fret1; fret <= fret2; fret++) {

                for (int octave = 0; octave < MAX_OCTAVES; octave++) {
                    int tonicValue = (tonic - 1) + (octave * MAX_NOTES);
                    
                    //calculo la coincidencia de la cegilla
                    if ((tunning[string] + fret) == tonicValue) {
                        return new StringValue(string, fret);
                    }

                }
            }
        }

        return null;
    }

    
    private StringValue find(int string){
        StringValue stringValue = null;    
           
            for (int fret = fret1; fret <= fret2; fret++) {
                StringValue currStringValue = findRequiredNote(string,fret);            
                if(currStringValue != null){
                    if(stringValue == null){
                        stringValue = currStringValue;
                    }else{
                        if(hasPriority(currStringValue,stringValue)){
                            stringValue = currStringValue;
                        }                    
                    }                
                } 
            }                
                             
        return stringValue;
    }
    
    
    private StringValue findRequiredNote(int string,int fret){
        for (int requiredIndex = 0; requiredIndex < requiredNotes.length; requiredIndex++) {

            for (int octave = 0; octave < MAX_OCTAVES; octave++) {
                int tonicValue = (tonic - 1) + (octave * MAX_NOTES);
                int requiredNote = (tonicValue + (requiredNotes[requiredIndex] - 1));

                //calculo la coincidencia de la cegilla
                if ((tunning[string] + fret) == requiredNote) {
                    return new StringValue(string,fret,requiredIndex);
                }

            }

        }        
        return null;
    }
    
    private boolean hasPriority(StringValue value1,StringValue value2){        
        if(value1.getRequiredNoteIndex() < value2.getRequiredNoteIndex()){        
            return true;
        }
        
        return false;
    }
    
    
    private Chord check(Chord chord){        
        int minFret = -1;
        //calculo la primer cegilla
        for(int i = 0;i < chord.getStrings().length;i++){
            int fretValue = chord.getFretValue(i);
            if(minFret < 0 || (fretValue < minFret && fretValue >= 0)){
                minFret = fretValue;
            }
        }
        
        //calculo si el acorde esta bien
        int fretsAfterMin = 0;
        for(int i = 0;i < chord.getStrings().length;i++){
            int fretValue = chord.getFretValue(i);
            if(fretValue > minFret){
                fretsAfterMin++;
            }
        }    
        
        //si pasa el limite.. trato de sacar notas        
        if((minFret == 0 && fretsAfterMin > 4) || (minFret > 0 && fretsAfterMin > 3)){
            boolean firstTonic = false;
            Chord tempChord = null;
            for(int i = (chord.getStrings().length -2);i >= 0;i--){
                int fretValue = chord.getFretValue(i);
                
                if(firstTonic){
                    if(tempChord == null){
                        for (int octave = 0; octave < MAX_OCTAVES; octave++) {
                            int tonicValue = (tonic - 1) + (octave * MAX_NOTES);                   
                            if ((tunning[(tunning.length - i) - 1] + fretValue) == tonicValue) {
                                tempChord = new Chord((chord.getStrings().length));
                            }
                        }                
                    }
          
                    if(tempChord != null){
                        tempChord.addFretValue(i,fretValue);
                    }
                }else if(fretValue >= 0){
                    firstTonic = true;
                }
            }
            if(tempChord != null){
                chord = tempChord;
            }            
        }
        return chord;
    }
    
    
    private class StringValue {
        private int string;
        private int fret;
        private int requiredNoteIndex;
        
        public StringValue(int string, int fret,int requiredNoteIndex) {
            this.string = string;
            this.fret = fret;
            this.requiredNoteIndex = requiredNoteIndex;
        }
        
        public StringValue(int string, int fret) {
            this(string,fret,-1);
        }
        
        
        public int getString() {
            return string;
        }

        public void setString(int string) {
            this.string = string;
        }

        public int getFret() {
            return fret;
        }

        public void setFret(int fret) {
            this.fret = fret;
        }
        
 
        public int getRequiredNoteIndex() {
            return requiredNoteIndex;
        }
        public void setRequiredNoteIndex(int requiredNoteIndex) {
            this.requiredNoteIndex = requiredNoteIndex;
        }
    }


}