/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.player;

import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Display;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.play.models.Player;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class PlaySongAction extends Action {
    public static final String NAME = "PLAY_SONG";

    private Player player;

    public PlaySongAction(TablatureEditor tablatureEditor) {
        super(NAME,true, tablatureEditor);
        this.player = getEditor().getSongManager().getPlayer();
    }

    public boolean doAction(TypedEvent e) {
    	if(!player.isRunning()){
    		player.play();
    		redrawTablature();
    		return true;
    	}
        return false;
    }

    protected void redrawTablature() {
        final Display display = TuxGuitar.instance().getDisplay();
        final Runnable playing = new Runnable() {
            public void run() {
            	if(getEditor().getSongManager().getPlayer().isRunning()){
            		TuxGuitar.instance().redrawPayingMode();
            	}
            }
        };
        final Runnable finish = new Runnable() {
            public void run() {
                update();
                redraw();
            }
        };
        new Thread(new Runnable() {
            public void run() {
                while (player.isRunning()) {
                    if(!display.isDisposed()){
                        display.syncExec(playing);    
                        sleep(80);
                    }
                }
                if(!display.isDisposed()){
                    display.syncExec(finish);
                }
            }
        }).start();
    }

    private void sleep(long time){
    	try {
			Thread.sleep(time);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
    }
}