/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.insert;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.chord.ChordEditor;
import org.herac.tuxguitar.gui.chord.ChordList;
import org.herac.tuxguitar.gui.chord.ChordSelector;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.component.UndoableComponentGeneric;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class InsertChordAction extends Action {
    public static final String NAME = "INSERT_CHORD";
    private ChordEditor editor;
    private ChordSelector selector;
    private ChordList list;
    
    public InsertChordAction(TablatureEditor tablatureEditor) {
        super(NAME,true, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        showInsertDialog(getEditor().getTablature().getShell());
        return true;
    }

    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }

    public void showInsertDialog(Shell shell) {
        Caret caret = getEditor().getTablature().getCaret();
        final SongTrackCoords trackCoords = caret.getSongTrackCoords();
        final MeasureCoords measureCoords = caret.getMeasureCoords();
        final MeasureComponent component = caret.getSelectedComponent();
        if (trackCoords != null && measureCoords != null && component != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            dialog.setLayout(layout);
            dialog.setText(TuxGuitar.getProperty("chord.editor"));
            
            Composite editorComposite = new Composite(dialog, SWT.NONE);
            editorComposite.setLayout(new GridLayout(2, false));

            this.selector = new ChordSelector(editorComposite,SWT.NONE);
            
            this.editor = new ChordEditor(editorComposite, SWT.BORDER,(short)caret.getSongTrackCoords().getTrack().getStrings().size());
            this.editor.setLayoutData(new GridData(editor.getWidth() + (ChordEditor.STRING_SPAN * 2), editor.getHeight() + (ChordEditor.FRET_SPAN * 2)));
            this.setCurrentChord();
            
            
            
            this.list = new ChordList(dialog);
            
            
            this.selector.setEditor(this.editor);
            this.selector.setList(this.list);
            this.selector.setTunning(getTunning(trackCoords));
            this.list.setEditor(this.editor);
            
            Composite buttonComposite = new Composite(dialog, SWT.NONE);
            buttonComposite.setLayout(new GridLayout(2, false));
            GridData buttonData = new GridData();
            buttonData.horizontalAlignment = GridData.END;
            buttonComposite.setLayoutData(buttonData);

            final Button buttonOK = new Button(buttonComposite, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    insertChord(editor, trackCoords, measureCoords, component);
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttonComposite, SWT.PUSH);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }	  
        }
    }
    
    
    private int[] getTunning(SongTrackCoords trackCoords){
        int[] tunning = new int[trackCoords.getTrack().getStrings().size()];
        
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();
            tunning[(tunning.length - string.getNumber())] = string.getValue();
        }                
        
        return tunning;
    }    

    private void insertChord(ChordEditor editor, SongTrackCoords trackCoords, MeasureCoords measureCoords, MeasureComponent component) {
        //comienza el undoable
    	UndoableComponentGeneric undoable = UndoableComponentGeneric.startUndo(); 
    	
        getSongManager().getMeasureManager().removeAllComponentsAt(measureCoords.getMeasure(),component.getStart());        
        
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while (it.hasNext()) {
            InstrumentString string = (InstrumentString) it.next();

            int value = editor.getValue(string.getNumber());
            if (value >= 0) {                
                Note note = new Note(value, component.getStart(), (Duration) component.getDuration().clone(), 64, string.getNumber(),false, new NoteEffect());
                getSongManager().getMeasureManager().addNote(measureCoords.getMeasure(),note);
            }
        }

        fireUpdate(measureCoords.getMeasure().getNumber());
        redraw();
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo());   
    }
    
    private void setCurrentChord(){
        Caret caret = getEditor().getTablature().getCaret();          
        if(caret.getSelectedComponent() instanceof NoteCoords){
            int maxValue = -1;
            int minValue = -1;
            List components = caret.getMeasureCoords().getComponents(caret.getSelectedComponent().getStart());
            
            //verifico el fret
            Iterator it = components.iterator();
            while(it.hasNext()){
                MeasureComponent component = (MeasureComponent)it.next();
                if(component instanceof NoteCoords){
                    NoteCoords noteCoords = (NoteCoords)component; 
                    if(maxValue < 0 || maxValue < noteCoords.getNote().getValue()){
                        maxValue = noteCoords.getNote().getValue();
                    }
                    if(minValue < 0 || minValue > noteCoords.getNote().getValue()){
                        minValue = noteCoords.getNote().getValue();
                    }                    
                }
            }            
            if(maxValue > ChordEditor.VIEWING_FRETS  && minValue >= 0){
                this.editor.setFret((short)(minValue));
            }
            
            //agrego los valores
            it = components.iterator();
            while(it.hasNext()){
                MeasureComponent component = (MeasureComponent)it.next();
                if(component instanceof NoteCoords){
                    NoteCoords noteCoords = (NoteCoords)component; 
                    this.editor.addValue(noteCoords.getNote().getValue(),noteCoords.getNote().getString());              
                }
            }              
        }
                
    }
}