package org.herac.tuxguitar.gui;

import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.song.models.Duration;

public class SystemImages {
	private static final Image[] DURATIONS = new Image[]{ 
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"1.png")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"2.png")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"4.png")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"8.png")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"16.png")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"32.png")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"64.png"))
	};	
	private static final Image[] SILENCES = new Image[]{ 
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"silence1.gif")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"silence2.gif")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"silence4.gif")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"silence8.gif")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"silence16.gif")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"silence32.gif")),
		new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"silence64.gif"))
	};
	public static final Image BEND_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"bend1.gif"));	
	public static final Image FRETBOARD_FIRST_FRET_IMAGE = new Image(TuxGuitar.instance().getDisplay(), TuxGuitar.getResourcePath(null, "firstfret.png"));
	public static final Image FRETBOARD_FRET_IMAGE = new Image(TuxGuitar.instance().getDisplay(), TuxGuitar.getResourcePath(null, "fret.png"));			
	
	
	public static final Image TIME_SIGNATURE_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"timesignature.png"));
	public static final Image DOTTED_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"dotted.png"));
	public static final Image DOUBLE_DOTTED_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"doubledotted.png"));
	public static final Image TUPLETO_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"tupleto.png"));
	public static final Image UNDO_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"undo.png"));
	public static final Image REDO_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"redo.png"));
	public static final Image NEW_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"new.png"));
	public static final Image OPEN_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"open.png"));
	public static final Image SAVE_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"save.png"));
	public static final Image CHORD_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"chord.png"));
	public static final Image TIED_NOTE_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"tiednote.png"));
	public static final Image DEAD_NOTE_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"deadnote.png"));
	public static final Image PLAY_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"play.gif"));
	public static final Image STOP_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"stop.png"));
	public static final Image OPEN_REPEAT_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"openrepeat.png"));
	public static final Image CLOSE_REPEAT_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"closerepeat.png"));
	public static final Image FRETBOARD_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"fretboard.png"));
	public static final Image MIXER_IMAGE = new Image(TuxGuitar.instance().getDisplay(),TuxGuitar.getResourcePath(null,"mixer.png"));
	
	public static final Image getDuration(int value){
		switch(value){
		case Duration.WHOLE:
			return DURATIONS[0];
		case Duration.HALF:
			return DURATIONS[1];			
		case Duration.QUARTER:
			return DURATIONS[2];
		case Duration.EIGHTH:
			return DURATIONS[3];
		case Duration.SIXTEENTH:
			return DURATIONS[4];
		case Duration.THIRTY_SECOND:
			return DURATIONS[5];
		case Duration.SIXTY_FOURTH:
			return DURATIONS[6];			
		}
		return null;
	}	
	
	public static final Image getSilence(int value){
		switch(value){
		case Duration.WHOLE:
			return SILENCES[0];
		case Duration.HALF:
			return SILENCES[1];			
		case Duration.QUARTER:
			return SILENCES[2];
		case Duration.EIGHTH:
			return SILENCES[3];
		case Duration.SIXTEENTH:
			return SILENCES[4];
		case Duration.THIRTY_SECOND:
			return SILENCES[5];
		case Duration.SIXTY_FOURTH:
			return SILENCES[6];			
		}
		return null;
	}
	
	public static void disposeImages(){
		for(int i = 0;i < DURATIONS.length;i++){
			DURATIONS[i].dispose();
		}
		for(int i = 0;i < SILENCES.length;i++){
			SILENCES[i].dispose();
		}
		BEND_IMAGE.dispose();
		FRETBOARD_FIRST_FRET_IMAGE.dispose();
		FRETBOARD_FRET_IMAGE.dispose();		
		TIME_SIGNATURE_IMAGE.dispose();
		DOTTED_IMAGE.dispose();
		DOUBLE_DOTTED_IMAGE.dispose();
		TUPLETO_IMAGE.dispose();
		UNDO_IMAGE.dispose();
		REDO_IMAGE.dispose();
		NEW_IMAGE.dispose();
		OPEN_IMAGE.dispose();
		SAVE_IMAGE.dispose();
		CHORD_IMAGE.dispose();
		TIED_NOTE_IMAGE.dispose();
		DEAD_NOTE_IMAGE.dispose();
		PLAY_IMAGE.dispose();
		STOP_IMAGE.dispose();
		OPEN_REPEAT_IMAGE.dispose();
		CLOSE_REPEAT_IMAGE.dispose();
		FRETBOARD_IMAGE.dispose();
		MIXER_IMAGE.dispose();		
	}
}
