/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;

public class SongTrackManager {
    private SongManager songManager;

    public SongTrackManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public int countMeasures(SongTrack songTrack) {
        return songTrack.getMeasures().size();
    }

    public Measure getFirstMeasure(SongTrack songTrack) {
        Measure measure = null;
        for (int i = 0; i < songTrack.getMeasures().size(); ++i) {
            Measure measure2 = (Measure)songTrack.getMeasures().get(i);
            if (measure != null && measure2.getStart() >= measure.getStart()) continue;
            measure = measure2;
        }
        return measure;
    }

    public Measure getLastMeasure(SongTrack songTrack) {
        int n = songTrack.getMeasures().size() - 1;
        return (Measure)songTrack.getMeasures().get(n);
    }

    public Measure getPrevMeasure(SongTrack songTrack, Measure measure) {
        int n = measure.getNumber() - 1;
        if (n > 0) {
            return (Measure)songTrack.getMeasures().get(n - 1);
        }
        return null;
    }

    public Measure getNextMeasure(SongTrack songTrack, Measure measure) {
        int n = measure.getNumber();
        if (n < songTrack.getMeasures().size()) {
            return (Measure)songTrack.getMeasures().get(n);
        }
        return null;
    }

    public Measure getMeasureAt(SongTrack songTrack, long l) {
        for (Measure measure : songTrack.getMeasures()) {
            long l2 = measure.getStart();
            long l3 = measure.getLength();
            if (l < l2 || l >= l2 + l3) continue;
            return measure;
        }
        return null;
    }

    public Measure getMeasure(SongTrack songTrack, int n) {
        for (int i = 0; i < songTrack.getMeasures().size(); ++i) {
            Measure measure = (Measure)songTrack.getMeasures().get(i);
            if (measure.getNumber() != n) continue;
            return measure;
        }
        return null;
    }

    public List getMeasuresBeforeEnd(SongTrack songTrack, long l) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : songTrack.getMeasures()) {
            if (measure.getStart() < l) continue;
            arrayList.add(measure);
        }
        return arrayList;
    }

    public List getMeasuresBetween(SongTrack songTrack, long l, long l2) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : songTrack.getMeasures()) {
            long l3 = measure.getStart();
            if (l3 < l || l3 > l2) continue;
            arrayList.add(measure);
        }
        return arrayList;
    }

    public void addNewMeasureBeforeEnd(SongTrack songTrack) {
        this.addNewMeasureAfter(songTrack, this.getLastMeasure(songTrack));
    }

    public void addNewMeasureAfter(SongTrack songTrack, Measure measure) {
        Serializable serializable2;
        long l = measure.getStart();
        long l2 = measure.getLength();
        List list = this.getMeasuresBeforeEnd(songTrack, l + 1L);
        for (Serializable serializable2 : list) {
            this.moveMeasure(songTrack, (Measure)serializable2, l2, 1);
        }
        serializable2 = (TimeSignature)measure.getTimeSignature().clone();
        Tempo tempo = (Tempo)measure.getTempo().clone();
        int n = measure.getNumber() + 1;
        long l3 = l + l2;
        boolean bl = false;
        int n2 = 0;
        this.addMeasure(songTrack, new Measure(n, l3, new ArrayList(), new ArrayList(), (TimeSignature)serializable2, tempo, bl, n2));
    }

    public List copyMeasures(SongTrack songTrack, long l, long l2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Measure measure : this.getMeasuresBetween(songTrack, l, l2)) {
            arrayList.add(measure.clone());
        }
        return arrayList;
    }

    public void insertMeasures(SongTrack songTrack, List list, int n) {
        long l = -1L;
        long l2 = 0L;
        Iterator iterator = null;
        if (!list.isEmpty()) {
            l = ((Measure)list.get(0)).getStart();
            l2 = ((Measure)list.get(list.size() - 1)).getStart() + ((Measure)list.get(list.size() - 1)).getLength();
            for (Measure measure : this.getMeasuresBeforeEnd(songTrack, l)) {
                this.moveMeasure(songTrack, measure, l2 - l, list.size());
            }
            for (Measure measure : list) {
                measure.setNumber(n);
                this.addMeasure(songTrack, measure.getNumber() - 1, measure);
                ++n;
            }
        }
        this.songManager.calculateMeasureStartWidthRepetitions();
    }

    public void addMeasure(SongTrack songTrack, Measure measure) {
        songTrack.getMeasures().add(measure);
    }

    public void addMeasure(SongTrack songTrack, int n, Measure measure) {
        songTrack.getMeasures().add(n, measure);
    }

    public void removeMeasures(SongTrack songTrack, long l, long l2) {
        ArrayList arrayList = new ArrayList();
        for (Measure measure : this.getMeasuresBetween(songTrack, l, l2)) {
            this.removeMeasure(songTrack, measure);
        }
    }

    public void removeMeasure(SongTrack songTrack, long l) {
        this.removeMeasure(songTrack, this.getMeasureAt(songTrack, l));
    }

    public void removeMeasure(SongTrack songTrack, Measure measure) {
        long l = measure.getStart();
        long l2 = measure.getLength();
        List list = this.getMeasuresBeforeEnd(songTrack, l + 1L);
        for (Measure measure2 : list) {
            this.moveMeasure(songTrack, measure2, -l2, -1);
        }
        songTrack.getMeasures().remove(measure);
    }

    public Measure replaceMeasure(SongTrack songTrack, Measure measure) {
        Measure measure2 = this.getMeasureAt(songTrack, measure.getStart());
        measure2.makeEqual(measure);
        return measure2;
    }

    public void moveMeasure(SongTrack songTrack, Measure measure, long l, int n) {
        this.songManager.getMeasureManager().moveAllNotes(measure, l);
        this.songManager.getMeasureManager().moveAllSilences(measure, l);
        measure.setNumber(measure.getNumber() + n);
        measure.setStart(measure.getStart() + l);
    }

    public void changeTimeSignature(SongTrack songTrack, long l, TimeSignature timeSignature, boolean bl) {
        this.changeTimeSignature(songTrack, this.getMeasureAt(songTrack, l), timeSignature, bl);
    }

    public void changeTimeSignature(SongTrack songTrack, Measure measure, TimeSignature timeSignature, boolean bl) {
        measure.setTimeSignature((TimeSignature)timeSignature.clone());
        long l = measure.getStart() + measure.getLength();
        List list = this.getMeasuresBeforeEnd(songTrack, measure.getStart() + 1L);
        for (Measure measure2 : list) {
            long l2 = l - measure2.getStart();
            this.moveMeasure(songTrack, measure2, l2, 0);
            if (bl) {
                measure2.setTimeSignature((TimeSignature)timeSignature.clone());
            }
            l = measure2.getStart() + measure2.getLength();
        }
    }

    public void changeTempo(SongTrack songTrack, long l, Tempo tempo, boolean bl) {
        this.changeTempo(songTrack, this.getMeasureAt(songTrack, l), tempo, bl);
    }

    public void changeTempo(SongTrack songTrack, Measure measure, Tempo tempo, boolean bl) {
        measure.setTempo((Tempo)tempo.clone());
        if (bl) {
            List list = this.getMeasuresBeforeEnd(songTrack, measure.getStart() + 1L);
            for (Measure measure2 : list) {
                measure2.setTempo((Tempo)tempo.clone());
            }
        }
    }

    public void changeOpenRepeat(SongTrack songTrack, long l) {
        Measure measure;
        measure.setRepeatStart(!(measure = this.getMeasureAt(songTrack, l)).isRepeatStart());
    }

    public void changeCloseRepeat(SongTrack songTrack, long l, int n) {
        Measure measure = this.getMeasureAt(songTrack, l);
        measure.setNumberOfRepetitions(n);
    }

    public void changeInfo(SongTrack songTrack, String string, TrackColor trackColor) {
        songTrack.setName(string);
        songTrack.setColor(trackColor);
    }

    public void changeInstrumentStrings(SongTrack songTrack, List list) {
        if (list.size() < songTrack.getStrings().size()) {
            this.removeNotesAfterString(songTrack, list.size());
        }
        songTrack.setStrings(list);
    }

    public void removeNotesAfterString(SongTrack songTrack, int n) {
        for (Measure measure : songTrack.getMeasures()) {
            this.songManager.getMeasureManager().removeNotesAfterString(measure, n);
        }
    }

    public void changeInstrument(SongTrack songTrack, int n, boolean bl) {
        songTrack.getChannel().setInstrument((short)n);
        if (bl) {
            songTrack.getChannel().setChannel((short)9);
            songTrack.getChannel().setEffectChannel((short)9);
            songTrack.setStrings(SongManager.createPercusionStrings(songTrack.getStrings().size()));
        } else if (songTrack.getChannel().isPercusionChannel()) {
            SongChannel songChannel = this.songManager.getFreeChannel((short)n, false);
            songTrack.getChannel().setChannel(songChannel.getChannel());
            songTrack.getChannel().setEffectChannel(songChannel.getEffectChannel());
        }
        this.songManager.updateChannel(songTrack.getChannel());
    }

    public List getCloneMeasures(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Measure measure : list) {
            arrayList.add(measure.clone());
        }
        return arrayList;
    }

    public boolean isFirstMeasure(Measure measure) {
        return measure.getNumber() == 1;
    }

    public boolean isLastMeasure(SongTrack songTrack, Measure measure) {
        return this.countMeasures(songTrack) == measure.getNumber();
    }
}

