/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableRemoveMeasure
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long p1;
    private long p2;
    private List[] trackMeasures;

    public UndoableRemoveMeasure(long l, long l2) {
        Caret caret = UndoableRemoveMeasure.getCaret();
        this.doAction = 1;
        this.undoCaret = new UndoableCaretHelper();
        this.p1 = l;
        this.p2 = l2;
        this.trackMeasures = TuxGuitar.instance().getSongManager().copyMeasures(l, l2);
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().removeMeasures(this.p1, this.p2);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        int n = 0;
        SongManager songManager = TuxGuitar.instance().getSongManager();
        Measure measure = songManager.getTrackManager().getMeasureAt(songManager.getFirstTrack(), this.p1);
        n = measure == null ? songManager.getTrackManager().getLastMeasure(songManager.getFirstTrack()).getNumber() + 1 : measure.getNumber();
        for (int i = 0; i < this.trackMeasures.length; ++i) {
            List list = songManager.getTrackManager().getCloneMeasures(this.trackMeasures[i]);
            SongTrack songTrack = songManager.getTrack(i + 1);
            TuxGuitar.instance().getSongManager().getTrackManager().insertMeasures(songTrack, list, n);
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    public UndoableRemoveMeasure endUndo() {
        this.redoCaret = new UndoableCaretHelper();
        return this;
    }
}

