/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

public class LinearViewLayout
extends ViewLayout {
    public LinearViewLayout(Tablature tablature, SongManager songManager, boolean bl) {
        super(tablature, songManager, bl);
    }

    public void paintSong(GC gC, Rectangle rectangle, int n, int n2) {
        if (this.isMultitrack()) {
            this.paintTracks(this.getTablature().getCaret().getSongCoords().getTrackCoords(), gC, rectangle, n, n2);
        } else {
            ArrayList<SongTrackCoords> arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
            this.paintTracks(arrayList, gC, rectangle, n, n2);
        }
    }

    public void paintTracks(List list, GC gC, Rectangle rectangle, int n, int n2) {
        int n3 = n2 + 50;
        int n4 = 0;
        for (int i = 0; i < list.size(); ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(i);
            songTrackCoords.paintTrack(this, gC, n, n3, rectangle);
            this.paintStrings(songTrackCoords, gC, n3, rectangle);
            n3 += 150;
            n4 += 150;
        }
        this.setHeight(n4 + 100);
    }

    public void paintMeasures(SongTrackCoords songTrackCoords, List list, GC gC, int n, int n2, Rectangle rectangle) {
        songTrackCoords.setPosY(n2);
        int n3 = songTrackCoords.getPosX();
        int n4 = songTrackCoords.getPosY();
        int n5 = 0;
        for (int i = 0; i < list.size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)list.get(i);
            measureCoords.setPosX(n3);
            measureCoords.setPosY(n4);
            if (n3 + n > rectangle.x - 1500 && n3 + n < rectangle.x + rectangle.width + 100) {
                this.paintMeasure(measureCoords, gC, n3 + n, n4, 0, rectangle);
            }
            n5 = n3 += measureCoords.getWidth();
        }
        this.setWidth(n5);
    }

    public void paintStrings(SongTrackCoords songTrackCoords, GC gC, int n, Rectangle rectangle) {
        int n2 = 20 - this.getTablature().getHorizontalBar().getSelection();
        n2 = n2 < 0 ? 0 : n2;
        for (InstrumentString instrumentString : songTrackCoords.getTrack().getStrings()) {
            int n3 = instrumentString.getNumber() * this.getStringSpan();
            gC.drawLine(n2, n + n3, n2 + rectangle.width, n + n3);
        }
    }

    public void followMeasure(MeasureCoords measureCoords, boolean bl) {
        this.getTablature().moveScrollHorizontalTo(measureCoords, 50, this.getTablature().getClientArea().width - 100, bl);
    }

    public SongTrackCoords getTrackAt(List arrayList, int n, int n2) {
        if (!this.isMultitrack()) {
            arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
        }
        SongTrackCoords songTrackCoords = null;
        int n3 = 50 + n2;
        for (int i = 0; i < arrayList.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)arrayList.get(i);
            int n4 = songTrackCoords2.getWidth();
            int n5 = songTrackCoords2.getHeight();
            if (n >= n3 && n <= n3 + n5) {
                songTrackCoords = songTrackCoords2;
            }
            n3 += 150;
        }
        return songTrackCoords;
    }
}

