/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;

public class ViewToolItems
implements ItemContainer {
    private ToolBar toolBar;
    private ToolItem showFretBoard;
    private ToolItem showMixer;

    public ViewToolItems(ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public void showItems() {
        this.showFretBoard = new ToolItem(this.toolBar, 32);
        this.showFretBoard.setImage(SystemImages.FRETBOARD_IMAGE);
        this.showFretBoard.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SHOW_FRETBOARD"));
        this.showMixer = new ToolItem(this.toolBar, 32);
        this.showMixer.setImage(SystemImages.MIXER_IMAGE);
        this.showMixer.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SHOW_MIXER"));
        this.loadProperties();
    }

    public void update() {
        this.showFretBoard.setSelection(TuxGuitar.instance().getFretBoardEditor().getFretBoard().isVisible());
        this.showMixer.setSelection(!TuxGuitar.instance().getMixer().isDisposed());
    }

    public void loadProperties() {
        this.showFretBoard.setToolTipText(TuxGuitar.getProperty("show-fretboard"));
        this.showMixer.setToolTipText(TuxGuitar.getProperty("show-mixer"));
    }
}

