/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.settings;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.config.SystemConfigManager;

public class EditConfigAction
extends Action {
    public static final String NAME = "EDIT_CONFIG";
    private SystemConfigManager config = TuxGuitar.instance().getConfig();
    private Shell dialog;
    private Option[] options;

    public EditConfigAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        this.dialog = new Shell(shell, 67680);
        FormLayout formLayout = new FormLayout();
        FormData formData = new FormData(320, 300);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.dialog.setLayout((Layout)formLayout);
        this.dialog.setLayoutData((Object)formData);
        this.dialog.setText(TuxGuitar.getProperty("settings.config"));
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(85, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)formData);
        this.createComposites(composite);
        formData = new FormData();
        formData.top = new FormAttachment(85, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(60, 0);
        formData.right = new FormAttachment(100, 0);
        Composite composite2 = new Composite((Composite)this.dialog, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        composite2.setLayoutData((Object)formData);
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditConfigAction.this.updateOptions();
                EditConfigAction.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditConfigAction.this.dialog.dispose();
            }
        });
        this.dialog.pack();
        this.dialog.open();
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
    }

    private void createComposites(Composite composite) {
        SashForm sashForm = new SashForm(composite, 0);
        ToolBar toolBar = new ToolBar((Composite)sashForm, 2560);
        Composite composite2 = new Composite((Composite)sashForm, 0);
        composite2.setLayout((Layout)new FormLayout());
        this.initOptions(toolBar, composite2);
        this.select(this.options[0]);
        sashForm.setWeights(new int[]{1, 3});
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.bottom = new FormAttachment(100, -10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, -10);
        sashForm.setLayoutData((Object)formData);
    }

    private void initOptions(ToolBar toolBar, Composite composite) {
        this.options = new Option[2];
        this.options[0] = new ViewOption(this.config, toolBar, composite);
        this.options[1] = new LanguageOption(this.config, toolBar, composite);
        for (int i = 0; i < this.options.length; ++i) {
            this.options[i].createOption();
        }
    }

    private void select(Option option) {
        this.hideAll();
        option.setVisible(true);
        this.dialog.layout();
    }

    private void hideAll() {
        for (int i = 0; i < this.options.length; ++i) {
            this.options[i].setVisible(false);
            this.options[i].setVisible(false);
        }
    }

    private void updateOptions() {
        this.config.clear();
        for (int i = 0; i < this.options.length; ++i) {
            this.options[i].updateConfig();
            this.options[i].updateConfig();
        }
        this.config.save();
    }

    private class LanguageOption
    extends Option {
        private Button[] languages;

        public LanguageOption(SystemConfigManager systemConfigManager, ToolBar toolBar, Composite composite) {
            super(systemConfigManager, toolBar, composite);
        }

        public void createOption() {
            this.getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));
            this.getToolItem().setImage(new Image((Device)EditConfigAction.this.getEditor().getTablature().getDisplay(), TuxGuitar.getResourcePath((Object)this, "langoption.gif")));
            this.getToolItem().addSelectionListener((SelectionListener)this);
            this.getGroup().setText(TuxGuitar.getProperty("settings.config.language"));
            this.getGroup().setLayout((Layout)new GridLayout());
            this.getGroup().setLayoutData((Object)this.getFullData());
            Label label = new Label((Composite)this.getGroup(), 0);
            label.setText(TuxGuitar.getProperty("settings.config.language.choose"));
            GridData gridData = new GridData();
            gridData.horizontalIndent = 20;
            String string = this.getConfig().getStringConfigValue("LANGUAGE");
            String[] stringArray = TuxGuitar.instance().getLanguageManager().getLanguages();
            this.languages = new Button[stringArray.length];
            for (int i = 0; i < this.languages.length; ++i) {
                this.languages[i] = new Button((Composite)this.getGroup(), 16);
                this.languages[i].setData((Object)stringArray[i]);
                this.languages[i].setLayoutData((Object)gridData);
                this.languages[i].setText(TuxGuitar.getProperty(stringArray[i]));
                if (!stringArray[i].equals(string)) continue;
                this.languages[i].setSelection(true);
            }
        }

        public void updateConfig() {
            String string = "";
            for (int i = 0; i < this.languages.length; ++i) {
                if (!this.languages[i].getSelection()) continue;
                string = (String)this.languages[i].getData();
            }
            this.getConfig().setProperty("LANGUAGE", string);
        }
    }

    private class ViewOption
    extends Option {
        private static final int MIN_WIDHT = 640;
        private static final int MIN_HEIGHT = 480;
        private Button mixer;
        private Button fretBoard;
        private Button maximized;
        private Button multitrack;
        private Button[] layoutModes;
        private Spinner width;
        private Spinner height;

        public ViewOption(SystemConfigManager systemConfigManager, ToolBar toolBar, Composite composite) {
            super(systemConfigManager, toolBar, composite);
        }

        public void createOption() {
            this.getToolItem().setText(TuxGuitar.getProperty("settings.config.view"));
            this.getToolItem().setImage(new Image((Device)EditConfigAction.this.getEditor().getTablature().getDisplay(), TuxGuitar.getResourcePath((Object)this, "viewoption.gif")));
            this.getToolItem().addSelectionListener((SelectionListener)this);
            this.getGroup().setText(TuxGuitar.getProperty("settings.config.view"));
            this.getGroup().setLayout((Layout)new GridLayout());
            this.getGroup().setLayoutData((Object)this.getFullData());
            Label label = new Label((Composite)this.getGroup(), 0);
            label.setText(TuxGuitar.getProperty("settings.config.view.mode"));
            GridData gridData = new GridData();
            gridData.horizontalIndent = 20;
            this.mixer = new Button((Composite)this.getGroup(), 32);
            this.mixer.setText(TuxGuitar.getProperty("show-mixer"));
            this.mixer.setLayoutData((Object)gridData);
            this.mixer.setSelection(this.getConfig().getBooleanConfigValue("SHOW_MIXER"));
            this.fretBoard = new Button((Composite)this.getGroup(), 32);
            this.fretBoard.setText(TuxGuitar.getProperty("show-fretboard"));
            this.fretBoard.setLayoutData((Object)gridData);
            this.fretBoard.setSelection(this.getConfig().getBooleanConfigValue("SHOW_FRETBOARD"));
            this.multitrack = new Button((Composite)this.getGroup(), 32);
            this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
            this.multitrack.setLayoutData((Object)gridData);
            this.multitrack.setSelection(this.getConfig().getBooleanConfigValue("SHOW_MULTITRACK"));
            this.layoutModes = new Button[2];
            this.layoutModes[0] = new Button((Composite)this.getGroup(), 16);
            this.layoutModes[0].setText(TuxGuitar.getProperty("layout.page"));
            this.layoutModes[0].setLayoutData((Object)gridData);
            this.layoutModes[1] = new Button((Composite)this.getGroup(), 16);
            this.layoutModes[1].setText(TuxGuitar.getProperty("layout.linear"));
            this.layoutModes[1].setLayoutData((Object)gridData);
            int n = this.getConfig().getIntConfigValue("LAYOUT_MODE");
            switch (n) {
                case 1: {
                    this.layoutModes[0].setSelection(true);
                    break;
                }
                case 2: {
                    this.layoutModes[1].setSelection(true);
                }
            }
            label = new Label((Composite)this.getGroup(), 0);
            label.setText(TuxGuitar.getProperty("settings.config.view.size"));
            this.maximized = new Button((Composite)this.getGroup(), 32);
            this.maximized.setText(TuxGuitar.getProperty("settings.config.view.size.maximized"));
            this.maximized.setLayoutData((Object)gridData);
            this.maximized.setSelection(this.getConfig().getBooleanConfigValue("MAXIMIZED"));
            Composite composite = new Composite((Composite)this.getGroup(), 0);
            composite.setLayout((Layout)new GridLayout(2, true));
            Label label2 = new Label(composite, 0);
            label2.setText(TuxGuitar.getProperty("settings.config.view.size.width"));
            gridData = new GridData();
            gridData.horizontalIndent = 20;
            label2.setLayoutData((Object)gridData);
            this.width = new Spinner(composite, 2048);
            this.width.setMinimum(640);
            this.width.setMaximum(((EditConfigAction)EditConfigAction.this).getEditor().getTablature().getDisplay().getBounds().width);
            this.width.setSelection(this.getConfig().getIntConfigValue("WIDTH"));
            gridData = new GridData();
            gridData.widthHint = 25;
            this.width.setLayoutData((Object)gridData);
            Label label3 = new Label(composite, 0);
            label3.setText(TuxGuitar.getProperty("settings.config.view.size.height"));
            gridData = new GridData();
            gridData.horizontalIndent = 20;
            label3.setLayoutData((Object)gridData);
            this.height = new Spinner(composite, 2048);
            this.height.setMinimum(480);
            this.height.setMaximum(((EditConfigAction)EditConfigAction.this).getEditor().getTablature().getDisplay().getBounds().height);
            this.height.setSelection(this.getConfig().getIntConfigValue("HEIGHT"));
            gridData = new GridData();
            gridData.widthHint = 25;
            this.height.setLayoutData((Object)gridData);
            this.width.setEnabled(!this.maximized.getSelection());
            this.height.setEnabled(!this.maximized.getSelection());
            this.maximized.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ViewOption.this.width.setEnabled(!ViewOption.this.maximized.getSelection());
                    ViewOption.this.height.setEnabled(!ViewOption.this.maximized.getSelection());
                }
            });
        }

        public void updateConfig() {
            for (int i = 0; i < this.layoutModes.length; ++i) {
                if (!this.layoutModes[i].getSelection()) continue;
                this.getConfig().setProperty("LAYOUT_MODE", i + 1);
            }
            this.getConfig().setProperty("SHOW_MULTITRACK", this.multitrack.getSelection());
            this.getConfig().setProperty("SHOW_MIXER", this.mixer.getSelection());
            this.getConfig().setProperty("SHOW_FRETBOARD", this.fretBoard.getSelection());
            this.getConfig().setProperty("MAXIMIZED", this.maximized.getSelection());
            this.getConfig().setProperty("WIDTH", this.width.getSelection());
            this.getConfig().setProperty("HEIGHT", this.height.getSelection());
        }
    }

    private abstract class Option
    extends SelectionAdapter {
        private SystemConfigManager config;
        private ToolBar toolBar;
        private Composite parent;
        private Group group;
        private ToolItem toolItem;

        public Option(SystemConfigManager systemConfigManager, ToolBar toolBar, Composite composite) {
            this.config = systemConfigManager;
            this.toolBar = toolBar;
            this.parent = composite;
            this.toolItem = new ToolItem(toolBar, 16);
            this.group = new Group(composite, 16);
        }

        public abstract void createOption();

        public abstract void updateConfig();

        public void setVisible(boolean bl) {
            this.toolItem.setSelection(bl);
            this.group.setVisible(bl);
        }

        protected FormData getFullData() {
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            return formData;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            EditConfigAction.this.select(this);
        }

        public SystemConfigManager getConfig() {
            return this.config;
        }

        public Group getGroup() {
            return this.group;
        }

        public ToolItem getToolItem() {
            return this.toolItem;
        }
    }
}

