/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.carbon.BitMap;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.PixMap;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int GRAB = 32;
    static final int MOVED = 64;
    static final int RESIZED = 128;
    static final int EXPANDING = 256;
    static final int LAYOUT_NEEDED = 512;
    static final int LAYOUT_CHANGED = 1024;
    static final int IGNORE_WHEEL = 2048;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final Rect EMPTY_RECT = new Rect();

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
    }

    int actionProc(int theControl, int partCode) {
        return 0;
    }

    public void addListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, handler);
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void calculateVisibleRegion(int control, int visibleRgn, boolean clipChildren) {
        int tempRgn = OS.NewRgn();
        if (OS.IsControlVisible(control)) {
            int childRgn = OS.NewRgn();
            int window = OS.GetControlOwner(control);
            short[] count = new short[1];
            int[] outControl = new int[1];
            OS.GetRootControl(window, outControl);
            int root = outControl[0];
            OS.GetControlRegion(root, (short)-1, visibleRgn);
            int tempControl = control;
            int lastControl = 0;
            while (tempControl != root) {
                OS.GetControlRegion(tempControl, (short)-1, tempRgn);
                OS.SectRgn(tempRgn, visibleRgn, visibleRgn);
                if (OS.EmptyRgn(visibleRgn)) break;
                if (clipChildren || tempControl != control) {
                    OS.CountSubControls(tempControl, count);
                    int i = 0;
                    while (i < count[0]) {
                        OS.GetIndexedSubControl(tempControl, (short)(i + 1), outControl);
                        int child = outControl[0];
                        if (child == lastControl) break;
                        if (OS.IsControlVisible(child)) {
                            OS.GetControlRegion(child, (short)-1, tempRgn);
                            OS.UnionRgn(tempRgn, childRgn, childRgn);
                        }
                        ++i;
                    }
                }
                lastControl = tempControl;
                OS.GetSuperControl(tempControl, outControl);
                tempControl = outControl[0];
            }
            OS.DiffRgn(visibleRgn, childRgn, visibleRgn);
            OS.DisposeRgn(childRgn);
        } else {
            OS.CopyRgn(tempRgn, visibleRgn);
        }
        OS.DisposeRgn(tempRgn);
    }

    void checkOpen() {
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    int colorProc(int inControl, int inMessage, int inDrawDepth, int inDrawInColor) {
        return -9874;
    }

    int controlProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 9: {
                return this.kEventControlActivate(nextHandler, theEvent, userData);
            }
            case 5: {
                return this.kEventControlApplyBackground(nextHandler, theEvent, userData);
            }
            case 154: {
                return this.kEventControlBoundsChanged(nextHandler, theEvent, userData);
            }
            case 13: {
                return this.kEventControlClick(nextHandler, theEvent, userData);
            }
            case 12: {
                return this.kEventControlContextualMenuClick(nextHandler, theEvent, userData);
            }
            case 10: {
                return this.kEventControlDeactivate(nextHandler, theEvent, userData);
            }
            case 4: {
                return this.kEventControlDraw(nextHandler, theEvent, userData);
            }
            case 1: {
                return this.kEventControlHit(nextHandler, theEvent, userData);
            }
            case 11: {
                return this.kEventControlSetCursor(nextHandler, theEvent, userData);
            }
            case 7: {
                return this.kEventControlSetFocusPart(nextHandler, theEvent, userData);
            }
            case 51: {
                return this.kEventControlTrack(nextHandler, theEvent, userData);
            }
            case 8: {
                return this.kEventControlGetFocusPart(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    int createCIcon(Image image) {
        int imageHandle = image.handle;
        int width = OS.CGImageGetWidth(imageHandle);
        int height = OS.CGImageGetHeight(imageHandle);
        int bpr = OS.CGImageGetBytesPerRow(imageHandle);
        int bpp = OS.CGImageGetBitsPerPixel(imageHandle);
        int bpc = OS.CGImageGetBitsPerComponent(imageHandle);
        int alphaInfo = OS.CGImageGetAlphaInfo(imageHandle);
        int maskBpl = ((width + 7) / 8 + 3) / 4 * 4;
        int maskSize = height * maskBpl;
        int pixmapSize = height * bpr;
        int iconSize = 82 + maskSize;
        int iconHandle = OS.NewHandle(iconSize);
        if (iconHandle == 0) {
            SWT.error(2);
        }
        OS.HLock(iconHandle);
        int[] iconPtr = new int[1];
        OS.memcpy(iconPtr, iconHandle, 4);
        PixMap iconPMap = new PixMap();
        iconPMap.rowBytes = (short)(bpr | 0x8000);
        iconPMap.right = (short)width;
        iconPMap.bottom = (short)height;
        iconPMap.cmpCount = (short)3;
        iconPMap.cmpSize = (short)bpc;
        iconPMap.pmTable = OS.NewHandle(0);
        iconPMap.hRes = 0x480000;
        iconPMap.vRes = 0x480000;
        iconPMap.pixelType = (short)16;
        iconPMap.pixelSize = (short)bpp;
        iconPMap.pixelFormat = (short)bpp;
        OS.memcpy(iconPtr[0], iconPMap, 50);
        BitMap iconMask = new BitMap();
        iconMask.rowBytes = (short)maskBpl;
        iconMask.right = (short)width;
        iconMask.bottom = (short)height;
        OS.memcpy(iconPtr[0] + 50, iconMask, 14);
        int iconData = OS.NewHandle(pixmapSize);
        OS.HLock(iconData);
        int[] iconDataPtr = new int[1];
        OS.memcpy(iconDataPtr, iconData, 4);
        OS.memcpy(iconDataPtr[0], image.data, pixmapSize);
        OS.HUnlock(iconData);
        OS.memcpy(iconPtr[0] + 50 + 28, new int[]{iconData}, 4);
        if (alphaInfo != 4) {
            OS.memset(iconPtr[0] + 50 + 28 + 4, -1, maskSize);
        } else {
            byte[] srcData = new byte[pixmapSize];
            OS.memcpy(srcData, image.data, pixmapSize);
            byte[] maskData = new byte[maskSize];
            int offset = 0;
            int maskOffset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    if ((srcData[offset] & 0xFF) > 128) {
                        int n = maskOffset + (x >> 3);
                        maskData[n] = (byte)(maskData[n] | 1 << 7 - (x & 7));
                    } else {
                        int n = maskOffset + (x >> 3);
                        maskData[n] = (byte)(maskData[n] & ~(1 << 7 - (x & 7)));
                    }
                    offset += 4;
                    ++x;
                }
                maskOffset += maskBpl;
                ++y;
            }
            OS.memcpy(iconPtr[0] + 50 + 28 + 4, maskData, maskData.length);
        }
        OS.HUnlock(iconHandle);
        return iconHandle;
    }

    void createHandle() {
    }

    int createIconRef(Image image) {
        int dataHandle;
        int dataSize;
        int imageHandle = image.handle;
        int imageData = image.data;
        int width = OS.CGImageGetWidth(imageHandle);
        int height = OS.CGImageGetHeight(imageHandle);
        int bpr = OS.CGImageGetBytesPerRow(imageHandle);
        int alphaInfo = OS.CGImageGetAlphaInfo(imageHandle);
        int type = 0;
        int maskType = 0;
        if (width == 16 && height == 16) {
            type = 1769157426;
            maskType = 1933077867;
        } else if (width == 32 && height == 32) {
            type = 1768698674;
            maskType = 1815637355;
        } else if (width == 48 && height == 48) {
            type = 1768436530;
            maskType = 1748528491;
        } else if (width == 128 && height == 128) {
            type = 1769222962;
            maskType = 1949855083;
        } else {
            int colorspace;
            type = 1769157426;
            maskType = 1933077867;
            int size = 16;
            if (width > 16 || height > 16) {
                type = 1768436530;
                maskType = 1748528491;
                size = 32;
            }
            if (width > 32 || height > 32) {
                type = 1768436530;
                maskType = 1748528491;
                size = 48;
            }
            if (width > 48 || height > 48) {
                type = 1769222962;
                maskType = 1949855083;
                size = 128;
            }
            if ((imageData = OS.NewPtr(dataSize = height * (bpr = (width = (height = size)) * 4))) == 0) {
                SWT.error(2);
            }
            if ((colorspace = OS.CGColorSpaceCreateDeviceRGB()) == 0) {
                SWT.error(2);
            }
            int context = OS.CGBitmapContextCreate(imageData, width, height, 8, bpr, colorspace, 6);
            OS.CGColorSpaceRelease(colorspace);
            if (context == 0) {
                SWT.error(2);
            }
            CGRect rect = new CGRect();
            rect.width = width;
            rect.height = height;
            OS.CGContextDrawImage(context, rect, imageHandle);
            OS.CGContextRelease(context);
        }
        if (type == 0) {
            return 0;
        }
        int iconFamily = OS.NewHandle(0);
        if (iconFamily == 0) {
            SWT.error(2);
        }
        if ((dataHandle = OS.NewHandle(dataSize = height * bpr)) == 0) {
            SWT.error(2);
        }
        int[] dataPtr = new int[1];
        OS.HLock(dataHandle);
        OS.memcpy(dataPtr, dataHandle, 4);
        OS.memcpy(dataPtr[0], imageData, dataSize);
        OS.HUnlock(dataHandle);
        OS.SetIconFamilyData(iconFamily, type, dataHandle);
        OS.DisposeHandle(dataHandle);
        int maskSize = width * height;
        int maskHandle = OS.NewHandle(maskSize);
        if (maskHandle == 0) {
            SWT.error(2);
        }
        OS.HLock(maskHandle);
        int[] maskPtr = new int[1];
        OS.memcpy(maskPtr, maskHandle, 4);
        if (alphaInfo != 4) {
            OS.memset(maskPtr[0], 255, maskSize);
        } else {
            byte[] srcData = new byte[dataSize];
            OS.memcpy(srcData, imageData, dataSize);
            byte[] maskData = new byte[maskSize];
            int offset = 0;
            int maskOffset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    maskData[maskOffset++] = srcData[offset];
                    offset += 4;
                    ++x;
                }
                ++y;
            }
            OS.memcpy(maskPtr[0], maskData, maskData.length);
        }
        OS.HUnlock(maskHandle);
        OS.SetIconFamilyData(iconFamily, maskType, maskHandle);
        OS.DisposeHandle(maskHandle);
        if (imageData != image.data) {
            OS.DisposePtr(imageData);
        }
        int[] iconRef = new int[1];
        OS.HLock(iconFamily);
        int[] iconPtr = new int[1];
        OS.memcpy(iconPtr, iconFamily, 4);
        OS.GetIconRefFromIconFamilyPtr(iconPtr[0], OS.GetHandleSize(iconFamily), iconRef);
        OS.HUnlock(iconFamily);
        OS.DisposeHandle(iconFamily);
        return iconRef[0];
    }

    void createWidget() {
        this.createHandle();
        this.register();
        this.hookEvents();
    }

    int commandProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1: {
                return this.kEventProcessCommand(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    void deregister() {
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    void destroyCIcon(int iconHandle) {
        OS.HLock(iconHandle);
        int[] iconPtr = new int[1];
        OS.memcpy(iconPtr, iconHandle, 4);
        PixMap iconPMap = new PixMap();
        OS.memcpy(iconPMap, iconPtr[0], 50);
        if (iconPMap.pmTable != 0) {
            OS.DisposeHandle(iconPMap.pmTable);
        }
        int[] iconData = new int[1];
        OS.memcpy(iconData, iconPtr[0] + 50 + 28, 4);
        if (iconData[0] != 0) {
            OS.DisposeHandle(iconData[0]);
        }
        OS.HUnlock(iconHandle);
        OS.DisposeHandle(iconHandle);
    }

    int drawItemProc(int browser, int item, int property, int itemState, int theRect, int gdDepth, int colorDevice) {
        return 0;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.releaseChild();
        this.releaseWidget();
        this.destroyWidget();
    }

    void drawBackground(int control) {
    }

    void drawBackground(int control, float[] background) {
        Rect rect = new Rect();
        OS.GetControlBounds(control, rect);
        if (background != null) {
            OS.RGBForeColor(this.toRGBColor(background));
            OS.PaintRect(rect);
        } else {
            OS.SetThemeBackground((short)1, (short)0, true);
            OS.EraseRect(rect);
        }
    }

    void drawFocus(int control, boolean hasFocus, boolean hasBorder, float[] background, Rect inset) {
        int state;
        this.drawBackground(control, background);
        Rect rect = new Rect();
        OS.GetControlBounds(control, rect);
        rect.left = (short)(rect.left + inset.left);
        rect.top = (short)(rect.top + inset.top);
        rect.right = (short)(rect.right - inset.right);
        rect.bottom = (short)(rect.bottom - inset.bottom);
        if (OS.IsControlEnabled(control)) {
            state = OS.IsControlActive(control) ? 1 : 0;
        } else {
            int n = state = OS.IsControlActive(control) ? 7 : 8;
        }
        if (hasFocus) {
            if (hasBorder) {
                OS.DrawThemeEditTextFrame(rect, state);
            }
            OS.DrawThemeFocusRect(rect, true);
        } else if (hasBorder) {
            OS.DrawThemeEditTextFrame(rect, state);
        }
    }

    void drawFocusClipped(int control, boolean hasFocus, boolean hasBorder, float[] background, Rect inset) {
        int visibleRgn = this.getVisibleRegion(control, true);
        if (!OS.EmptyRgn(visibleRgn)) {
            int[] currentPort = new int[1];
            OS.GetPort(currentPort);
            int window = OS.GetControlOwner(control);
            int port = OS.GetWindowPort(window);
            OS.SetPort(port);
            int oldClip = OS.NewRgn();
            OS.GetClip(oldClip);
            OS.SetClip(visibleRgn);
            this.drawFocus(control, hasFocus, hasBorder, background, inset);
            OS.SetClip(oldClip);
            OS.SetPort(currentPort[0]);
        }
        OS.DisposeRgn(visibleRgn);
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    int fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            --j;
        }
        return j;
    }

    Rect getControlBounds(int control) {
        Rect rect = new Rect();
        OS.GetControlBounds(control, rect);
        int window = OS.GetControlOwner(control);
        int[] theRoot = new int[1];
        OS.GetRootControl(window, theRoot);
        int[] parentHandle = new int[1];
        OS.GetSuperControl(control, parentHandle);
        if (parentHandle[0] != theRoot[0]) {
            Rect parentRect = new Rect();
            OS.GetControlBounds(parentHandle[0], parentRect);
            OS.OffsetRect(rect, -parentRect.left, -parentRect.top);
        }
        Rect inset = this.getInset();
        rect.left = (short)(rect.left - inset.left);
        rect.top = (short)(rect.top - inset.top);
        rect.right = (short)(rect.right + inset.right);
        rect.bottom = (short)(rect.bottom + inset.bottom);
        return rect;
    }

    Rect getControlSize(int control) {
        Rect rect = new Rect();
        OS.GetControlBounds(control, rect);
        Rect inset = this.getInset();
        rect.left = (short)(rect.left - inset.left);
        rect.top = (short)(rect.top - inset.top);
        rect.right = (short)(rect.right + inset.right);
        rect.bottom = (short)(rect.bottom + inset.bottom);
        return rect;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    int getDrawCount(int control) {
        return 0;
    }

    Rect getInset() {
        return EMPTY_RECT;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        int visibleRgn = OS.NewRgn();
        this.calculateVisibleRegion(control, visibleRgn, clipChildren);
        return visibleRgn;
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        return -9874;
    }

    int hitTestProc(int browser, int item, int property, int theRect, int mouseRect) {
        return 1;
    }

    void hookEvents() {
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    void invalidateVisibleRegion(int control) {
    }

    void invalWindowRgn(int window, int rgn) {
        OS.InvalWindowRgn(window, rgn);
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isDrawing(int control) {
        return OS.IsControlVisible(control) && this.getDrawCount(control) == 0;
    }

    boolean isEnabled() {
        return true;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isTrimHandle(int trimHandle) {
        return false;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    int itemCompareProc(int browser, int itemOne, int itemTwo, int sortProperty) {
        return 0;
    }

    int itemDataProc(int browser, int item, int property, int itemData, int setValue) {
        return 0;
    }

    int itemNotificationProc(int browser, int item, int message) {
        return 0;
    }

    int kEventProcessCommand(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlApplyBackground(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlActivate(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlBoundsChanged(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlContextualMenuClick(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlDeactivate(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlDraw(int nextHandler, int theEvent, int userData) {
        int[] theControl = new int[1];
        OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1668575852, null, 4, null, theControl);
        if (this.getDrawCount(theControl[0]) > 0) {
            return 0;
        }
        int[] region = new int[1];
        OS.GetEventParameter(theEvent, 1919381096, 1919381096, null, 4, null, region);
        int visibleRgn = this.getVisibleRegion(theControl[0], true);
        OS.SectRgn(region[0], visibleRgn, visibleRgn);
        if (!OS.EmptyRgn(visibleRgn)) {
            int[] port = new int[1];
            OS.GetPort(port);
            OS.LockPortBits(port[0]);
            int oldClip = OS.NewRgn();
            OS.GetClip(oldClip);
            OS.SetClip(visibleRgn);
            this.drawBackground(theControl[0]);
            this.callPaintEventHandler(theControl[0], region[0], visibleRgn, theEvent, nextHandler);
            this.drawWidget(theControl[0], region[0], visibleRgn, theEvent);
            OS.SetClip(oldClip);
            OS.DisposeRgn(oldClip);
            OS.UnlockPortBits(port[0]);
        }
        OS.DisposeRgn(visibleRgn);
        return 0;
    }

    int kEventControlGetFocusPart(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlTrack(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuCalculateSize(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuClosed(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuCreateFrameView(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuDrawItem(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuDrawItemContent(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuGetFrameBounds(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuMeasureItemWidth(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuOpening(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuTargetItem(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseDragged(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseWheelMoved(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventRawKeyDown(int nextHandler, int theEvent, int userData) {
        return this.kEventRawKeyPressed(nextHandler, theEvent, userData);
    }

    int kEventRawKeyModifiersChanged(int nextHandler, int theEvent, int userData) {
        Event event;
        Display display = this.display;
        int[] modifiers = new int[1];
        OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, modifiers.length * 4, null, modifiers);
        int lastModifiers = display.lastModifiers;
        int chord = OS.GetCurrentEventButtonState();
        int type = 2;
        if ((modifiers[0] & 0x400) != 0 && (lastModifiers & 0x400) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x200) != 0 && (lastModifiers & 0x200) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x1000) != 0 && (lastModifiers & 0x1000) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x100) != 0 && (lastModifiers & 0x100) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x800) != 0 && (lastModifiers & 0x800) == 0) {
            type = 1;
        }
        if (type == 2 && (modifiers[0] & 0x400) == 0 && (lastModifiers & 0x400) != 0) {
            event = new Event();
            event.keyCode = 16777298;
            this.setInputState(event, 1, chord, modifiers[0]);
            this.sendKeyEvent(1, event);
        }
        event = new Event();
        this.setInputState(event, type, chord, modifiers[0]);
        if (event.keyCode == 0 && event.character == '\u0000') {
            return -9874;
        }
        boolean result = this.sendKeyEvent(type, event);
        if (type == 1 && (modifiers[0] & 0x400) != 0 && (lastModifiers & 0x400) == 0) {
            event = new Event();
            event.keyCode = 16777298;
            this.setInputState(event, 2, chord, modifiers[0]);
            this.sendKeyEvent(2, event);
        }
        display.lastModifiers = modifiers[0];
        return result ? -9874 : 0;
    }

    int kEventRawKeyPressed(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventRawKeyRepeat(int nextHandler, int theEvent, int userData) {
        return this.kEventRawKeyPressed(nextHandler, theEvent, userData);
    }

    int kEventRawKeyUp(int nextHandler, int theEvent, int userData) {
        if (!this.sendKeyEvent(2, theEvent)) {
            return 0;
        }
        return -9874;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowActivated(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowBoundsChanged(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowClose(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowCollapsed(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowDeactivated(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowDrawContent(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowExpanded(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowGetRegion(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowHidden(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowHitTest(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowShown(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowUpdate(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int keyboardProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1: {
                return this.kEventRawKeyDown(nextHandler, theEvent, userData);
            }
            case 4: {
                return this.kEventRawKeyModifiersChanged(nextHandler, theEvent, userData);
            }
            case 2: {
                return this.kEventRawKeyRepeat(nextHandler, theEvent, userData);
            }
            case 3: {
                return this.kEventRawKeyUp(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    int menuProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1004: {
                return this.kEventMenuCalculateSize(nextHandler, theEvent, userData);
            }
            case 5: {
                return this.kEventMenuClosed(nextHandler, theEvent, userData);
            }
            case 1005: {
                return this.kEventMenuCreateFrameView(nextHandler, theEvent, userData);
            }
            case 102: {
                return this.kEventMenuDrawItem(nextHandler, theEvent, userData);
            }
            case 103: {
                return this.kEventMenuDrawItemContent(nextHandler, theEvent, userData);
            }
            case 1006: {
                return this.kEventMenuGetFrameBounds(nextHandler, theEvent, userData);
            }
            case 100: {
                return this.kEventMenuMeasureItemWidth(nextHandler, theEvent, userData);
            }
            case 4: {
                return this.kEventMenuOpening(nextHandler, theEvent, userData);
            }
            case 6: {
                return this.kEventMenuTargetItem(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    int mouseProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1: {
                return this.kEventMouseDown(nextHandler, theEvent, userData);
            }
            case 2: {
                return this.kEventMouseUp(nextHandler, theEvent, userData);
            }
            case 6: {
                return this.kEventMouseDragged(nextHandler, theEvent, userData);
            }
            case 5: {
                return this.kEventMouseMoved(nextHandler, theEvent, userData);
            }
            case 10: {
                return this.kEventMouseWheelMoved(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void redrawWidget(int control, boolean children) {
        if (!this.isDrawing(control)) {
            return;
        }
        int window = OS.GetControlOwner(control);
        int visibleRgn = this.getVisibleRegion(control, !children);
        this.invalWindowRgn(window, visibleRgn);
        OS.DisposeRgn(visibleRgn);
    }

    void redrawWidget(int control, int x, int y, int width, int height, boolean children) {
        if (!this.isDrawing(control)) {
            return;
        }
        Rect rect = new Rect();
        OS.GetControlBounds(control, rect);
        OS.SetRect(rect, (short)(x += rect.left), (short)(y += rect.top), (short)(x + width), (short)(y + height));
        int rectRgn = OS.NewRgn();
        OS.RectRgn(rectRgn, rect);
        int visibleRgn = this.getVisibleRegion(control, !children);
        OS.SectRgn(rectRgn, visibleRgn, visibleRgn);
        int window = OS.GetControlOwner(control);
        this.invalWindowRgn(window, visibleRgn);
        OS.DisposeRgn(rectRgn);
        OS.DisposeRgn(visibleRgn);
    }

    void register() {
    }

    void releaseChild() {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
    }

    void releaseResources() {
        this.releaseWidget();
        this.releaseHandle();
    }

    void releaseWidget() {
        this.sendEvent(12);
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int type, int theEvent) {
        int[] length = new int[1];
        int status = OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 4, length, null);
        if (status == 0 && length[0] > 2) {
            int count = 0;
            int[] chord = new int[1];
            OS.GetEventParameter(theEvent, 1667788658, 1835100014, null, 4, null, chord);
            int[] modifiers = new int[1];
            OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
            char[] chars = new char[length[0] / 2];
            OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, chars.length * 2, null, chars);
            int i = 0;
            while (i < chars.length) {
                Event event = new Event();
                event.character = chars[i];
                this.setInputState(event, type, chord[0], modifiers[0]);
                if (this.sendKeyEvent(type, event)) {
                    chars[count++] = chars[i];
                }
                ++i;
            }
            if (count == 0) {
                return false;
            }
            if (count != chars.length - 1) {
                OS.SetEventParameter(theEvent, 1802858089, 1970567284, count * 2, chars);
            }
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, type, theEvent)) {
            return true;
        }
        return this.sendKeyEvent(type, event);
    }

    boolean sendKeyEvent(int type, Event event) {
        this.sendEvent(type, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    int setBounds(int control, int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        boolean sameExtent;
        Rect oldBounds = new Rect();
        OS.GetControlBounds(control, oldBounds);
        int[] theRoot = new int[1];
        int window = OS.GetControlOwner(control);
        OS.GetRootControl(window, theRoot);
        int[] parentHandle = new int[1];
        OS.GetSuperControl(control, parentHandle);
        Rect parentRect = new Rect();
        if (parentHandle[0] != theRoot[0]) {
            OS.GetControlBounds(parentHandle[0], parentRect);
            OS.OffsetRect(oldBounds, -parentRect.left, -parentRect.top);
        }
        Rect inset = this.getInset();
        oldBounds.left = (short)(oldBounds.left - inset.left);
        oldBounds.top = (short)(oldBounds.top - inset.top);
        oldBounds.right = (short)(oldBounds.right + inset.right);
        oldBounds.bottom = (short)(oldBounds.bottom + inset.bottom);
        if (!move) {
            x = oldBounds.left;
            y = oldBounds.top;
        }
        if (!resize) {
            width = oldBounds.right - oldBounds.left;
            height = oldBounds.bottom - oldBounds.top;
        }
        Rect newBounds = new Rect();
        newBounds.left = (short)(parentRect.left + x + inset.left);
        newBounds.top = (short)(parentRect.top + y + inset.top);
        newBounds.right = (short)(newBounds.left + width - inset.right - inset.left);
        newBounds.bottom = (short)(newBounds.top + height - inset.bottom - inset.top);
        if (newBounds.bottom < newBounds.top) {
            newBounds.bottom = newBounds.top;
        }
        if (newBounds.right < newBounds.left) {
            newBounds.right = newBounds.left;
        }
        OS.GetControlBounds(control, oldBounds);
        boolean sameOrigin = newBounds.left == oldBounds.left && newBounds.top == oldBounds.top;
        boolean bl = sameExtent = newBounds.right - newBounds.left == oldBounds.right - oldBounds.left && newBounds.bottom - newBounds.top == oldBounds.bottom - oldBounds.top;
        if (sameOrigin && sameExtent) {
            return 0;
        }
        int tempRgn = 0;
        boolean visible = OS.IsControlVisible(control);
        if (visible) {
            tempRgn = OS.NewRgn();
            OS.GetControlRegion(control, (short)-1, tempRgn);
            this.invalWindowRgn(window, tempRgn);
        }
        OS.SetControlBounds(control, newBounds);
        this.invalidateVisibleRegion(control);
        if (visible) {
            OS.GetControlRegion(control, (short)-1, tempRgn);
            this.invalWindowRgn(window, tempRgn);
            OS.DisposeRgn(tempRgn);
        }
        int result = 0;
        if (move && !sameOrigin) {
            if (events) {
                this.sendEvent(10);
            }
            result |= 0x40;
        }
        if (resize && !sameExtent) {
            if (events) {
                this.sendEvent(11);
            }
            result |= 0x80;
        }
        return result;
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
    }

    boolean setInputState(Event event, int type, int chord, int modifiers) {
        if ((chord & 1) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((chord & 2) != 0) {
            event.stateMask |= 0x200000;
        }
        if ((chord & 4) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((chord & 8) != 0) {
            event.stateMask |= 0x800000;
        }
        if ((chord & 0x10) != 0) {
            event.stateMask |= 0x2000000;
        }
        if ((modifiers & 0x800) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((modifiers & 0x200) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((modifiers & 0x1000) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((modifiers & 0x100) != 0) {
            event.stateMask |= 0x400000;
        }
        switch (type) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode != 0 || event.character != '\u0000') {
                    return true;
                }
                int lastModifiers = this.display.lastModifiers;
                if ((modifiers & 0x400) != 0 && (lastModifiers & 0x400) == 0) {
                    event.keyCode = 16777298;
                    return true;
                }
                if ((modifiers & 0x200) != 0 && (lastModifiers & 0x200) == 0) {
                    event.stateMask &= 0xFFFDFFFF;
                    event.keyCode = 131072;
                    return true;
                }
                if ((modifiers & 0x1000) != 0 && (lastModifiers & 0x1000) == 0) {
                    event.stateMask &= 0xFFFBFFFF;
                    event.keyCode = 262144;
                    return true;
                }
                if ((modifiers & 0x100) != 0 && (lastModifiers & 0x100) == 0) {
                    event.stateMask &= 0xFFBFFFFF;
                    event.keyCode = 0x400000;
                    return true;
                }
                if ((modifiers & 0x800) == 0 || (lastModifiers & 0x800) != 0) break;
                event.stateMask &= 0xFFFEFFFF;
                event.keyCode = 65536;
                return true;
            }
            case 2: {
                if (event.keyCode != 0 || event.character != '\u0000') {
                    return true;
                }
                int lastModifiers = this.display.lastModifiers;
                if ((modifiers & 0x400) == 0 && (lastModifiers & 0x400) != 0) {
                    event.keyCode = 16777298;
                    return true;
                }
                if ((modifiers & 0x200) == 0 && (lastModifiers & 0x200) != 0) {
                    event.stateMask |= 0x20000;
                    event.keyCode = 131072;
                    return true;
                }
                if ((modifiers & 0x1000) == 0 && (lastModifiers & 0x1000) != 0) {
                    event.stateMask |= 0x40000;
                    event.keyCode = 262144;
                    return true;
                }
                if ((modifiers & 0x100) == 0 && (lastModifiers & 0x100) != 0) {
                    event.stateMask |= 0x400000;
                    event.keyCode = 0x400000;
                    return true;
                }
                if ((modifiers & 0x800) != 0 || (lastModifiers & 0x800) == 0) break;
                event.stateMask |= 0x10000;
                event.keyCode = 65536;
                return true;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int type, int theEvent) {
        boolean isNull = false;
        int[] keyCode = new int[1];
        OS.GetEventParameter(theEvent, 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        event.keyCode = Display.translateKey(keyCode[0]);
        switch (event.keyCode) {
            case 10: {
                event.keyCode = 0x1000050;
                event.character = (char)13;
                break;
            }
            case 8: {
                event.character = (char)8;
                break;
            }
            case 13: {
                event.character = (char)13;
                break;
            }
            case 127: {
                event.character = (char)127;
                break;
            }
            case 27: {
                event.character = (char)27;
                break;
            }
            case 9: {
                event.character = (char)9;
                break;
            }
            default: {
                short regionCode;
                int result;
                int[] length;
                int status;
                if ((event.keyCode == 0 || 16777258 <= event.keyCode && event.keyCode <= 0x1000050) && (status = OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 4, length = new int[1], null)) == 0 && length[0] != 0) {
                    char[] chars = new char[1];
                    OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 2, null, chars);
                    event.character = chars[0];
                }
                if (event.keyCode != 0) break;
                int kchrPtr = OS.GetScriptManagerVariable((short)38);
                if (this.display.kchrPtr != kchrPtr) {
                    this.display.kchrPtr = kchrPtr;
                    this.display.kchrState[0] = 0;
                }
                if ((result = OS.KeyTranslate(this.display.kchrPtr, (short)keyCode[0], this.display.kchrState)) <= 127) {
                    event.keyCode = result & 0x7F;
                    break;
                }
                int[] encoding = new int[1];
                short keyScript = (short)OS.GetScriptManagerVariable((short)22);
                if (OS.UpgradeScriptInfoToTextEncoding(keyScript, (short)-128, regionCode = (short)OS.GetScriptManagerVariable((short)40), null, encoding) == -50 && OS.UpgradeScriptInfoToTextEncoding(keyScript, (short)-128, (short)-128, null, encoding) == -50) {
                    encoding[0] = 0;
                }
                int[] encodingInfo = new int[1];
                OS.CreateTextToUnicodeInfoByEncoding(encoding[0], encodingInfo);
                if (encodingInfo[0] == 0) break;
                char[] chars = new char[1];
                int[] nchars = new int[1];
                byte[] buffer = new byte[]{1, (byte)(result & 0xFF)};
                OS.ConvertFromPStringToUnicode(encodingInfo[0], buffer, chars.length * 2, nchars, chars);
                OS.DisposeTextToUnicodeInfo(encodingInfo);
                event.keyCode = chars[0];
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !isNull) {
            return false;
        }
        int[] chord = new int[1];
        OS.GetEventParameter(theEvent, 1667788658, 1835100014, null, 4, null, chord);
        int[] modifiers = new int[1];
        OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
        return this.setInputState(event, type, chord[0], modifiers[0]);
    }

    void setVisible(int control, boolean visible) {
        boolean drawing;
        int visibleRgn = 0;
        boolean bl = drawing = this.getDrawCount(control) == 0;
        if (drawing && !visible) {
            visibleRgn = this.getVisibleRegion(control, false);
        }
        OS.SetControlVisibility(control, visible, false);
        this.invalidateVisibleRegion(control);
        if (drawing && visible) {
            visibleRgn = this.getVisibleRegion(control, false);
        }
        if (drawing) {
            int window = OS.GetControlOwner(control);
            this.invalWindowRgn(window, visibleRgn);
            OS.DisposeRgn(visibleRgn);
        }
    }

    void setZOrder(int control, int otheControl, boolean above) {
        int inOp = above ? 2 : 1;
        int oldRgn = 0;
        boolean drawing = this.isDrawing(control);
        if (drawing) {
            oldRgn = this.getVisibleRegion(control, false);
        }
        OS.HIViewSetZOrder(control, inOp, otheControl);
        this.invalidateVisibleRegion(control);
        if (drawing) {
            int newRgn = this.getVisibleRegion(control, false);
            if (above) {
                OS.DiffRgn(newRgn, oldRgn, newRgn);
            } else {
                OS.DiffRgn(oldRgn, newRgn, newRgn);
            }
            int window = OS.GetControlOwner(control);
            this.invalWindowRgn(window, newRgn);
            OS.DisposeRgn(oldRgn);
            OS.DisposeRgn(newRgn);
        }
    }

    int textInputProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 2: {
                return this.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    RGBColor toRGBColor(float[] color) {
        RGBColor rgb = new RGBColor();
        rgb.red = (short)(color[0] * 65535.0f);
        rgb.green = (short)(color[1] * 65535.0f);
        rgb.blue = (short)(color[2] * 65535.0f);
        return rgb;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    int trackingProc(int browser, int itemID, int property, int theRect, int startPt, int modifiers) {
        return 1;
    }

    int windowProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 5: {
                return this.kEventWindowActivated(nextHandler, theEvent, userData);
            }
            case 27: {
                return this.kEventWindowBoundsChanged(nextHandler, theEvent, userData);
            }
            case 72: {
                return this.kEventWindowClose(nextHandler, theEvent, userData);
            }
            case 67: {
                return this.kEventWindowCollapsed(nextHandler, theEvent, userData);
            }
            case 6: {
                return this.kEventWindowDeactivated(nextHandler, theEvent, userData);
            }
            case 2: {
                return this.kEventWindowDrawContent(nextHandler, theEvent, userData);
            }
            case 70: {
                return this.kEventWindowExpanded(nextHandler, theEvent, userData);
            }
            case 1002: {
                return this.kEventWindowGetRegion(nextHandler, theEvent, userData);
            }
            case 25: {
                return this.kEventWindowHidden(nextHandler, theEvent, userData);
            }
            case 1003: {
                return this.kEventWindowHitTest(nextHandler, theEvent, userData);
            }
            case 24: {
                return this.kEventWindowShown(nextHandler, theEvent, userData);
            }
            case 1: {
                return this.kEventWindowUpdate(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }
}

