/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    int handle;
    int iconHandle;
    int labelHandle;
    int cIcon;
    int labelCIcon;
    int visibleRgn;
    int width = 6;
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    boolean tracking;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 6;
    static final int ARROW_WIDTH = 9;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int colorProc(int inControl, int inMessage, int inDrawDepth, int inDrawInColor) {
        switch (inMessage) {
            case 30: {
                if (this.parent.foreground != null) {
                    OS.RGBForeColor(this.toRGBColor(this.parent.foreground));
                } else {
                    OS.SetThemeTextColor((short)1, (short)inDrawDepth, inDrawInColor != 0);
                }
                return 0;
            }
            case 23: {
                float[] background;
                float[] fArray = background = this.parent.background != null ? this.parent.background : this.parent.getParentBackground();
                if (background != null) {
                    OS.RGBBackColor(this.toRGBColor(background));
                } else {
                    OS.SetThemeBackground((short)1, (short)inDrawDepth, inDrawInColor != 0);
                }
                return 0;
            }
        }
        return -9874;
    }

    org.eclipse.swt.graphics.Point computeSize(GC gc) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 2) != 0) {
            if ((this.parent.style & 0x100) != 0) {
                width = this.getWidth();
                height = 22;
            } else {
                width = 24;
                height = this.getWidth();
            }
            if (this.control != null) {
                height = Math.max(height, this.control.getMininumHeight());
            }
        } else {
            int space = 0;
            if (this.text.length() != 0 || this.image != null) {
                int stringWidth = 0;
                int stringHeight = 0;
                if (this.text.length() != 0) {
                    int flags = 15;
                    org.eclipse.swt.graphics.Point size = gc.textExtent(this.text, flags);
                    stringWidth = size.x;
                    stringHeight = size.y;
                }
                int imageWidth = 0;
                int imageHeight = 0;
                if (this.image != null) {
                    if (this.text.length() != 0) {
                        space = 2;
                    }
                    Rectangle rect = this.image.getBounds();
                    imageWidth = rect.width;
                    imageHeight = rect.height;
                }
                if ((this.parent.style & 0x20000) != 0) {
                    width = stringWidth + imageWidth;
                    height = Math.max(stringHeight, imageHeight);
                } else {
                    width = Math.max(stringWidth, imageWidth);
                    height = stringHeight + imageHeight;
                }
            } else {
                width = 24;
                height = 22;
            }
            if ((this.style & 4) != 0) {
                width += 9;
            }
            int inset = 3;
            width += space + inset * 2;
            height += space + inset * 2;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        int features = 18;
        OS.CreateUserPaneControl(window, null, features, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        if ((this.style & 2) == 0) {
            ControlButtonContentInfo inContent = new ControlButtonContentInfo();
            OS.CreateIconControl(window, null, inContent, false, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.iconHandle = outControl[0];
            OS.CreateIconControl(window, null, inContent, false, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.labelHandle = outControl[0];
        }
    }

    void createWidget() {
        super.createWidget();
        this.setZOrder();
        this.toolTipText = "";
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.iconHandle != 0) {
            this.display.removeWidget(this.iconHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    void destroyWidget() {
        int theControl = this.handle;
        this.releaseHandle();
        if (theControl != 0) {
            OS.DisposeControl(theControl);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar parent = this.parent;
        super.dispose();
        parent.relayout();
    }

    void drawBackground(int control) {
        this.drawBackground(control, this.parent.background);
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        if (control == this.handle && (this.style & 6) != 0) {
            int state = OS.IsControlEnabled(control) ? (OS.IsControlActive(control) ? 1 : 0) : (OS.IsControlActive(control) ? 7 : 8);
            Rect rect = new Rect();
            OS.GetControlBounds(this.handle, rect);
            if ((this.style & 2) != 0 && this.control == null) {
                rect.top = (short)(rect.top + 2);
                rect.bottom = (short)(rect.bottom - 2);
                OS.DrawThemeSeparator(rect, state);
            }
            if ((this.style & 4) != 0) {
                int height = rect.bottom - rect.top;
                rect.top = (short)(rect.bottom - height / 2 - 1);
                rect.left = (short)(rect.right - 9);
                OS.DrawThemePopupArrow(rect, (short)1, (short)1, state, 0, 0);
            }
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rect rect = this.getControlBounds(this.handle);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    int getDrawCount(int control) {
        return this.parent.getDrawCount(control);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        short[] transform = new short[1];
        OS.GetControlData(this.iconHandle, (short)0, 1953654381, 2, transform, null);
        return (transform[0] & 0x4000) != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(control, this.visibleRgn, false);
        }
        int result = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, result);
        return result;
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        switch (inRequest) {
            case 0: {
                int[] contentProvided = new int[]{-1};
                if (this.toolTipText != null && this.toolTipText.length() != 0) {
                    char[] buffer = new char[this.toolTipText.length()];
                    this.toolTipText.getChars(0, buffer.length, buffer, 0);
                    int length = this.fixMnemonic(buffer);
                    if (this.display.helpString != 0) {
                        OS.CFRelease(this.display.helpString);
                    }
                    this.display.helpString = OS.CFStringCreateWithCharacters(0, buffer, length);
                    HMHelpContentRec helpContent = new HMHelpContentRec();
                    OS.memcpy(helpContent, ioHelpContent, 534);
                    helpContent.version = 3;
                    helpContent.tagSide = 0;
                    this.display.helpControl = null;
                    helpContent.absHotRect_left = 0;
                    helpContent.absHotRect_top = 0;
                    helpContent.absHotRect_right = 0;
                    helpContent.absHotRect_bottom = 0;
                    helpContent.content0_contentType = 1667658612;
                    helpContent.content0_tagCFString = this.display.helpString;
                    helpContent.content1_contentType = 1667658612;
                    helpContent.content1_tagCFString = this.display.helpString;
                    OS.memcpy(ioHelpContent, helpContent, 534);
                    contentProvided[0] = 0;
                }
                OS.memcpy(outContentProvided, contentProvided, 4);
                break;
            }
            case 1: {
                if (this.display.helpString != 0) {
                    OS.CFRelease(this.display.helpString);
                }
                this.display.helpString = 0;
            }
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int controlProc = this.display.controlProc;
        int colorProc = this.display.colorProc;
        int[] mask1 = new int[]{1668183148, 4, 1668183148, 1, 1668183148, 12, 1668183148, 51};
        int controlTarget = OS.GetControlEventTarget(this.handle);
        OS.InstallEventHandler(controlTarget, controlProc, mask1.length / 2, mask1, this.handle, null);
        int[] mask2 = new int[]{1668183148, 4, 1668183148, 12, 1668183148, 51};
        if (this.iconHandle != 0) {
            controlTarget = OS.GetControlEventTarget(this.iconHandle);
            OS.InstallEventHandler(controlTarget, controlProc, mask2.length / 2, mask2, this.iconHandle, null);
            OS.SetControlColorProc(this.iconHandle, colorProc);
        }
        if (this.labelHandle != 0) {
            controlTarget = OS.GetControlEventTarget(this.labelHandle);
            OS.InstallEventHandler(controlTarget, controlProc, mask2.length / 2, mask2, this.labelHandle, null);
            OS.SetControlColorProc(this.labelHandle, colorProc);
        }
        int helpProc = this.display.helpProc;
        OS.HMInstallControlContentCallback(this.handle, helpProc);
        OS.SetControlColorProc(this.handle, colorProc);
    }

    void invalidateVisibleRegion(int control) {
        this.resetVisibleRegion(control);
        this.parent.resetVisibleRegion(control);
    }

    void invalWindowRgn(int window, int rgn) {
        this.parent.invalWindowRgn(window, rgn);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    int kEventControlContextualMenuClick(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventControlContextualMenuClick(nextHandler, theEvent, userData);
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlHit(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        }
        this.postEvent(13);
        return -9874;
    }

    int kEventControlTrack(int nextHandler, int theEvent, int userData) {
        this.tracking = true;
        return -9874;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int result = this.parent.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 4) != 0) {
            int sizeof = 4;
            Point pt = new Point();
            OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, pt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner(this.handle);
            OS.GetWindowBounds(window, (short)33, rect);
            int x = pt.h - rect.left;
            int y = pt.v - rect.top;
            OS.GetControlBounds(this.handle, rect);
            y -= rect.top;
            int width = rect.right - rect.left;
            if (width - (x -= rect.left) < 12) {
                x = rect.left;
                y = rect.bottom;
                OS.GetControlBounds(this.parent.handle, rect);
                Event event = new Event();
                event.detail = 4;
                event.x = x -= rect.left;
                event.y = y -= rect.top;
                this.postEvent(13, event);
            }
        }
        this.display.grabControl = null;
        this.display.runDeferredEvents();
        this.tracking = false;
        result = OS.CallNextEventHandler(nextHandler, theEvent);
        if (this.tracking) {
            Point outPt = new Point();
            OS.GetGlobalMouse(outPt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner(this.handle);
            OS.GetWindowBounds(window, (short)33, rect);
            int x = outPt.h - rect.left;
            int y = outPt.v - rect.top;
            OS.GetControlBounds(this.parent.handle, rect);
            x -= rect.left;
            y -= rect.top;
            short[] button = new short[1];
            OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
            int chord = OS.GetCurrentEventButtonState();
            int modifiers = OS.GetCurrentEventKeyModifiers();
            this.parent.sendMouseEvent(4, button[0], chord, (short)x, (short)y, modifiers, true);
        }
        this.tracking = false;
        return result;
    }

    int kEventMouseDragged(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventMouseDragged(nextHandler, theEvent, userData);
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventMouseMoved(nextHandler, theEvent, userData);
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventMouseUp(nextHandler, theEvent, userData);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.iconHandle != 0) {
            this.display.addWidget(this.iconHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.setVisible(this.handle, false);
        this.parent.destroyItem(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.iconHandle = 0;
        this.handle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
        }
        if (this.labelCIcon != 0) {
            this.destroyCIcon(this.labelCIcon);
        }
        this.labelCIcon = 0;
        this.cIcon = 0;
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resetVisibleRegion(int control) {
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0;
        }
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    void setBackground(float[] color) {
        this.parent.setBackground(this.handle, color);
        if (this.labelHandle != 0) {
            this.parent.setBackground(this.labelHandle, color);
            this.updateText(false);
        }
        if (this.iconHandle != 0) {
            this.parent.setBackground(this.iconHandle, color);
        }
    }

    void setBounds(int x, int y, int width, int height, GC gc) {
        this.setBounds(this.handle, x, y, width, height, true, true, false);
        if ((this.style & 2) != 0) {
            return;
        }
        int space = 0;
        int inset = 3;
        int stringWidth = 0;
        int stringHeight = 0;
        if (this.text.length() != 0) {
            int flags = 15;
            org.eclipse.swt.graphics.Point size = gc.textExtent(this.text, flags);
            stringWidth = size.x;
            stringHeight = size.y;
        }
        int imageWidth = 0;
        int imageHeight = 0;
        if (this.image != null) {
            if (this.text.length() != 0) {
                space = 2;
            }
            Rectangle rect = this.image.getBounds();
            imageWidth = rect.width;
            imageHeight = rect.height;
        }
        int arrowWidth = 0;
        if ((this.style & 4) != 0) {
            arrowWidth = 9;
        }
        if ((this.parent.style & 0x20000) != 0) {
            int imageX = inset;
            int imageY = inset + (height - inset * 2 - imageHeight) / 2;
            this.setBounds(this.iconHandle, imageX, imageY, imageWidth, imageHeight, true, true, false);
            int labelX = imageX + imageWidth + space;
            int labelY = inset + (height - inset * 2 - stringHeight) / 2;
            this.setBounds(this.labelHandle, labelX, labelY, stringWidth, stringHeight, true, true, false);
        } else {
            int imageX = inset + (width - inset * 2 - arrowWidth - imageWidth) / 2;
            int imageY = inset + (height - imageHeight - stringHeight - inset * 2) / 2;
            this.setBounds(this.iconHandle, imageX, imageY, imageWidth, imageHeight, true, true, false);
            int labelX = inset + (width - inset * 2 - arrowWidth - stringWidth) / 2;
            int labelY = imageY + imageHeight + space;
            this.setBounds(this.labelHandle, labelX, labelY, stringWidth, stringHeight, true, true, false);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.redrawWidget(this.handle, false);
        if (control != null && !control.isDisposed()) {
            control.moveAbove(null);
        }
        this.parent.relayout();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            if ((this.state & 8) == 0) {
                return;
            }
            this.state &= 0xFFFFFFF7;
            OS.EnableControl(this.handle);
        } else {
            if ((this.state & 8) != 0) {
                return;
            }
            this.state |= 8;
            OS.DisableControl(this.handle);
        }
    }

    void setFontStyle(Font font) {
        this.updateText(false);
    }

    void setForeground(float[] color) {
        this.parent.setForeground(this.handle, color);
        if (this.labelHandle != 0) {
            this.parent.setForeground(this.labelHandle, color);
            this.updateText(false);
        }
        if (this.iconHandle != 0) {
            this.parent.setForeground(this.iconHandle, color);
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        this.updateImage(true);
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        this.updateImage(true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.updateImage(true);
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int transform = selected ? 16384 : 0;
        OS.SetControlData(this.iconHandle, 0, 1953654381, 2, new short[]{(short)transform});
        if (this.image == null) {
            OS.SetControlData(this.labelHandle, 0, 1953654381, 2, new short[]{(short)transform});
        }
        this.redrawWidget(this.handle, true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        this.updateText(true);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0 || this.width == width) {
            return;
        }
        this.width = width;
        this.redrawWidget(this.handle, false);
        this.parent.relayout();
    }

    void setZOrder() {
        OS.HIViewAddSubview(this.parent.handle, this.handle);
        if (this.iconHandle != 0) {
            OS.HIViewAddSubview(this.handle, this.iconHandle);
        }
        if (this.labelHandle != 0) {
            OS.HIViewAddSubview(this.handle, this.labelHandle);
        }
    }

    void updateImage(boolean layout) {
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
        }
        this.cIcon = 0;
        Image image = null;
        image = this.hotImage != null ? this.hotImage : (this.image != null ? this.image : this.disabledImage);
        ControlButtonContentInfo inContent = new ControlButtonContentInfo();
        if (image != null) {
            this.cIcon = this.createCIcon(image);
            inContent.contentType = (short)130;
            inContent.iconRef = this.cIcon;
        }
        OS.SetBevelButtonContentInfo(this.iconHandle, inContent);
        if (layout) {
            this.redrawWidget(this.iconHandle, false);
            this.parent.relayout();
        }
    }

    void updateText(boolean layout) {
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.labelCIcon != 0) {
            this.destroyCIcon(this.labelCIcon);
        }
        this.labelCIcon = 0;
        ControlButtonContentInfo inContent = new ControlButtonContentInfo();
        if (this.text.length() > 0) {
            Font font = this.parent.getFont();
            GC gc = new GC(this.parent);
            int flags = 15;
            org.eclipse.swt.graphics.Point size = gc.textExtent(this.text, flags);
            gc.dispose();
            Image image = new Image((Device)this.display, size.x, size.y);
            gc = new GC(image);
            Color foreground = this.parent.getForeground();
            gc.setForeground(foreground);
            if (this.parent.background != null) {
                gc.setBackground(this.parent.getBackground());
                gc.fillRectangle(0, 0, size.x, size.y);
            }
            gc.setFont(font);
            gc.drawText(this.text, 0, 0, flags);
            gc.dispose();
            if (this.parent.background == null) {
                ImageData data = image.getImageData();
                data.transparentPixel = 0xFFFFFF;
                image.dispose();
                image = new Image((Device)this.display, data, data.getTransparencyMask());
            }
            this.labelCIcon = this.createCIcon(image);
            image.dispose();
            inContent.contentType = (short)130;
            inContent.iconRef = this.labelCIcon;
        }
        OS.SetBevelButtonContentInfo(this.labelHandle, inContent);
        if (layout) {
            this.redrawWidget(this.labelHandle, false);
            this.parent.relayout();
        }
    }
}

