/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.carbon.DataBrowserListViewHeaderDesc;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    int id;
    int lastWidth;
    int lastPosition;
    int iconRef;
    boolean resizable = true;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        int[] flags = new int[1];
        OS.GetDataBrowserPropertyFlags(this.parent.handle, this.id, flags);
        return (flags[0] & 0x20000) != 0;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public int getWidth() {
        this.checkWidget();
        short[] width = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.parent.handle, this.id, width);
        return Math.max(0, width[0]);
    }

    public void pack() {
        this.checkWidget();
        GC gc = new GC(this.parent);
        int width = gc.stringExtent((String)this.text).x;
        if (this.iconRef != 0) {
            width += this.parent.headerHeight;
            if (this.text.length() != 0) {
                width += 3;
            }
        }
        if ((this.parent.style & 0x10000000) == 0) {
            int index = this.parent.indexOf(this);
            int i = 0;
            while (i < this.parent.itemCount) {
                TableItem item = this.parent.items[i];
                if (item != null) {
                    width = Math.max(width, item.calculateWidth(index, gc));
                }
                ++i;
            }
        }
        gc.dispose();
        this.setWidth(width + 24);
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        if (this.iconRef != 0) {
            OS.ReleaseIconRef(this.iconRef);
        }
        this.iconRef = 0;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resized(int newWidth) {
        this.lastWidth = newWidth;
        this.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        boolean moved = false;
        int[] order = this.parent.getColumnOrder();
        TableColumn[] columns = this.parent.getColumns();
        int i = 0;
        while (i < order.length) {
            TableColumn column = columns[order[i]];
            if (moved && !column.isDisposed()) {
                column.sendEvent(10);
            }
            if (column == this) {
                moved = true;
            }
            ++i;
        }
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this.updateHeader();
    }

    public void setImage(Image image) {
        int index;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.iconRef != 0) {
            OS.ReleaseIconRef(this.iconRef);
            this.iconRef = 0;
        }
        super.setImage(image);
        if (image != null) {
            this.iconRef = this.createIconRef(image);
        }
        this.updateHeader();
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        int[] flags = new int[1];
        OS.GetDataBrowserPropertyFlags(this.parent.handle, this.id, flags);
        flags[0] = moveable ? flags[0] | 0x20000 : flags[0] & 0xFFFDFFFF;
        OS.SetDataBrowserPropertyFlags(this.parent.handle, this.id, flags[0]);
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
        this.updateHeader();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        this.updateHeader();
    }

    public void setWidth(int width) {
        this.checkWidget();
        OS.SetDataBrowserTableViewNamedColumnWidth(this.parent.handle, this.id, (short)width);
        this.updateHeader();
        if (width != this.lastWidth) {
            this.resized(width);
        }
    }

    void updateHeader() {
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int str = OS.CFStringCreateWithCharacters(0, buffer, length);
        if (str == 0) {
            this.error(13);
        }
        DataBrowserListViewHeaderDesc desc = new DataBrowserListViewHeaderDesc();
        desc.version = 0;
        desc.btnFontStyle_just = (short)-2;
        if ((this.style & 0x1000000) != 0) {
            desc.btnFontStyle_just = 1;
        }
        if ((this.style & 0x20000) != 0) {
            desc.btnFontStyle_just = (short)-1;
        }
        desc.btnFontStyle_flags = (short)(desc.btnFontStyle_flags | 0x40);
        if (this.resizable) {
            desc.minimumWidth = 0;
            desc.maximumWidth = Short.MAX_VALUE;
        } else {
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.parent.handle, this.id, width);
            desc.minimumWidth = desc.maximumWidth = width[0];
        }
        desc.titleString = str;
        desc.btnContentInfo_contentType = (short)(this.iconRef != 0 ? 132 : 0);
        desc.btnContentInfo_iconRef = this.iconRef;
        OS.SetDataBrowserListViewHeaderDesc(this.parent.handle, this.id, desc);
        OS.CFRelease(str);
    }
}

