/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    static int checkStyle(int style) {
        return ProgressBar.checkBits(style |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int[] outMetric = new int[1];
        OS.GetThemeMetric(58, outMetric);
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            height = outMetric[0];
            width = height * 10;
        } else {
            width = outMetric[0];
            height = width * 10;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateProgressBarControl(window, null, 0, 0, 100, (this.style & 2) != 0, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void drawBackground(int control) {
        this.drawBackground(control, this.background);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.GetControl32BitMaximum(this.handle);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum(this.handle);
    }

    public int getSelection() {
        this.checkWidget();
        return OS.GetControl32BitValue(this.handle);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int minimum = OS.GetControl32BitMinimum(this.handle);
        if (value > minimum) {
            OS.SetControl32BitMaximum(this.handle, value);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int maximum = OS.GetControl32BitMaximum(this.handle);
        if (value < maximum) {
            OS.SetControl32BitMinimum(this.handle, value);
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.SetControl32BitValue(this.handle, value);
        this.display.runEventLoopTimers();
    }
}

