/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserListViewColumnDesc;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    String[] items;
    int itemCount;
    int anchorFirst;
    int anchorLast;
    boolean ignoreSelect;
    static final int COLUMN_ID = 1024;
    static final int EXTRA_WIDTH = 25;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    public void add(String string) {
        int[] id;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (OS.AddDataBrowserItems(this.handle, 0, 1, id = new int[]{this.itemCount + 1}, 0) != 0) {
            this.error(14);
        }
        if (this.itemCount == this.items.length) {
            String[] newItems = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        this.items[this.itemCount++] = string;
    }

    public void add(String string, int index) {
        int[] id;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (OS.AddDataBrowserItems(this.handle, 0, 1, id = new int[]{this.itemCount + 1}, 0) != 0) {
            this.error(14);
        }
        if (index != this.itemCount) {
            this.fixSelection(index, true);
        }
        if (this.itemCount == this.items.length) {
            String[] newItems = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = string;
        OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        if (wHint == -1) {
            GC gc = new GC(this);
            int i = 0;
            while (i < this.itemCount) {
                Point extent = gc.stringExtent(this.items[i]);
                width = Math.max(width, extent.x);
                ++i;
            }
            gc.dispose();
            width += 25;
        } else {
            width = wHint;
        }
        if (width <= 0) {
            width = 64;
        }
        int height = 0;
        height = hHint == -1 ? this.itemCount * this.getItemHeight() : hHint;
        if (height <= 0) {
            height = 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new Point(rect.width, rect.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric(7, outMetric);
        border += outMetric[0];
        OS.GetThemeMetric(5, outMetric);
        Rect rect = new Rect();
        OS.GetDataBrowserScrollBarInset(this.handle, rect);
        return new Rectangle(x -= rect.left + (border += outMetric[0]), y -= rect.top + border, width += rect.left + rect.right + border + border, height += rect.top + rect.bottom + border + border);
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateDataBrowserControl(window, null, 1819505782, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        if (!this.drawFocusRing()) {
            OS.SetControlData(this.handle, 0, 1651663986, 1, new byte[1]);
        }
        int selectionFlags = (this.style & 4) != 0 ? 66 : 8;
        OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags);
        OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)0);
        OS.SetDataBrowserHasScrollBars(this.handle, (this.style & 0x100) != 0, (this.style & 0x200) != 0);
        DataBrowserListViewColumnDesc column = new DataBrowserListViewColumnDesc();
        column.headerBtnDesc_version = 0;
        column.propertyDesc_propertyID = 1024;
        column.propertyDesc_propertyType = 1952807028;
        column.propertyDesc_propertyFlags = 65536;
        column.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
        column.headerBtnDesc_initialOrder = 1;
        OS.AddDataBrowserListViewColumn(this.handle, column, 0);
        int size = 50;
        Rect rect = new Rect();
        rect.right = rect.bottom = (short)size;
        OS.SetControlBounds(this.handle, rect);
        int bpl = size * 4;
        int[] gWorld = new int[1];
        int data = OS.NewPtr(bpl * size);
        OS.NewGWorldFromPtr(gWorld, 32, rect, 0, 0, 0, data, bpl);
        int[] curPort = new int[1];
        int[] curGWorld = new int[1];
        OS.GetGWorld(curPort, curGWorld);
        OS.SetGWorld(gWorld[0], curGWorld[0]);
        OS.DrawControlInCurrentPort(this.handle);
        OS.SetGWorld(curPort[0], curGWorld[0]);
        OS.DisposeGWorld(gWorld[0]);
        OS.DisposePtr(data);
        rect.bottom = 0;
        rect.right = 0;
        OS.SetControlBounds(this.handle, rect);
    }

    void createWidget() {
        super.createWidget();
        this.items = new String[4];
    }

    ScrollBar createScrollBar(int style) {
        return this.createStandardBar(style);
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 3;
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index > 0 && index < this.itemCount) {
            int[] ids = new int[]{index + 1};
            this.deselect(ids, ids.length);
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (end < 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        int length = (end = Math.min(this.itemCount - 1, end)) - start + 1;
        if (length <= 0) {
            return;
        }
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            ids[i] = end - i + 1;
            ++i;
        }
        this.deselect(ids, length);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int length = indices.length;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            ids[i] = indices[length - i - 1] + 1;
            ++i;
        }
        this.deselect(ids, length);
    }

    void deselect(int[] ids, int count) {
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, count, ids, 3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.deselect(null, 0);
    }

    void fixSelection(int index, boolean add) {
        int[] selection = this.getSelectionIndices();
        if (selection.length == 0) {
            return;
        }
        int newCount = 0;
        boolean fix = false;
        int i = 0;
        while (i < selection.length) {
            if (!add && selection[i] == index) {
                fix = true;
            } else {
                int newIndex = newCount++;
                selection[newIndex] = selection[i] + 1;
                if (selection[newIndex] - 1 >= index) {
                    int n = newIndex;
                    selection[n] = selection[n] + (add ? 1 : -1);
                    fix = true;
                }
            }
            ++i;
        }
        if (fix) {
            this.select(selection, newCount, true);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int border = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric(7, outMetric);
        border += outMetric[0];
        OS.GetThemeMetric(5, outMetric);
        border += outMetric[0];
        Rect rect = new Rect();
        Rect inset = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetDataBrowserScrollBarInset(this.handle, inset);
        int width = Math.max(0, rect.right - rect.left - inset.right - border - border);
        int height = Math.max(0, rect.bottom - rect.top - inset.bottom - border - border);
        return new Rectangle(inset.left, inset.top, width, height);
    }

    public int getFocusIndex() {
        this.checkWidget();
        int[] first = new int[1];
        int[] last = new int[1];
        if (OS.GetDataBrowserSelectionAnchor(this.handle, first, last) != 0) {
            return -1;
        }
        return first[0] - 1;
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, height) != 0) {
            this.error(11);
        }
        return height[0];
    }

    public String[] getItems() {
        this.checkWidget();
        String[] result = new String[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int ptr = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, ptr) != 0) {
            this.error(9);
        }
        int count = OS.GetHandleSize(ptr) / 4;
        String[] result = new String[count];
        OS.HLock(ptr);
        int[] start = new int[1];
        OS.memcpy(start, ptr, 4);
        int[] id = new int[1];
        int i = 0;
        while (i < count) {
            OS.memcpy(id, start[0] + i * 4, 4);
            result[i] = this.items[id[0] - 1];
            ++i;
        }
        OS.HUnlock(ptr);
        OS.DisposeHandle(ptr);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] count = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, count) != 0) {
            this.error(36);
        }
        return count[0];
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] first = new int[1];
        int[] last = new int[1];
        if (OS.GetDataBrowserSelectionAnchor(this.handle, first, last) != 0) {
            return -1;
        }
        return first[0] - 1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int ptr = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, ptr) != 0) {
            this.error(9);
        }
        int count = OS.GetHandleSize(ptr) / 4;
        int[] result = new int[count];
        OS.HLock(ptr);
        int[] start = new int[1];
        OS.memcpy(start, ptr, 4);
        int[] id = new int[1];
        int i = 0;
        while (i < count) {
            OS.memcpy(id, start[0] + i * 4, 4);
            result[i] = id[0] - 1;
            ++i;
        }
        OS.HUnlock(ptr);
        OS.DisposeHandle(ptr);
        return result;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        return top[0] / this.getItemHeight();
    }

    void hookEvents() {
        super.hookEvents();
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        callbacks.version = 0;
        OS.InitDataBrowserCallbacks(callbacks);
        callbacks.v1_itemDataCallback = this.display.itemDataProc;
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
    }

    int itemDataProc(int browser, int id, int property, int itemData, int setValue) {
        int index = id - 1;
        switch (property) {
            case 1024: {
                String text = this.items[index];
                char[] buffer = new char[text.length()];
                text.getChars(0, buffer.length, buffer, 0);
                int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                if (ptr == 0) {
                    this.error(13);
                }
                OS.SetDataBrowserItemDataText(itemData, ptr);
                OS.CFRelease(ptr);
            }
        }
        return 0;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Shell shell = this.getShell();
        shell.bringToTop(true);
        Control oldFocus = this.display.getFocusControl();
        this.display.ignoreFocus = true;
        result = OS.CallNextEventHandler(nextHandler, theEvent);
        this.display.ignoreFocus = false;
        if (oldFocus != this) {
            if (oldFocus != null && !oldFocus.isDisposed()) {
                oldFocus.sendFocusEvent(16, false);
            }
            if (!this.isDisposed() && this.isEnabled()) {
                this.sendFocusEvent(15, false);
            }
        }
        return result;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        switch (keyCode[0]) {
            case 36: {
                this.postEvent(14);
                break;
            }
            case 125: {
                int index = this.getSelectionIndex();
                this.setSelection(Math.min(this.itemCount - 1, index + 1), true);
                return 0;
            }
            case 126: {
                int index = this.getSelectionIndex();
                this.setSelection(Math.max(0, index - 1), true);
                return 0;
            }
        }
        return result;
    }

    int itemNotificationProc(int browser, int id, int message) {
        switch (message) {
            case 5: 
            case 6: {
                if (this.ignoreSelect) break;
                int[] first = new int[1];
                int[] last = new int[1];
                OS.GetDataBrowserSelectionAnchor(this.handle, first, last);
                boolean selected = false;
                if ((this.style & 2) != 0) {
                    int modifiers = OS.GetCurrentEventKeyModifiers();
                    selected = (modifiers & 0x200) != 0 ? (message == 5 ? first[0] == id || last[0] == id : id == this.anchorFirst || id == this.anchorLast) : ((modifiers & 0x100) != 0 ? true : first[0] == last[0]);
                } else {
                    boolean bl = selected = message == 5;
                }
                if (!selected) break;
                this.anchorFirst = first[0];
                this.anchorLast = last[0];
                this.postEvent(13);
                break;
            }
            case 7: {
                this.postEvent(14);
            }
        }
        return 0;
    }

    public int indexOf(String item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int i = start;
        while (i < this.itemCount) {
            if (this.items[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return false;
        }
        return OS.IsDataBrowserItemSelected(this.handle, index + 1);
    }

    public void remove(int index) {
        int[] id;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if (index != this.itemCount - 1) {
            this.fixSelection(index, false);
        }
        if (OS.RemoveDataBrowserItems(this.handle, 0, (id = new int[]{this.itemCount}).length, id, 0) != 0) {
            this.error(15);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int length = end - start + 1;
        int i = 0;
        while (i < length) {
            this.remove(start);
            ++i;
        }
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int last = -1;
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                this.remove(index);
                last = index;
            }
            ++i;
        }
    }

    public void removeAll() {
        this.checkWidget();
        OS.RemoveDataBrowserItems(this.handle, 0, 0, null, 0);
        OS.SetDataBrowserScrollPosition(this.handle, 0, 0);
        this.items = new String[4];
        this.anchorLast = 0;
        this.anchorFirst = 0;
        this.itemCount = 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            int[] ids = new int[]{index + 1};
            this.select(ids, ids.length, false);
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        int length = end - start + 1;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            ids[i] = end - i + 1;
            ++i;
        }
        this.select(ids, length, false);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            int index = indices[length - i - 1];
            if (index >= 0 && index < this.itemCount) {
                ids[count++] = index + 1;
            }
            ++i;
        }
        if (count > 0) {
            this.select(ids, count, false);
        }
    }

    void select(int[] ids, int count, boolean clear) {
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
        }
        int operation = 1;
        if ((this.style & 2) != 0 && !clear) {
            operation = 0;
        }
        OS.SetDataBrowserSelectedItems(this.handle, count, ids, operation);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
        }
        this.ignoreSelect = false;
    }

    void select(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int length = items.length;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            ids[i] = this.indexOf(items[length - i - 1]) + 1;
            ++i;
        }
        this.select(ids, length, false);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.select(null, 0, false);
    }

    void setBackground(float[] color) {
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int index = -1;
        if (resize) {
            Rectangle rect = this.getClientArea();
            if (rect.height < this.getItemHeight()) {
                index = this.getTopIndex();
            }
        }
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if (index != -1) {
            this.showIndex(index);
        }
        return result;
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        int[] id = new int[]{index + 1};
        this.items[index] = string;
        OS.UpdateDataBrowserItems(this.handle, 0, id.length, id, 0, 0);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        OS.RemoveDataBrowserItems(this.handle, 0, 0, null, 0);
        if (OS.AddDataBrowserItems(this.handle, 0, items.length, null, 0) != 0) {
            this.error(14);
        }
        this.items = new String[items.length];
        System.arraycopy(items, 0, this.items, 0, items.length);
        this.itemCount = items.length;
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        if (index >= 0 && index < this.itemCount) {
            int[] ids = new int[]{index + 1};
            this.select(ids, ids.length, true);
            this.showIndex(index);
            if (notify) {
                this.postEvent(13);
            }
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        int length = end - start + 1;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            ids[i] = end - i + 1;
            ++i;
        }
        this.select(ids, length, true);
        if (ids.length > 0) {
            this.showIndex(ids[0] - 1);
        }
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            int index = indices[length - i - 1];
            if (index >= 0 && index < this.itemCount) {
                ids[count++] = index + 1;
            }
            ++i;
        }
        if (count > 0) {
            this.select(ids, count, true);
            this.showIndex(ids[0] - 1);
        }
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int count = 0;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            int index;
            String string = items[length - i - 1];
            if ((this.style & 4) != 0) {
                index = this.indexOf(string, 0);
                if (index != -1) {
                    count = 1;
                    ids = new int[]{index + 1};
                }
            } else {
                index = 0;
                while ((index = this.indexOf(string, index)) != -1) {
                    if (count == ids.length) {
                        int[] newIds = new int[ids.length + 4];
                        System.arraycopy(ids, 0, newIds, 0, ids.length);
                        ids = newIds;
                    }
                    ids[count++] = index + 1;
                    ++index;
                }
            }
            ++i;
        }
        if (count > 0) {
            this.select(ids, count, true);
            this.showIndex(ids[0] - 1);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        top[0] = index * this.getItemHeight();
        OS.SetDataBrowserScrollPosition(this.handle, top[0], left[0]);
    }

    void showIndex(int index) {
        if (index >= 0 && index < this.itemCount) {
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, 1024, width);
            Rect rect = new Rect();
            Rect inset = new Rect();
            OS.GetControlBounds(this.handle, rect);
            OS.GetDataBrowserScrollBarInset(this.handle, inset);
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, 1024, (short)(rect.right - rect.left - inset.left - inset.right));
            OS.RevealDataBrowserItem(this.handle, index + 1, 1024, (byte)3);
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, 1024, width[0]);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index >= 0) {
            this.showIndex(index);
        }
    }
}

