/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.FontInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    String text = "";
    Image image;
    boolean isImage;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style |= 0x80000) & 2) != 0) {
            style = Label.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                width = 64;
                height = 3;
            } else {
                width = 3;
                height = 64;
            }
        } else if (this.isImage && this.image != null) {
            Rectangle r = this.image.getBounds();
            width = r.width;
            height = r.height;
        } else {
            int length = this.text.length();
            if (length != 0) {
                int[] ptr = new int[1];
                OS.GetControlData(this.handle, (short)0, 1667658612, 4, ptr, null);
                if (ptr[0] != 0) {
                    Point ioBounds = new Point();
                    if ((this.style & 0x40) != 0 && wHint != -1) {
                        ioBounds.h = (short)wHint;
                    }
                    if (this.font == null) {
                        OS.GetThemeTextDimensions(ptr[0], (short)this.defaultThemeFont(), 1, ioBounds.h != 0, ioBounds, null);
                    } else {
                        int[] currentPort = new int[1];
                        OS.GetPort(currentPort);
                        OS.SetPortWindowPort(OS.GetControlOwner(this.handle));
                        OS.TextFont(this.font.id);
                        OS.TextFace(this.font.style);
                        OS.TextSize(this.font.size);
                        OS.GetThemeTextDimensions(ptr[0], (short)200, 1, ioBounds.h != 0, ioBounds, null);
                        OS.SetPort(currentPort[0]);
                    }
                    width = ioBounds.h;
                    height = ioBounds.v;
                }
                OS.CFRelease(ptr[0]);
            } else {
                int fontHeight;
                Font font = this.getFont();
                FontInfo info = new FontInfo();
                OS.FetchFontInfo(font.id, font.size, font.style, info);
                height = fontHeight = info.ascent + info.descent;
            }
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    void createHandle() {
        this.state |= 0x20;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        if ((this.style & 2) != 0) {
            OS.CreateSeparatorControl(window, null, outControl);
        } else {
            int just = -2;
            if ((this.style & 0x1000000) != 0) {
                just = 1;
            }
            if ((this.style & 0x20000) != 0) {
                just = -1;
            }
            ControlFontStyleRec fontStyle = new ControlFontStyleRec();
            fontStyle.flags = (short)(fontStyle.flags | 0x40);
            fontStyle.just = (short)just;
            OS.CreateStaticTextControl(window, null, 0, fontStyle, outControl);
        }
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 105;
    }

    void drawBackground(int control) {
        if ((this.style & 2) != 0) {
            this.drawBackground(control, this.background);
        }
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        if (this.isImage && this.image != null) {
            GCData data = new GCData();
            data.paintEvent = theEvent;
            data.visibleRgn = visibleRgn;
            GC gc = GC.carbon_new(this, data);
            int x = 0;
            org.eclipse.swt.graphics.Point size = this.getSize();
            Rectangle bounds = this.image.getBounds();
            if ((this.style & 0x1000000) != 0) {
                x = (size.x - bounds.width) / 2;
            }
            if ((this.style & 0x20000) != 0) {
                x = size.x - bounds.width;
            }
            gc.drawImage(this.image, x, 0);
            gc.dispose();
        }
        super.drawWidget(control, damageRgn, visibleRgn, theEvent);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return (this.style & 0x800) != 0 ? 1 : 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int just = -2;
        if ((alignment & 0x1000000) != 0) {
            just = 1;
        }
        if ((alignment & 0x20000) != 0) {
            just = -1;
        }
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData(this.handle, (short)0, 1718578804, 24, fontStyle, null);
        fontStyle.flags = (short)(fontStyle.flags | 0x40);
        fontStyle.just = (short)just;
        OS.SetControlFontStyle(this.handle, fontStyle);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        this.isImage = true;
        if (image == null) {
            this.setText(this.text);
            return;
        }
        if (this.text.length() > 0) {
            int ptr = OS.CFStringCreateWithCharacters(0, null, 0);
            if (ptr == 0) {
                this.error(13);
            }
            OS.SetControlData(this.handle, 0, 1667658612, 4, new int[]{ptr});
            OS.CFRelease(ptr);
        }
        this.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.isImage = false;
        this.text = string;
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetControlData(this.handle, 0, 1667658612, 4, new int[]{ptr});
        OS.CFRelease(ptr);
        this.redraw();
    }
}

