/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    int kEventControlDraw(int nextHandler, int theEvent, int userData) {
        boolean isFocus;
        int[] theControl = new int[1];
        OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1668575852, null, 4, null, theControl);
        boolean bl = isFocus = theControl[0] == this.handle && this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.kEventControlDraw(nextHandler, theEvent, userData);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0 && this.caret != null && !this.isDisposed()) {
            short[] part = new short[1];
            OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
            if (part[0] != 0) {
                this.caret.setFocus();
            } else {
                this.caret.killFocus();
            }
        }
        return result;
    }

    void redrawWidget(int control, boolean children) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(control, children);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void redrawWidget(int control, int x, int y, int width, int height, boolean all) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(control, x, y, width, height, all);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void releaseWidget() {
        if (this.caret != null) {
            this.caret.releaseResources();
        }
        this.caret = null;
        super.releaseWidget();
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        Rectangle clientRect;
        Rectangle sourceRect;
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isDrawing(this.handle)) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if ((sourceRect = new Rectangle(x, y, width, height)).intersects(clientRect = this.getClientArea())) {
            this.update(all);
        }
        GC gc = new GC(this);
        gc.copyArea(x, y, width, height, destX, destY);
        gc.dispose();
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) >= Math.max(x, rect.x) && Math.min(y + height, rect.y + rect.height) >= Math.max(y, rect.y)) {
                    child.setLocation(rect.x + deltaX, rect.y + deltaY);
                }
                ++i;
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }
}

