/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSTrapezoid;
import org.eclipse.swt.internal.carbon.ATSUTab;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.FontInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int TAB_COUNT = 32;
    static final int[] LINE_DOT = new int[]{1, 1};
    static final int[] LINE_DASH = new int[]{3, 1};
    static final int[] LINE_DASHDOT = new int[]{3, 1, 1, 1};
    static final int[] LINE_DASHDOTDOT = new int[]{3, 1, 1, 1, 1, 1};
    static final int[] LINE_DOT_ZERO = new int[]{3, 3};
    static final int[] LINE_DASH_ZERO = new int[]{18, 6};
    static final int[] LINE_DASHDOT_ZERO = new int[]{9, 6, 3, 6};
    static final int[] LINE_DASHDOTDOT_ZERO = new int[]{9, 3, 3, 3, 3, 3};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int gdkGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, gdkGC);
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC carbon_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int context = drawable.internal_new_GC(data);
        gc.init(drawable, data, context);
        return gc;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.control != 0) {
            int[] offscreen = new int[1];
            OS.HIViewCreateOffscreenImage(this.data.control, 0, null, offscreen);
            this.copyArea(image, x, y, offscreen[0]);
            if (offscreen[0] != 0) {
                OS.CGImageRelease(offscreen[0]);
            }
        } else if (this.data.image != null) {
            this.copyArea(image, x, y, this.data.image.handle);
        } else if (this.data.window != 0) {
            int imageHandle = image.handle;
            CGRect rect = new CGRect();
            rect.x = x;
            rect.y = y;
            rect.width = OS.CGImageGetWidth(imageHandle);
            rect.height = OS.CGImageGetHeight(imageHandle);
            int[] displays = new int[16];
            int[] count = new int[1];
            if (OS.CGGetDisplaysWithRect(rect, displays.length, displays, count) != 0) {
                return;
            }
            int i = 0;
            while (i < count[0]) {
                int display = displays[i];
                int address = OS.CGDisplayBaseAddress(display);
                if (address != 0) {
                    int width = OS.CGDisplayPixelsWide(display);
                    int height = OS.CGDisplayPixelsHigh(display);
                    int bpr = OS.CGDisplayBytesPerRow(display);
                    int bpp = OS.CGDisplayBitsPerPixel(display);
                    int bps = OS.CGDisplayBitsPerSample(display);
                    int provider = OS.CGDataProviderCreateWithData(0, address, bpr * height, 0);
                    int srcImage = OS.CGImageCreate(width, height, bps, bpp, bpr, this.data.device.colorspace, 6, provider, null, true, 0);
                    OS.CGDataProviderRelease(provider);
                    this.copyArea(image, x, y, srcImage);
                    if (srcImage != 0) {
                        OS.CGImageRelease(srcImage);
                    }
                }
                ++i;
            }
        }
    }

    void copyArea(Image image, int x, int y, int srcImage) {
        int alphaInfo;
        int bpr;
        int height;
        if (srcImage == 0) {
            return;
        }
        int imageHandle = image.handle;
        int bpc = OS.CGImageGetBitsPerComponent(imageHandle);
        int width = OS.CGImageGetWidth(imageHandle);
        int context = OS.CGBitmapContextCreate(image.data, width, height = OS.CGImageGetHeight(imageHandle), bpc, bpr = OS.CGImageGetBytesPerRow(imageHandle), this.data.device.colorspace, alphaInfo = OS.CGImageGetAlphaInfo(imageHandle));
        if (context != 0) {
            CGRect rect = new CGRect();
            rect.x = -x;
            rect.y = y;
            rect.width = OS.CGImageGetWidth(srcImage);
            rect.height = OS.CGImageGetHeight(srcImage);
            OS.CGContextTranslateCTM(context, 0.0f, -(rect.height - (float)height));
            OS.CGContextDrawImage(context, rect, srcImage);
            OS.CGContextRelease(context);
        }
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.copyArea(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - srcX;
        int deltaY = destY - srcY;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (this.data.image != null) {
            OS.CGContextSaveGState(this.handle);
            OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
            OS.CGContextTranslateCTM(this.handle, 0.0f, -(height + 2 * destY));
            CGRect rect = new CGRect();
            rect.x = destX;
            rect.y = destY;
            rect.width = width;
            rect.height = height;
            OS.CGContextDrawImage(this.handle, rect, this.data.image.handle);
            OS.CGContextRestoreGState(this.handle);
            return;
        }
        if (this.data.control != 0) {
            int port = this.data.port;
            int window = OS.GetControlOwner(this.data.control);
            if (port == 0) {
                port = OS.GetWindowPort(window);
            }
            Rect rect = new Rect();
            OS.GetControlBounds(this.data.control, rect);
            Rect srcRect = new Rect();
            int left = rect.left + srcX;
            int top = rect.top + srcY;
            OS.SetRect(srcRect, (short)left, (short)top, (short)(left + width), (short)(top + height));
            int srcRgn = OS.NewRgn();
            OS.RectRgn(srcRgn, srcRect);
            OS.SectRect(rect, srcRect, srcRect);
            Rect destRect = new Rect();
            OS.SetRect(destRect, srcRect.left, srcRect.top, srcRect.right, srcRect.bottom);
            OS.OffsetRect(destRect, (short)deltaX, (short)deltaY);
            int destRgn = OS.NewRgn();
            OS.RectRgn(destRgn, destRect);
            if (!OS.EmptyRect(srcRect) && (this.data.visibleRgn == 0 || OS.RectInRgn(srcRect, this.data.visibleRgn))) {
                int clipRgn = this.data.visibleRgn;
                if (this.data.clipRgn != 0) {
                    clipRgn = OS.NewRgn();
                    OS.SectRgn(this.data.clipRgn, this.data.visibleRgn, clipRgn);
                }
                if (!OS.EmptyRgn(clipRgn)) {
                    boolean disjoint;
                    boolean bl = disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
                    if (!(disjoint || deltaX != 0 && deltaY != 0)) {
                        int[] currentPort = new int[1];
                        OS.GetPort(currentPort);
                        OS.SetPort(port);
                        int oldClip = OS.NewRgn();
                        OS.GetClip(oldClip);
                        OS.SetClip(clipRgn);
                        OS.UnionRect(srcRect, destRect, rect);
                        OS.ScrollRect(rect, (short)deltaX, (short)deltaY, 0);
                        OS.SetClip(oldClip);
                        OS.DisposeRgn(oldClip);
                        OS.SetPort(currentPort[0]);
                    } else {
                        int portBitMap = OS.GetPortBitMapForCopyBits(port);
                        OS.CopyBits(portBitMap, portBitMap, srcRect, destRect, (short)0, clipRgn);
                        OS.QDFlushPortBuffer(port, destRgn);
                    }
                }
                if (clipRgn != this.data.visibleRgn) {
                    OS.DisposeRgn(clipRgn);
                }
            }
            if (paint) {
                int invalRgn = OS.NewRgn();
                OS.DiffRgn(srcRgn, this.data.visibleRgn, invalRgn);
                OS.OffsetRgn(invalRgn, (short)deltaX, (short)deltaY);
                OS.DiffRgn(srcRgn, destRgn, srcRgn);
                OS.UnionRgn(srcRgn, invalRgn, invalRgn);
                OS.SectRgn(this.data.visibleRgn, invalRgn, invalRgn);
                OS.InvalWindowRgn(window, invalRgn);
                OS.DisposeRgn(invalRgn);
            }
            OS.DisposeRgn(destRgn);
            OS.DisposeRgn(srcRgn);
        }
    }

    void createLayout() {
        int[] buffer = new int[1];
        OS.ATSUCreateTextLayout(buffer);
        if (buffer[0] == 0) {
            SWT.error(2);
        }
        this.data.layout = buffer[0];
        int ptr1 = OS.NewPtr(4);
        buffer[0] = this.handle;
        OS.memcpy(ptr1, buffer, 4);
        int ptr2 = OS.NewPtr(4);
        buffer[0] = 0x1000000;
        OS.memcpy(ptr2, buffer, 4);
        boolean lineDir = false;
        if ((this.data.style & 0x4000000) != 0) {
            lineDir = true;
        }
        int ptr3 = OS.NewPtr(1);
        OS.memcpy(ptr3, new byte[]{(byte)(lineDir ? 1 : 0)}, 1);
        int[] tags = new int[]{Short.MAX_VALUE, 7, 3};
        int[] sizes = new int[]{4, 4, 1};
        int[] values = new int[]{ptr1, ptr2, ptr3};
        OS.ATSUSetLayoutControls(this.data.layout, tags.length, tags, sizes, values);
        OS.DisposePtr(ptr1);
        OS.DisposePtr(ptr2);
        OS.DisposePtr(ptr3);
    }

    void createTabs() {
        ATSUTab tabs = new ATSUTab();
        int tabWidth = this.getCharWidth(' ') * 8;
        int ptr = OS.NewPtr(192);
        int i = 0;
        int offset = ptr;
        while (i < 32) {
            tabs.tabPosition += OS.Long2Fix(tabWidth);
            OS.memcpy(offset, tabs, 6);
            ++i;
            offset += 6;
        }
        this.data.tabs = ptr;
    }

    public void dispose() {
        int backPattern;
        int forePattern;
        int tabs;
        int stringPtr;
        int atsuiStyle;
        int layout;
        Image image;
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            OS.DisposeRgn(clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            image.createAlpha();
        }
        if ((layout = this.data.layout) != 0) {
            OS.ATSUDisposeTextLayout(layout);
        }
        if ((atsuiStyle = this.data.atsuiStyle) != 0) {
            OS.ATSUDisposeStyle(atsuiStyle);
        }
        if ((stringPtr = this.data.stringPtr) != 0) {
            OS.DisposePtr(stringPtr);
        }
        if ((tabs = this.data.tabs) != 0) {
            OS.DisposePtr(tabs);
        }
        if ((forePattern = this.data.forePattern) != 0) {
            OS.CGPatternRelease(forePattern);
        }
        if ((backPattern = this.data.backPattern) != 0) {
            OS.CGPatternRelease(backPattern);
        }
        this.drawable.internal_dispose_GC(this.handle, this.data);
        this.data.backPattern = 0;
        this.data.forePattern = 0;
        this.data.tabs = 0;
        this.data.layout = 0;
        this.data.stringPtr = 0;
        this.data.atsuiStyle = 0;
        this.data.clipRgn = 0;
        this.drawable = null;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
        this.handle = 0;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextTranslateCTM(this.handle, (float)x + offset + (float)width / 2.0f, (float)y + offset + (float)height / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)width / 2.0f, (float)height / 2.0f);
        OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f, true);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        this.flush();
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        int imageHandle = srcImage.handle;
        int imgWidth = OS.CGImageGetWidth(imageHandle);
        int imgHeight = OS.CGImageGetHeight(imageHandle);
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        if (srcImage.memGC != null) {
            srcImage.createAlpha();
        }
        OS.CGContextSaveGState(this.handle);
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(this.handle, 0.0f, -(destHeight + 2 * destY));
        CGRect rect = new CGRect();
        rect.x = destX;
        rect.y = destY;
        rect.width = destWidth;
        rect.height = destHeight;
        if (simple) {
            OS.CGContextDrawImage(this.handle, rect, imageHandle);
        } else {
            int bpc = OS.CGImageGetBitsPerComponent(imageHandle);
            int bpp = OS.CGImageGetBitsPerPixel(imageHandle);
            int bpr = OS.CGImageGetBytesPerRow(imageHandle);
            int colorspace = OS.CGImageGetColorSpace(imageHandle);
            int alphaInfo = OS.CGImageGetAlphaInfo(imageHandle);
            int data = srcImage.data + srcY * bpr + srcX * 4;
            int provider = OS.CGDataProviderCreateWithData(0, data, srcHeight * bpr, 0);
            if (provider != 0) {
                int subImage = OS.CGImageCreate(srcWidth, srcHeight, bpc, bpp, bpr, colorspace, alphaInfo, provider, null, true, 0);
                OS.CGDataProviderRelease(provider);
                if (subImage != 0) {
                    OS.CGContextDrawImage(this.handle, rect, subImage);
                    OS.CGImageRelease(subImage);
                }
            }
        }
        OS.CGContextRestoreGState(this.handle);
        this.flush();
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (x1 == x2 && y1 == y2 && this.data.lineWidth <= 1) {
            this.drawPoint(x1, y1);
            return;
        }
        OS.CGContextBeginPath(this.handle);
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextMoveToPoint(this.handle, (float)x1 + offset, (float)y1 + offset);
        OS.CGContextAddLineToPoint(this.handle, (float)x2 + offset, (float)y2 + offset);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextTranslateCTM(this.handle, (float)x + offset + (float)width / 2.0f, (float)y + offset + (float)height / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)width / 2.0f, (float)height / 2.0f);
        OS.CGContextMoveToPoint(this.handle, 1.0f, 0.0f);
        OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, 0.0f, (float)(2.0 * Compatibility.PI), true);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextTranslateCTM(this.handle, offset, offset);
        OS.CGContextAddPath(this.handle, path.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        CGRect rect = new CGRect();
        rect.x = x;
        rect.y = y;
        rect.width = 1.0f;
        rect.height = 1.0f;
        OS.CGContextSetFillColor(this.handle, this.data.foreground);
        OS.CGContextFillRect(this.handle, rect);
        OS.CGContextSetFillColor(this.handle, this.data.background);
        this.flush();
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        float[] points = new float[pointArray.length];
        int i = 0;
        while (i < points.length) {
            points[i] = (float)pointArray[i] + offset;
            ++i;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddLines(this.handle, points, points.length / 2);
        OS.CGContextClosePath(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        float[] points = new float[pointArray.length];
        int i = 0;
        while (i < points.length) {
            points[i] = (float)pointArray[i] + offset;
            ++i;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddLines(this.handle, points, points.length / 2);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        CGRect rect = new CGRect();
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        rect.x = (float)x + offset;
        rect.y = (float)y + offset;
        rect.width = width;
        rect.height = height;
        OS.CGContextStrokeRect(this.handle, rect);
        this.flush();
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.drawRectangle(x, y, width, height);
            return;
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if (naw > nw) {
            naw = nw;
        }
        if (nah > nh) {
            nah = nh;
        }
        float naw2 = (float)naw / 2.0f;
        float nah2 = (float)nah / 2.0f;
        float fw = (float)nw / naw2;
        float fh = (float)nh / nah2;
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float offset = this.data.lineWidth == 0 || this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextTranslateCTM(this.handle, (float)nx + offset, (float)ny + offset);
        OS.CGContextScaleCTM(this.handle, naw2, nah2);
        OS.CGContextMoveToPoint(this.handle, fw - 1.0f, 0.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, fh, 1.0f, fh, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, fw, fh, fw, fh - 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, fw, 0.0f, fw - 1.0f, 0.0f, 1.0f);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.drawText(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        int length;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if ((length = string.length()) == 0) {
            return;
        }
        OS.CGContextSaveGState(this.handle);
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        boolean mode = true;
        switch (this.data.textAntialias) {
            case -1: {
                if (this.data.window == 0 || this.data.control != 0) break;
                mode = false;
                break;
            }
            case 0: {
                mode = false;
            }
        }
        OS.CGContextSetShouldAntialias(this.handle, mode);
        length = this.setString(string, flags);
        if ((flags & 2) != 0) {
            int layout = this.data.layout;
            int[] breakCount = new int[1];
            OS.ATSUGetSoftLineBreaks(layout, 0, length, 0, null, breakCount);
            int[] breaks = new int[breakCount[0] + 1];
            OS.ATSUGetSoftLineBreaks(layout, 0, length, breakCount[0], breaks, breakCount);
            breaks[breakCount[0]] = length;
            int i = 0;
            int start = 0;
            while (i < breaks.length) {
                int lineBreak = breaks[i];
                this.drawText(x, y, start, lineBreak - start, flags);
                y += this.data.fontAscent + this.data.fontDescent;
                start = lineBreak;
                ++i;
            }
        } else {
            this.drawText(x, y, 0, length, flags);
        }
        OS.CGContextRestoreGState(this.handle);
        this.flush();
    }

    void drawText(int x, int y, int start, int length, int flags) {
        int layout = this.data.layout;
        if ((flags & 1) == 0) {
            ATSTrapezoid trapezoid = new ATSTrapezoid();
            OS.ATSUGetGlyphBounds(layout, 0, 0, start, length, (short)1, 1, trapezoid, null);
            int width = OS.Fix2Long(trapezoid.upperRight_x) - OS.Fix2Long(trapezoid.upperLeft_x);
            int height = OS.Fix2Long(trapezoid.lowerRight_y) - OS.Fix2Long(trapezoid.upperRight_y);
            CGRect rect = new CGRect();
            rect.x = x;
            rect.y = -(y + height);
            rect.width = width;
            rect.height = height;
            OS.CGContextSetFillColor(this.handle, this.data.background);
            OS.CGContextFillRect(this.handle, rect);
        }
        OS.CGContextSetFillColor(this.handle, this.data.foreground);
        OS.ATSUDrawText(layout, start, length, OS.Long2Fix(x), OS.Long2Fix(-(y + this.data.fontAscent)));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        OS.CGContextTranslateCTM(this.handle, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)width / 2.0f, (float)height / 2.0f);
        OS.CGContextMoveToPoint(this.handle, 0.0f, 0.0f);
        OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f, true);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextFillPath(this.handle);
        this.flush();
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        RGB foregroundRGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, 8, 8, 8);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        OS.CGContextTranslateCTM(this.handle, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)width / 2.0f, (float)height / 2.0f);
        OS.CGContextMoveToPoint(this.handle, 1.0f, 0.0f);
        OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, 0.0f, (float)(Compatibility.PI * 2.0), false);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextFillPath(this.handle);
        this.flush();
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddPath(this.handle, path.handle);
        if (this.data.fillRule == 2) {
            OS.CGContextFillPath(this.handle);
        } else {
            OS.CGContextEOFillPath(this.handle);
        }
        this.flush();
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float[] points = new float[pointArray.length];
        int i = 0;
        while (i < points.length) {
            points[i] = pointArray[i];
            ++i;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddLines(this.handle, points, points.length / 2);
        OS.CGContextClosePath(this.handle);
        if (this.data.fillRule == 2) {
            OS.CGContextFillPath(this.handle);
        } else {
            OS.CGContextEOFillPath(this.handle);
        }
        this.flush();
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        CGRect rect = new CGRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        OS.CGContextFillRect(this.handle, rect);
        this.flush();
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if (naw > nw) {
            naw = nw;
        }
        if (nah > nh) {
            nah = nh;
        }
        float naw2 = (float)naw / 2.0f;
        float nah2 = (float)nah / 2.0f;
        float fw = (float)nw / naw2;
        float fh = (float)nh / nah2;
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        OS.CGContextTranslateCTM(this.handle, nx, ny);
        OS.CGContextScaleCTM(this.handle, naw2, nah2);
        OS.CGContextMoveToPoint(this.handle, fw - 1.0f, 0.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, fh, 1.0f, fh, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, fw, fh, fw, fh - 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, fw, 0.0f, fw - 1.0f, 0.0f, 1.0f);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextFillPath(this.handle);
        this.flush();
    }

    void flush() {
        if (this.data.control != 0 && this.data.paintEvent == 0) {
            if (this.data.thread != Thread.currentThread()) {
                OS.CGContextFlush(this.handle);
            } else {
                OS.CGContextSynchronize(this.handle);
            }
        }
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.carbon_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return this.data.backgroundPattern;
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return true;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.antialias;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        Rect rect = new Rect();
        int width = 0;
        int height = 0;
        if (this.data.control != 0) {
            OS.GetControlBounds(this.data.control, rect);
            width = rect.right - rect.left;
            height = rect.bottom - rect.top;
        } else if (this.data.image != null) {
            int image = this.data.image.handle;
            width = OS.CGImageGetWidth(image);
            height = OS.CGImageGetHeight(image);
        }
        int clipRgn = this.data.clipRgn;
        if (clipRgn == 0) {
            return new Rectangle(0, 0, width, height);
        }
        int rgn = OS.NewRgn();
        OS.SetRectRgn(rgn, (short)0, (short)0, (short)width, (short)height);
        OS.SectRgn(rgn, clipRgn, rgn);
        OS.GetRegionBounds(rgn, rect);
        OS.DisposeRgn(rgn);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public void getClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        Rect bounds = null;
        int clipping = region.handle;
        if (this.data.clipRgn == 0) {
            int width = 0;
            int height = 0;
            if (this.data.control != 0) {
                if (bounds == null) {
                    bounds = new Rect();
                }
                OS.GetControlBounds(this.data.control, bounds);
                width = bounds.right - bounds.left;
                height = bounds.bottom - bounds.top;
            } else if (this.data.image != null) {
                int image = this.data.image.handle;
                width = OS.CGImageGetWidth(image);
                height = OS.CGImageGetHeight(image);
            }
            OS.SetRectRgn(clipping, (short)0, (short)0, (short)width, (short)height);
        } else {
            OS.CopyRgn(this.data.clipRgn, clipping);
            if (!this.isIdentity(this.data.transform)) {
                return;
            }
        }
        if (this.data.paintEvent != 0 && this.data.visibleRgn != 0) {
            if (bounds == null) {
                bounds = new Rect();
            }
            OS.GetControlBounds(this.data.control, bounds);
            OS.OffsetRgn(this.data.visibleRgn, -bounds.left, -bounds.top);
            OS.SectRgn(this.data.visibleRgn, clipping, clipping);
            OS.OffsetRgn(this.data.visibleRgn, bounds.left, bounds.top);
        }
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.fillRule;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        Font font = this.data.font;
        FontInfo info = new FontInfo();
        OS.FetchFontInfo(font.id, font.size, font.style, info);
        short ascent = info.ascent;
        short descent = info.descent;
        short leading = info.leading;
        String s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        int averageCharWidth = this.stringExtent((String)s).x / s.length();
        return FontMetrics.carbon_new(ascent, descent, averageCharWidth, leading, ascent + leading + descent);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return Color.carbon_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return this.data.foregroundPattern;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int interpolation = OS.CGContextGetInterpolationQuality(this.handle);
        switch (interpolation) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        int[] lengths;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((lengths = this.data.dashes) == null) {
            return null;
        }
        int[] dashes = new int[lengths.length];
        System.arraycopy(lengths, 0, dashes, 0, dashes.length);
        return dashes;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.textAntialias;
    }

    public void getTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        float[] cmt = this.data.transform;
        transform.setElements(cmt[0], cmt[1], cmt[2], cmt[3], cmt[4], cmt[5]);
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData data, int context) {
        Image image;
        float[] background;
        int colorspace = data.device.colorspace;
        OS.CGContextSetStrokeColorSpace(context, colorspace);
        OS.CGContextSetFillColorSpace(context, colorspace);
        float[] foreground = data.foreground;
        if (foreground != null) {
            OS.CGContextSetStrokeColor(context, foreground);
        }
        if ((background = data.background) != null) {
            OS.CGContextSetFillColor(context, background);
        }
        if ((image = data.image) != null) {
            image.memGC = this;
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = context;
        if (data.font != null) {
            this.setGCFont();
        }
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    boolean isIdentity(float[] transform) {
        return transform[0] == 1.0f && transform[1] == 0.0f && transform[2] == 0.0f && transform[3] == 1.0f && transform[4] == 0.0f && transform[5] == 0.0f;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (!advanced) {
            this.setAlpha(255);
            this.setAntialias(-1);
            this.setBackgroundPattern(null);
            this.setClipping(0);
            this.setForegroundPattern(null);
            this.setInterpolation(-1);
            this.setTextAntialias(-1);
            this.setTransform(null);
        }
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.alpha = alpha & 0xFF;
        OS.CGContextSetAlpha(this.handle, (float)this.data.alpha / 255.0f);
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        boolean mode = true;
        switch (antialias) {
            case -1: {
                if (this.data.window == 0 || this.data.control != 0) break;
                mode = false;
                break;
            }
            case 0: {
                mode = false;
                break;
            }
            case 1: {
                mode = true;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.antialias = antialias;
        OS.CGContextSetShouldAntialias(this.handle, mode);
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        int colorspace = this.data.device.colorspace;
        OS.CGContextSetFillColorSpace(this.handle, colorspace);
        OS.CGContextSetFillColor(this.handle, color.handle);
        if (this.data.backPattern != 0) {
            OS.CGPatternRelease(this.data.backPattern);
        }
        this.data.backPattern = 0;
        this.data.backgroundPattern = null;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backPattern != 0) {
            OS.CGPatternRelease(this.data.backPattern);
        }
        if (pattern != null) {
            int colorspace = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
            OS.CGContextSetFillColorSpace(this.handle, colorspace);
            OS.CGColorSpaceRelease(colorspace);
            this.data.backPattern = pattern.createPattern(this.handle);
            OS.CGContextSetFillPattern(this.handle, this.data.backPattern, this.data.background);
        } else {
            int colorspace = this.data.device.colorspace;
            OS.CGContextSetFillColorSpace(this.handle, colorspace);
            float[] color = this.data.background;
            OS.CGContextSetFillColor(this.handle, color);
            this.data.backPattern = 0;
        }
        this.data.backgroundPattern = pattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setClipping(int clipRgn) {
        if (clipRgn == 0) {
            if (this.data.clipRgn == 0) return;
            OS.DisposeRgn(this.data.clipRgn);
            this.data.clipRgn = 0;
        } else {
            if (this.data.clipRgn == 0) {
                this.data.clipRgn = OS.NewRgn();
            }
            OS.CopyRgn(clipRgn, this.data.clipRgn);
        }
        this.data.updateClip = true;
        this.setCGClipping();
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        int clipRgn = OS.NewRgn();
        OS.SetRectRgn(clipRgn, (short)x, (short)y, (short)(x + width), (short)(y + height));
        this.setClipping(clipRgn);
        OS.DisposeRgn(clipRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(0);
        if (path != null) {
            OS.CGContextAddPath(this.handle, path.handle);
            OS.CGContextEOClip(this.handle);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    void setCGClipping() {
        this.data.updateClip = false;
        if (this.data.control == 0) {
            OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
            if (this.data.clipRgn != 0) {
                OS.ClipCGContextToRegion(this.handle, new Rect(), this.data.clipRgn);
            } else {
                int rgn = OS.NewRgn();
                OS.SetRectRgn(rgn, (short)Short.MIN_VALUE, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)Short.MAX_VALUE);
                OS.ClipCGContextToRegion(this.handle, new Rect(), rgn);
                OS.DisposeRgn(rgn);
            }
            OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
            return;
        }
        int port = this.data.port;
        if (port == 0) {
            int window = OS.GetControlOwner(this.data.control);
            port = OS.GetWindowPort(window);
        }
        Rect portRect = this.data.portRect;
        Rect rect = this.data.controlRect;
        OS.CGContextTranslateCTM(this.handle, -rect.left, portRect.bottom - portRect.top - rect.top);
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        OS.GetPortBounds(port, portRect);
        OS.GetControlBounds(this.data.control, rect);
        if (this.data.clipRgn != 0) {
            int rgn = OS.NewRgn();
            OS.CopyRgn(this.data.clipRgn, rgn);
            OS.OffsetRgn(rgn, rect.left, rect.top);
            OS.SectRgn(this.data.visibleRgn, rgn, rgn);
            OS.ClipCGContextToRegion(this.handle, portRect, rgn);
            OS.DisposeRgn(rgn);
        } else {
            OS.ClipCGContextToRegion(this.handle, portRect, this.data.visibleRgn);
        }
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(this.handle, rect.left, -(portRect.bottom - portRect.top) + rect.top);
    }

    public void setFillRule(int rule) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (rule) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.fillRule = rule;
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            font = this.data.device.systemFont;
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font;
        this.setGCFont();
    }

    void setGCFont() {
        int tabs = this.data.tabs;
        if (tabs != 0) {
            OS.DisposePtr(tabs);
        }
        this.data.tabs = 0;
        Font font = this.data.font;
        FontInfo info = new FontInfo();
        OS.FetchFontInfo(font.id, font.size, font.style, info);
        this.data.fontAscent = info.ascent;
        this.data.fontDescent = info.descent;
        if (font.atsuiStyle == 0) {
            if (this.data.atsuiStyle != 0) {
                OS.ATSUDisposeStyle(this.data.atsuiStyle);
            }
            this.data.atsuiStyle = font.createStyle();
        }
        this.data.string = null;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        int colorspace = this.data.device.colorspace;
        OS.CGContextSetStrokeColorSpace(this.handle, colorspace);
        OS.CGContextSetStrokeColor(this.handle, color.handle);
        if (this.data.forePattern != 0) {
            OS.CGPatternRelease(this.data.forePattern);
        }
        this.data.forePattern = 0;
        this.data.foregroundPattern = null;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.forePattern != 0) {
            OS.CGPatternRelease(this.data.forePattern);
        }
        if (pattern != null) {
            int colorspace = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
            OS.CGContextSetStrokeColorSpace(this.handle, colorspace);
            OS.CGColorSpaceRelease(colorspace);
            this.data.forePattern = pattern.createPattern(this.handle);
            OS.CGContextSetStrokePattern(this.handle, this.data.forePattern, this.data.foreground);
        } else {
            int colorspace = this.data.device.colorspace;
            OS.CGContextSetStrokeColorSpace(this.handle, colorspace);
            float[] color = this.data.foreground;
            OS.CGContextSetStrokeColor(this.handle, color);
            this.data.forePattern = 0;
        }
        this.data.foregroundPattern = pattern;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int quality = 0;
        switch (interpolation) {
            case -1: {
                quality = 0;
                break;
            }
            case 0: {
                quality = 1;
                break;
            }
            case 1: {
                quality = 2;
                break;
            }
            case 2: {
                quality = 3;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.CGContextSetInterpolationQuality(this.handle, quality);
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int cap_style = 0;
        switch (cap) {
            case 2: {
                cap_style = 1;
                break;
            }
            case 1: {
                cap_style = 0;
                break;
            }
            case 3: {
                cap_style = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        OS.CGContextSetLineCap(this.handle, cap_style);
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] lengths = null;
        if (dashes != null && dashes.length != 0) {
            lengths = new float[dashes.length];
            int i = 0;
            while (i < lengths.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                lengths[i] = dash;
                ++i;
            }
            this.data.dashes = new int[dashes.length];
            System.arraycopy(dashes, 0, this.data.dashes, 0, dashes.length);
            this.data.lineStyle = 6;
        } else {
            this.data.dashes = null;
            this.data.lineStyle = 1;
        }
        OS.CGContextSetLineDash(this.handle, 0.0f, lengths, lengths != null ? lengths.length : 0);
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int join_style = 0;
        switch (join) {
            case 1: {
                join_style = 0;
                break;
            }
            case 2: {
                join_style = 1;
                break;
            }
            case 3: {
                join_style = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        OS.CGContextSetLineJoin(this.handle, join_style);
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int[] dashes = null;
        int width = this.data.lineWidth;
        switch (lineStyle) {
            case 1: {
                break;
            }
            case 2: {
                dashes = width != 0 ? LINE_DASH : LINE_DASH_ZERO;
                break;
            }
            case 3: {
                dashes = width != 0 ? LINE_DOT : LINE_DOT_ZERO;
                break;
            }
            case 4: {
                dashes = width != 0 ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                break;
            }
            case 5: {
                dashes = width != 0 ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                break;
            }
            case 6: {
                dashes = this.data.dashes;
                if (dashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        if (dashes != null) {
            float[] lengths = new float[dashes.length];
            int i = 0;
            while (i < lengths.length) {
                lengths[i] = width == 0 ? dashes[i] : dashes[i] * width;
                ++i;
            }
            OS.CGContextSetLineDash(this.handle, 0.0f, lengths, lengths.length);
        } else {
            OS.CGContextSetLineDash(this.handle, 0.0f, null, 0);
        }
    }

    public void setLineWidth(int width) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.lineWidth = width;
        OS.CGContextSetLineWidth(this.handle, Math.max(1, width));
        switch (this.data.lineStyle) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.setLineStyle(this.data.lineStyle);
            }
        }
    }

    int setString(String string, int flags) {
        if (this.data.layout == 0) {
            this.createLayout();
        }
        if (string == this.data.string && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return this.data.stringLength;
        }
        int layout = this.data.layout;
        int length = string.length();
        char[] chars = new char[length];
        string.getChars(0, length, chars, 0);
        int breakCount = 0;
        int[] breaks = null;
        if ((flags & 0xA) != 0) {
            int i = 0;
            int j = 0;
            block4: while (i < chars.length) {
                int n = j++;
                char c = chars[i++];
                chars[n] = c;
                char c2 = c;
                switch (c2) {
                    case '&': {
                        if ((flags & 8) == 0 || i == chars.length) continue block4;
                        if (chars[i] == '&') {
                            ++i;
                            break;
                        }
                        --j;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if ((flags & 2) == 0) break;
                        if (c2 == '\r' && i != chars.length && chars[i] == '\n') {
                            ++i;
                        }
                        --j;
                        if (breaks == null) {
                            breaks = new int[4];
                        } else if (breakCount == breaks.length) {
                            int[] newBreaks = new int[breaks.length + 4];
                            System.arraycopy(breaks, 0, newBreaks, 0, breaks.length);
                            breaks = newBreaks;
                        }
                        breaks[breakCount++] = j;
                    }
                }
            }
            length = j;
        }
        if ((flags & 4) != 0) {
            if (this.data.tabs == 0) {
                this.createTabs();
            }
            OS.ATSUSetTabArray(layout, this.data.tabs, 32);
        } else {
            OS.ATSUSetTabArray(layout, 0, 0);
        }
        int ptr = OS.NewPtr(length * 2);
        OS.memcpy(ptr, chars, length * 2);
        OS.ATSUSetTextPointerLocation(layout, ptr, 0, length, length);
        if ((flags & 2) != 0 && breaks != null) {
            int i = 0;
            while (i < breakCount) {
                OS.ATSUSetSoftLineBreak(layout, breaks[i]);
                ++i;
            }
        }
        Font font = this.data.font;
        int atsuiStyle = font.atsuiStyle != 0 ? font.atsuiStyle : this.data.atsuiStyle;
        OS.ATSUSetRunStyle(layout, atsuiStyle, 0, length);
        OS.ATSUSetTransientFontMatching(layout, true);
        if (this.data.stringPtr != 0) {
            OS.DisposePtr(this.data.stringPtr);
        }
        this.data.stringPtr = ptr;
        this.data.string = string;
        this.data.stringLength = length;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = flags;
        return length;
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.xorMode = xor;
    }

    int regionToRects(int message, int rgn, int r, int newRgn) {
        if (message == 2) {
            Rect rect = new Rect();
            OS.memcpy(rect, r, 8);
            CGPoint point = new CGPoint();
            int polyRgn = OS.NewRgn();
            OS.OpenRgn();
            point.x = rect.left;
            point.y = rect.top;
            OS.CGPointApplyAffineTransform(point, this.data.inverseTransform, point);
            OS.MoveTo((short)Math.round(point.x), (short)Math.round(point.y));
            point.x = rect.right;
            point.y = rect.top;
            OS.CGPointApplyAffineTransform(point, this.data.inverseTransform, point);
            OS.LineTo((short)Math.round(point.x), (short)Math.round(point.y));
            point.x = rect.right;
            point.y = rect.bottom;
            OS.CGPointApplyAffineTransform(point, this.data.inverseTransform, point);
            OS.LineTo((short)Math.round(point.x), (short)Math.round(point.y));
            point.x = rect.left;
            point.y = rect.bottom;
            OS.CGPointApplyAffineTransform(point, this.data.inverseTransform, point);
            OS.LineTo((short)Math.round(point.x), (short)Math.round(point.y));
            OS.CloseRgn(polyRgn);
            OS.UnionRgn(newRgn, polyRgn, newRgn);
            OS.DisposeRgn(polyRgn);
        }
        return 0;
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (antialias) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.textAntialias = antialias;
    }

    public void setTransform(Transform transform) {
        int clipRgn;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        OS.CGContextConcatCTM(this.handle, this.data.inverseTransform);
        if (transform != null) {
            OS.CGContextConcatCTM(this.handle, transform.handle);
            System.arraycopy(transform.handle, 0, this.data.transform, 0, this.data.transform.length);
            System.arraycopy(transform.handle, 0, this.data.inverseTransform, 0, this.data.inverseTransform.length);
            OS.CGAffineTransformInvert(this.data.inverseTransform, this.data.inverseTransform);
        } else {
            this.data.transform = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            this.data.inverseTransform = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        }
        if (this.data.forePattern != 0) {
            OS.CGPatternRelease(this.data.forePattern);
            this.data.forePattern = this.data.foregroundPattern.createPattern(this.handle);
            OS.CGContextSetStrokePattern(this.handle, this.data.forePattern, this.data.foreground);
        }
        if (this.data.backPattern != 0) {
            OS.CGPatternRelease(this.data.backPattern);
            this.data.backPattern = this.data.backgroundPattern.createPattern(this.handle);
            OS.CGContextSetFillPattern(this.handle, this.data.backPattern, this.data.background);
        }
        if ((clipRgn = this.data.clipRgn) != 0) {
            int newRgn = OS.NewRgn();
            Callback callback = new Callback(this, "regionToRects", 4);
            int proc = callback.getAddress();
            if (proc == 0) {
                SWT.error(3);
            }
            OS.QDRegionToRects(clipRgn, 5, proc, newRgn);
            callback.dispose();
            OS.DisposeRgn(clipRgn);
            this.data.clipRgn = newRgn;
        }
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        int height;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        int length = this.setString(string, flags);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        int width = 0;
        if (length == 0) {
            height = this.data.fontAscent + this.data.fontDescent;
        } else {
            ATSTrapezoid trapezoid = new ATSTrapezoid();
            if ((flags & 2) != 0) {
                height = 0;
                int layout = this.data.layout;
                int[] breakCount = new int[1];
                OS.ATSUGetSoftLineBreaks(layout, 0, length, 0, null, breakCount);
                int[] breaks = new int[breakCount[0] + 1];
                OS.ATSUGetSoftLineBreaks(layout, 0, length, breakCount[0], breaks, breakCount);
                breaks[breakCount[0]] = length;
                int i = 0;
                int start = 0;
                while (i < breaks.length) {
                    int lineBreak = breaks[i];
                    OS.ATSUGetGlyphBounds(layout, 0, 0, start, lineBreak - start, (short)1, 1, trapezoid, null);
                    width = Math.max(width, OS.Fix2Long(trapezoid.upperRight_x) - OS.Fix2Long(trapezoid.upperLeft_x));
                    height += OS.Fix2Long(trapezoid.lowerRight_y) - OS.Fix2Long(trapezoid.upperRight_y);
                    start = lineBreak;
                    ++i;
                }
            } else {
                OS.ATSUGetGlyphBounds(this.data.layout, 0, 0, 0, length, (short)1, 1, trapezoid, null);
                width = OS.Fix2Long(trapezoid.upperRight_x) - OS.Fix2Long(trapezoid.upperLeft_x);
                height = OS.Fix2Long(trapezoid.lowerRight_y) - OS.Fix2Long(trapezoid.upperRight_y);
            }
        }
        this.data.stringWidth = width;
        this.data.stringHeight = height;
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

