/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private static final String DRAGSOURCEID = "DragSource";
    private static Callback DragSendDataProc;
    static /* synthetic */ Class class$0;

    static {
        int dragSendDataProcAddress;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((dragSendDataProcAddress = (DragSendDataProc = new Callback(clazz, "DragSendDataProc", 4)).getAddress()) == 0) {
            SWT.error(3);
        }
    }

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (control.getData(DRAGSOURCEID) != null) {
            DND.error(2000);
        }
        control.setData(DRAGSOURCEID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    private static int DragSendDataProc(int theType, int dragSendRefCon, int theItemRef, int theDrag) {
        DragSource source = DragSource.FindDragSource(dragSendRefCon, theDrag);
        if (source == null) {
            return -1854;
        }
        return source.dragSendDataProc(theType, dragSendRefCon, theItemRef, theDrag);
    }

    private static DragSource FindDragSource(int dragSendRefCon, int theDrag) {
        if (dragSendRefCon == 0) {
            return null;
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(dragSendRefCon);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData(DRAGSOURCEID);
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drag(Event dragEvent) {
        block17: {
            event = new DNDEvent();
            event.widget = this;
            event.time = dragEvent.time;
            event.doit = true;
            this.notifyListeners(2008, event);
            if (!event.doit || this.transferAgents == null || this.transferAgents.length == 0) {
                return;
            }
            theDrag = new int[1];
            if (OS.NewDrag(theDrag) != 0) {
                event = new DNDEvent();
                event.widget = this;
                event.time = (int)System.currentTimeMillis();
                event.doit = false;
                event.detail = 0;
                this.notifyListeners(2000, event);
                return;
            }
            pt = new Point();
            OS.GetGlobalMouse(pt);
            i = 0;
            while (true) {
                if (i >= this.transferAgents.length) {
                    OS.SetDragSendProc(theDrag[0], DragSource.DragSendDataProc.getAddress(), this.control.handle);
                    theRegion = 0;
                    ** try [egrp 0[TRYBLOCK] [0 : 394->617)] { 
lbl26:
                    // 1 sources

                    break;
                }
                types = this.transferAgents[i].getTypeIds();
                if (this.transferAgents[i] instanceof FileTransfer) {
                    transferData = new TransferData();
                    transferData.type = types[0];
                    event = new DNDEvent();
                    event.widget = this;
                    event.time = (int)System.currentTimeMillis();
                    event.dataType = transferData;
                    this.notifyListeners(2001, event);
                    if (event.data == null) {
                        return;
                    }
                    transferAgent = this.transferAgents[i];
                    j = 0;
                    block4: while (j < types.length) {
                        transferData.type = types[j];
                        transferAgent.javaToNative(event.data, transferData);
                        if (transferData.result != 0) {
                            return;
                        }
                        k = 0;
                        while (true) {
                            if (k >= transferData.data.length) {
                                ++j;
                                continue block4;
                            }
                            datum = transferData.data[k];
                            OS.AddDragItemFlavor(theDrag[0], 1 + k, types[j], datum, datum.length, 0);
                            ++k;
                        }
                    }
                } else {
                    j = 0;
                    while (j < types.length) {
                        OS.AddDragItemFlavor(theDrag[0], 1, types[j], null, 0, 0);
                        ++j;
                    }
                }
                ++i;
            }
            {
                theRegion = OS.NewRgn();
                OS.SetRectRgn(theRegion, (short)(pt.h - 10), (short)(pt.v - 10), (short)(pt.h + 10), (short)(pt.v + 10));
                operations = this.opToOsOp(this.getStyle());
                OS.SetDragAllowableActions(theDrag[0], operations, true);
                OS.SetDragAllowableActions(theDrag[0], operations, false);
                theEvent = new EventRecord();
                theEvent.message = 5;
                theEvent.modifiers = (short)OS.GetCurrentEventKeyModifiers();
                theEvent.what = (short)15;
                theEvent.where_h = pt.h;
                theEvent.where_v = pt.v;
                result = OS.TrackDrag(theDrag[0], theEvent, theRegion);
                operation = 0;
                if (result == 0) {
                    outAction = new int[1];
                    OS.GetDragDropAction(theDrag[0], outAction);
                    operation = this.osOpToOp(outAction[0]);
                }
                event = new DNDEvent();
                event.widget = this;
                event.time = (int)System.currentTimeMillis();
                event.doit = result == 0;
                event.detail = operation;
                this.notifyListeners(2000, event);
            }
lbl91:
            // 1 sources

            catch (Throwable var12_16) {
                var11_15 = null;
                if (theRegion != 0) {
                    OS.DisposeRgn(theRegion);
                }
                throw var12_16;
            }
            {
                var11_15 = null;
                if (theRegion == 0) break block17;
            }
            OS.DisposeRgn(theRegion);
        }
        OS.DisposeDrag(theDrag[0]);
    }

    int dragSendDataProc(int theType, int dragSendRefCon, int theItemRef, int theDrag) {
        if (theType == 0) {
            return -1852;
        }
        TransferData transferData = new TransferData();
        transferData.type = theType;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = (int)System.currentTimeMillis();
        event.dataType = transferData;
        this.notifyListeners(2001, event);
        Transfer transfer = null;
        int i = 0;
        while (i < this.transferAgents.length) {
            if (this.transferAgents[i].isSupportedType(transferData)) {
                transfer = this.transferAgents[i];
                break;
            }
            ++i;
        }
        if (transfer == null) {
            return -1852;
        }
        transfer.javaToNative(event.data, transferData);
        if (transferData.result != 0) {
            return transferData.result;
        }
        byte[] datum = transferData.data[0];
        if (datum == null) {
            return -1854;
        }
        return OS.SetDragItemFlavorData(theDrag, theItemRef, theType, datum, datum.length, 0);
    }

    public Control getControl() {
        return this.control;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DRAGSOURCEID, null);
        this.control = null;
        this.transferAgents = null;
    }

    private int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 2;
        }
        if ((operation & 2) != 0) {
            osOperation |= 0x10;
        }
        if ((operation & 8) != 0) {
            osOperation |= 0x20;
        }
        return osOperation;
    }

    private int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 2) != 0) {
            operation |= 4;
        }
        if ((osOperation & 0x20) != 0) {
            operation |= 8;
        }
        if ((osOperation & 0x10) != 0) {
            operation |= 2;
        }
        if (osOperation == -1) {
            operation = 7;
        }
        return operation;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    public void setTransfer(Transfer[] transferAgents) {
        this.transferAgents = transferAgents;
    }
}

