/*
 * Created on 19-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.herac.tuxguitar.io.gp.GP3OutputStream;
import org.herac.tuxguitar.io.gp.GP4OutputStream;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGOutputStream;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SongWriter {
    private static final String TG_EXTENSION = ".TG";
    private static final String GP3_EXTENSION = ".GP3";
    private static final String GP4_EXTENSION = ".GP4";
    
    private String fileName;
    
    public SongWriter(String fileName){
        this.fileName = fileName;
    }
    
    public void write(Song song) throws GPFormatException, IOException{        
        if(hasExtension(TG_EXTENSION)){
            writeTGFile(song);
        }else if(hasExtension(GP3_EXTENSION)){
            writeGP3File(song);
        }else if(hasExtension(GP4_EXTENSION)){
            writeGP4File(song);
        }
    }
    
    
    private boolean hasExtension(String extension) {
        return (this.fileName.toUpperCase().endsWith(extension)) ;
    }    
    
    private void writeTGFile(Song song) throws FileNotFoundException{
        new TGOutputStream(fileName).write(song);
    }    
    
    private void writeGP3File(Song song) throws FileNotFoundException, IOException{
        new GP3OutputStream(new FileOutputStream(fileName)).writeSong(song);      
    }

    private void writeGP4File(Song song) throws FileNotFoundException, IOException{
        new GP4OutputStream(new FileOutputStream(fileName)).writeSong(song);      
    }
}
