package org.herac.tuxguitar.gui.undo.undoables.measure;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;

public class UndoableAddMeasure implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;	
	private long undoablePosition;
	
	private UndoableAddMeasure(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		TuxGuitar.instance().getSongManager().addNewMeasureBeforeEnd();
		int number = (getCaret().getSongTrackCoords().getTrack().getMeasures().size());
		TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(number,true);
		this.redoCaret.update();
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}	
		TuxGuitar.instance().getSongManager().removeMeasure(undoablePosition);
		TuxGuitar.instance().fireUpdate();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public static UndoableAddMeasure startUndo(){
    	UndoableAddMeasure undoable = new UndoableAddMeasure();
    	Caret caret = getCaret();    	    	
    	undoable.undoCaret = new UndoableCaretHelper();
    	undoable.doAction = UNDO_ACTION;	
    	
    	return undoable;
    }
    
    public UndoableAddMeasure endUndo(long undoablePosition){
    	this.redoCaret = new UndoableCaretHelper();
    	this.undoablePosition = undoablePosition;
    	return this;
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  

}
