/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class NoteCoords implements MeasureComponent {    
    /**
     * desviacion a la izquierda
     */
    private static final int JOINED_TYPE_NONE_LEFT = 1;
    /**
     * desviacion a la derecha
     */
    private static final int JOINED_TYPE_NONE_RIGHT = 2;    
    /**
     * Union a la izquierda
     */
    private static final int JOINED_TYPE_LEFT = 3;
    /**
     * Union a la derecha
     */
    private static final int JOINED_TYPE_RIGHT = 4;
    /**
     * Widget de la tablatura
     */
    private Tablature tablature;    
    /**
     * Coordenadas del compas
     */
    private MeasureCoords meassureCoords;
    /**
     * Nota de Referencia
     */
    private Note note;
    /**
     * Posicion X dentro del compas
     */
    private int posX;
    /**
     * Posicion Y dentro del compas
     */
    private int posY;
    /**
     * Ultimo from X
     */
    private int lastFromX;
    /**
     * Ultimo from Y
     */
    private int lastFromY;
    /**
     * Coordenadas de los dibujos de las figuras
     */
    private DurationCoords durationCoords;
    /**
     * Tipo de union de notas
     */
    private int joinedType;
    /**
     * Pista de Referencia
     */
    private SongTrackCoords trackCoords;

    private Image bendImage;
    
    private int span;
    
    private int pointX;
    
    private int pointY;
    
    
    public NoteCoords(Tablature tablature, SongTrackCoords trackCoords, MeasureCoords meassureCoords, Note note, int posX, int posY) {
        this.tablature = tablature;
        this.trackCoords = trackCoords;
        this.meassureCoords = meassureCoords;
        this.note = note;
        this.posX = posX;
        this.posY = posY;
        this.durationCoords = new DurationCoords();
    }

    /**
     * Actualiza los valores para dibujar
     */
    public void update() {
        this.joinedType = JOINED_TYPE_NONE_RIGHT;
        this.durationCoords.setNote1(this);
        this.durationCoords.setNote2(this);
        this.durationCoords.setEighthY(meassureCoords.getHeight() + 25);
        this.durationCoords.setSixteenthY(meassureCoords.getHeight() + 20);
        this.durationCoords.setThirtySecondY(meassureCoords.getHeight() + 15);
        this.durationCoords.setSixtyFourthY(meassureCoords.getHeight() + 10);

        boolean noteJoined = false;
        boolean widthPrev = false;

        MeasureComponent prevComponent = meassureCoords.getPreviousComponent(this);
        MeasureComponent nextComponent = meassureCoords.getNextComponent(this);
        NoteCoords prevNote = null;
        NoteCoords nextNote = null;

        //trato de unir con el componente anterior
        if (prevComponent instanceof NoteCoords) {
            prevNote = (NoteCoords) prevComponent;
            if (meassureCoords.areInSameBeat(this, prevNote)) {
                widthPrev = true;
                if (prevNote.getNote().getDuration().getValue() >= note.getDuration().getValue()) {
                    this.durationCoords.setNote1(prevNote);
                    if (nextNote == null || nextNote.getNote().getDuration().getValue() < note.getDuration().getValue()) {
                        this.durationCoords.setNote2(this);
                    }
                    noteJoined = true;
                    this.joinedType = JOINED_TYPE_LEFT;
                }
            }
        }

        //trato de unir con el componente que le sigue
        if (nextComponent instanceof NoteCoords) {
            nextNote = (NoteCoords) nextComponent;
            if (meassureCoords.areInSameBeat(this, nextNote)) {
                if (nextNote.getNote().getDuration().getValue() >= note.getDuration().getValue()) {
                    this.durationCoords.setNote2(nextNote);
                    if (prevNote == null || prevNote.getNote().getDuration().getValue() < note.getDuration().getValue()) {
                        this.durationCoords.setNote1(this);
                    }
                    noteJoined = true;
                    this.joinedType = JOINED_TYPE_RIGHT;
                }
            }

        }

        //si no hubo union decido para que lado girar la figura
        if (!noteJoined && widthPrev) {            
            this.joinedType = JOINED_TYPE_NONE_LEFT;            
        }

        this.updateUsedStrings();
        this.updateEffects();
    }

    private void updateUsedStrings() {
        if (note.getDuration().getValue() >= Duration.QUARTER) {
            boolean[] usedStrings = new boolean[trackCoords.getTrack().getStrings().size()];
            List notesAtBeat = this.meassureCoords.getComponents(getStart());
            Iterator it = notesAtBeat.iterator();
            while (it.hasNext()) {
                MeasureComponent component = (MeasureComponent) it.next();
                if (component instanceof NoteCoords) {
                    NoteCoords currNote = (NoteCoords) component;
                    usedStrings[currNote.getNote().getString() - 1] = true;
                }
            }
            this.durationCoords.setUsedStrings(usedStrings);
        }
    }

    
    private void updateEffects(){
        
        if(getNote().getEffect().hasEffects()){
        	this.bendImage = SystemImages.BEND_IMAGE;
        }
        
    }
    
    /**
     * Pinta la nota
     */
    public void paint(ViewLayout layout,GC gc, int fromX, int fromY) {
        int x = fromX + getPosX() + getSpan();
        int y = fromY + getPosY();
        this.pointX = x;
        
        if(layout.isPlayModeEnabled() && isPlaying()){
            gc.setForeground(this.tablature.getDisplay().getSystemColor(SWT.COLOR_RED));
        } 
        layout.setNoteStyle(gc);
        if (getNote().isTiedNote()) {
            NoteCoords noteForTie = getNoteForTie();
            if (noteForTie != null && noteForTie.isAtSameLine(fromY)) {
            	              
                    int ligadureX = noteForTie.getPointX();
                    int ligadureY = noteForTie.getLastFromY() + noteForTie.getPosY() + 10;
                    gc.drawArc(ligadureX, ligadureY, (x - ligadureX), -30, 225, 90);
                
            }else{
            	Point p = layout.getNoteOrientation(x,y,note);
            	gc.drawString("L", p.x, p.y);              
            }                     
        } else {
        	Point p = layout.getNoteOrientation(x,y,note);
        	String visualNote = (note.getEffect().isDeadNote())?"X":Integer.toString(getNote().getValue());
        	gc.drawString(visualNote, p.x, p.y); 
        }
        
        if(layout.isPlayModeEnabled() && isPlaying()){
            gc.drawString(">", (fromX + getPosX() + getSpan()) - 2,fromY +  this.meassureCoords.getHeight() + 50);   
            gc.setForeground(new Color(this.tablature.getDisplay(),0, 0, 0));
        }
        
        paintDuration(layout,gc, fromX, fromY);
        paintEffects(gc,fromX,fromY);

        this.lastFromX = fromX;
        this.lastFromY = fromY;
    }

    
    
    /**
     * Encuentra la nota a la que esta ligada
     */
    private NoteCoords getNoteForTie() {
        //Primero lo busco en el compas actual
        List currComponents = this.meassureCoords.getComponentsBeforeEnd(this.meassureCoords.getMeasure().getStart());
        for (int cIdx = currComponents.size() - 1; cIdx >= 0; cIdx--) {
            MeasureComponent component = (MeasureComponent) currComponents.get(cIdx);
            if (component.getStart() < getNote().getStart()) {
                if (component instanceof NoteCoords) {
                    NoteCoords noteCoords = (NoteCoords) component;

                    if (noteCoords.getNote().getString() == getNote().getString()) {
                        return noteCoords;
                    }
                }
            }
        }

        //si no estaba en este compas lo busco en los anteriores
        for (int mIdx = (this.meassureCoords.getMeasure().getNumber() - 1); mIdx >= 0; mIdx--) {
            MeasureCoords measureCoords = (MeasureCoords) this.trackCoords.getMeasuresCoords().get(mIdx);

            List components = measureCoords.getComponentsBeforeEnd(measureCoords.getMeasure().getStart());
            for (int cIdx = components.size() - 1; cIdx >= 0; cIdx--) {
                MeasureComponent component = (MeasureComponent) components.get(cIdx);
                if (component.getStart() < getNote().getStart()) {
                    if (component instanceof NoteCoords) {
                        NoteCoords noteCoords = (NoteCoords) component;

                        if (noteCoords.getNote().getString() == getNote().getString()) {
                            return noteCoords;
                        }
                    }
                }
            }
        }
        return null;
    }

    /**
     * Pinta la figura de la Duracion
     */
    private void paintDuration(ViewLayout layout,GC gc, int fromX, int fromY) {
        int x = fromX + getPosX() + getSpan();
        int y2 = fromY + meassureCoords.getHeight() + 25;

        paintVerticalLine(layout,gc, fromX, fromY);

        if (note.getDuration().getValue() >= Duration.EIGHTH) {
            paintJoindeds(gc, fromX, fromY);
        }

        if (note.getDuration().isDotted() || note.getDuration().isDoubleDotted()) {
            paintDotted(gc, fromX, fromY,note.getDuration().isDoubleDotted());
        }
        if (!note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
            gc.drawString(Integer.toString(note.getDuration().getTupleto().getEnters()), x - 3, y2 + 10);
        }
    }

    private void paintVerticalLine(ViewLayout layout,GC gc, int fromX, int fromY) {
        int x = fromX + getPosX() + getSpan();
        int stringSpan = layout.getStringSpan();
        if (note.getDuration().getValue() >= Duration.QUARTER) {

            boolean[] usedStrings = this.durationCoords.getUsedStrings();
            for (int i = getNote().getString() - 1; i < usedStrings.length; i++) {
                if (!usedStrings[i]) {
                    int stringPosition = fromY + (stringSpan * (i + 1));
                    int y1 = stringPosition - (stringSpan / 2);
                    int y2 = stringPosition + (stringSpan / 2);
                	
                    gc.drawLine(x, y1, x, y2);
                }
            }
            int y = fromY + meassureCoords.getHeight() + (stringSpan / 2);
            gc.drawLine(x, y, x, y + 19);
        } else if (note.getDuration().getValue() == Duration.HALF) {
            int y = fromY + meassureCoords.getHeight() + (stringSpan / 2) + 9;
            gc.drawLine(x, y, x, y + 10);
        }
    }

    /**
     * Pinta las uniones entre notas
     */
    public void paintJoindeds(GC gc, int fromX, int fromY) {
        gc.setLineWidth(2);
        int x1 = 0;
        int x2 = 0;        
        
        if(this.joinedType == JOINED_TYPE_NONE_RIGHT){
            x1 = getPosX() + getSpan();
            x2 = getPosX() + getSpan() + 6;
        }else if(this.joinedType == JOINED_TYPE_NONE_LEFT){
            x1 = getPosX() + getSpan() - 5;
            x2 = getPosX() + getSpan();            
        }else{                              
            x1 = this.durationCoords.getNote1().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote1());
            x2 = this.durationCoords.getNote2().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote2());          
        }

        int eighthY = this.durationCoords.getEighthY();
        int sixteenthY = this.durationCoords.getSixteenthY();
        int thirtySecondY = this.durationCoords.getThirtySecondY();
        int sixtyFourthY = this.durationCoords.getSixtyFourthY();

        switch (note.getDuration().getValue()) {

        case Duration.EIGHTH:
            gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
            break;
        case Duration.SIXTEENTH:
            gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
            gc.drawLine(fromX + x1, fromY + sixteenthY, fromX + x2, fromY + sixteenthY);
            break;
        case Duration.THIRTY_SECOND:
            gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
            gc.drawLine(fromX + x1, fromY + sixteenthY, fromX + x2, fromY + sixteenthY);
            gc.drawLine(fromX + x1, fromY + thirtySecondY, fromX + x2, fromY + thirtySecondY);
            break;
        case Duration.SIXTY_FOURTH:
            gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
            gc.drawLine(fromX + x1, fromY + sixteenthY, fromX + x2, fromY + sixteenthY);
            gc.drawLine(fromX + x1, fromY + thirtySecondY, fromX + x2, fromY + thirtySecondY);
            gc.drawLine(fromX + x1, fromY + sixtyFourthY, fromX + x2, fromY + sixtyFourthY);
            break;
        }
        gc.setLineWidth(1);
    }

    private void paintDotted(GC gc, int fromX, int fromY,boolean doubleDotted) {
        int x = fromX + getPosX()  + getSpan();
        int y = fromY;

        switch (this.joinedType) {
        case JOINED_TYPE_NONE_RIGHT:
            x += 4;
            break;
        case JOINED_TYPE_NONE_LEFT:
            x -= 5;
            break;
        case JOINED_TYPE_LEFT:
            x -= 5;
            break;
        case JOINED_TYPE_RIGHT:
            x += 4;
            break;
        }
        
        switch (note.getDuration().getValue()) {
        case Duration.EIGHTH:
            y += this.durationCoords.getEighthY() - 5;
            break;
        case Duration.SIXTEENTH:
            y += this.durationCoords.getSixteenthY() - 5;
            break;
        case Duration.THIRTY_SECOND:
            y += this.durationCoords.getThirtySecondY() - 5;
            break;
        case Duration.SIXTY_FOURTH:
            y += this.durationCoords.getSixtyFourthY() - 5;
            break;
        default:
            y += meassureCoords.getHeight() + 22;
        	x = fromX + getPosX() + 4  + getSpan();
            break;
        }

        gc.drawOval(x, y, 1, 1);
        if(doubleDotted){
            gc.drawOval(x + 3, y, 1, 1);    
        }
    }

    
    /**
     * Pinta los efectos
     */
    private void paintEffects(GC gc, int fromX, int fromY){
        int x = fromX + getPosX() + getSpan();
        int y = fromY + getPosY();        
        
        NoteEffect effect = getNote().getEffect();
        if(effect.hasEffects()){
            if (effect.isVibrato()) {
                paintVibrato(gc,fromX,fromY);
            }        
            if(effect.isBend()){
                gc.drawImage(this.bendImage,this.posX + fromX + 5 + getSpan(),this.posY + fromY - 12);
            }else if(effect.isSlide() || effect.isHammer()){                                
                int nextFromX = fromX;
                MeasureComponent nextComponent = this.meassureCoords.getNextNoteComponent(this,getNote().getString());

                    if(effect.isSlide()){                

                        if(nextComponent != null){
                            NoteCoords nextNote = (NoteCoords)nextComponent;
                            //int nextX = nextNote.getPosX() + nextFromX;
                            int nextX = nextNote.getPosX() + nextFromX + meassureCoords.getSpanForComponent(nextNote);
                            int nextY = y;
                            if(nextNote.getNote().getValue() < getNote().getValue()){                        
                                y -= 3;
                                nextY += 3;                          
                            }else if(nextNote.getNote().getValue() > getNote().getValue()){
                                y += 3;
                                nextY -= 3;                                             
                            }else{
                                y -= 3;
                                nextY -= 3;
                            }
                            gc.drawLine(x + 5,y,nextX - 2,nextY);
                        }else{
                            gc.drawLine(x + 5,y - 3,x + 20 - 2,y - 3);
                        }
                    }else if(effect.isHammer()){                   
                        if(nextComponent != null){                 
                            NoteCoords nextNote = (NoteCoords)nextComponent;
                            int nextX = nextNote.getPosX() + nextFromX + meassureCoords.getSpanForComponent(nextNote);                        
                            gc.drawArc(x,y, (nextX - x),-5,45,90);
                        }else{
                            gc.drawArc(x,y,20,-5,45,90);
                        }
                    }
                
            }
        }
    }
    
    private void paintVibrato(GC gc,int fromX,int fromY){                        
        int width = getWidth();
        int y1 = fromY - 2;
        int y2 = fromY + 2;
        
        gc.setLineWidth(2);
        for(int x = (this.posX + fromX + getSpan());x < (this.posX + fromX + width + getSpan()) - 5;x += 3){            
            gc.drawLine(x,y1,x + 3,y2);
            y2 = y1;
            y1 = (y1 < fromY)?fromY + 2:fromY - 2;
        }
        
        gc.setLineWidth(1);
    }
    

    private boolean isPlaying(){
        if(meassureCoords.isPlaying()){
            long playerTickPosition = this.tablature.getSongManager().getPlayer().getTickPosition();
            if(playerTickPosition >= getNote().getStart()  && playerTickPosition < getNote().getStart() + getNote().getDuration().getTime()){            
                return true;
            }
        }
        return false;
    }
    
    private int getWidth(){
        double quartersInDuration = ((1.00 / (double)getNote().getDuration().getValue()) * 4.00);
        int width = (int)((double)this.meassureCoords.getQuarterSpan() * quartersInDuration);
        return width;
    }
    
    /**
     * Asigna el start de la nota
     */
    public void setStart(long start) {
        this.note.setStart(start);
    }

    /**
     * Retorna el start de la nota
     */
    public long getStart() {
        return this.note.getStart();
    }

    /**
     * Asigna la duracion de la nota
     */
    public void setDuration(Duration duration) {
        this.note.setDuration(duration);
    }

    /**
     * Retorna la duracion de la nota
     */
    public Duration getDuration() {
        return this.note.getDuration();
    }

    /**
     * Retorna la nota de Referencia
     */
    public Note getNote() {
        return note;
    }

    /**
     * Retorna posicion X dentro del compas
     */
    public int getPosX() {
        return posX;
    }

    /**
     * Retorna posicion Y dentro del compas
     */
    public int getPosY() {
        return posY;
    }

    /**
     * Retorna posicion del ultimo fromX
     */
    public int getLastFromX() {
        return lastFromX;
    }

    /**
     * Retorna posicion del ultimo fromY
     */
    public int getLastFromY() {
        return lastFromY;
    }
    
    public boolean isAtSameLine(int y){
    	return (!meassureCoords.isOutOfBounds() && (getLastFromY() == y));   
    }
    
    public int getSpan(){
        return this.span;
    }
    
    public void setSpan(int span){
        this.span = span;
    }
 
    public int getPointX(){
        return this.pointX;
    }
    public int getPointY(){
        return this.pointY;
    }

	public Component getComponent() {
		return getNote();
	}
    
}