/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableRemoveMeasure;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class RemoveMeasureAction extends Action{
    public static final String NAME = "REMOVE_MEASURE";
    
    public RemoveMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {    	         
	    showDialog(getEditor().getTablature().getShell());
	     
	    redraw();
	    return true;
    }
    
    

    public void showDialog(Shell shell) {
    	SongTrackCoords track = getEditor().getTablature().getCaret().getSongTrackCoords();
        MeasureCoords measure = getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);  
            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("edit.delete"));
            
            //----------------------------------------------------------------------
            Composite range = new Composite(dialog,SWT.NONE);
            range.setLayout(new GridLayout(4,false));
            
            int measureCount = getSongManager().countMeasures();
            
            GridData spinnerData = new GridData();
            spinnerData.widthHint = 26;
            spinnerData.verticalAlignment = SWT.CENTER;
            spinnerData.grabExcessVerticalSpace = true;
            
            Label fromLabel = new Label(range, SWT.NULL);            
            fromLabel.setText(TuxGuitar.getProperty("edit.from"));                        
            final Spinner fromSpinner = new Spinner(range, SWT.BORDER);        
            fromSpinner.setLayoutData(spinnerData);
            fromSpinner.setMinimum(1);
            fromSpinner.setMaximum(measureCount);            
            fromSpinner.setSelection(measure.getMeasure().getNumber());
            
            Label toLabel = new Label(range, SWT.NULL);
            toLabel.setText(TuxGuitar.getProperty("edit.to"));
            final Spinner toSpinner = new Spinner(range, SWT.BORDER);                       
            toSpinner.setLayoutData(spinnerData);                                                                
            toSpinner.setMinimum(1);
            toSpinner.setMaximum(measureCount);
            toSpinner.setSelection(measure.getMeasure().getNumber());
            
            
            final int minSelection = 1;
            final int maxSelection = track.getMeasuresCoords().size();
            
            
            fromSpinner.addSelectionListener(new SelectionAdapter() {		
				public void widgetSelected(SelectionEvent e) {
					int fromSelection = fromSpinner.getSelection();
					int toSelection = toSpinner.getSelection();
										
					if(fromSelection < minSelection){
						fromSpinner.setSelection(minSelection);
					}else if(fromSelection > toSelection){
						fromSpinner.setSelection(toSelection);
					}
				}		
			});
            toSpinner.addSelectionListener(new SelectionAdapter() {		
				public void widgetSelected(SelectionEvent e) {					
					int toSelection = toSpinner.getSelection();
					int fromSelection = fromSpinner.getSelection();
					if(toSelection < fromSelection){
						toSpinner.setSelection(fromSelection);
					}else if(toSelection > maxSelection){
						toSpinner.setSelection(maxSelection);
					}
				}		
			});            
            //----------------------------------------------------------------------
            Composite buttons = new Composite(dialog,SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));            
            buttons.setLayoutData(new GridData(SWT.RIGHT,SWT.CENTER,true,true));  
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(new GridData(SWT.RIGHT,SWT.CENTER,true,true));
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    removeMeasures(fromSpinner.getSelection(),toSpinner.getSelection());
                	dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);            
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(new GridData(SWT.RIGHT,SWT.CENTER,true,true));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
            
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }

            }	            
        }
    }    

    private void removeMeasures(int m1,int m2){
    	if(m1 > 0 && m1 <= m2){    	     	    	
    		Caret caret = getEditor().getTablature().getCaret();
    		
    		Measure measure1 = getSongManager().getTrackManager().getMeasure(caret.getSongTrackCoords().getTrack(),m1);
    		Measure measure2 = getSongManager().getTrackManager().getMeasure(caret.getSongTrackCoords().getTrack(),m2);
    		if(measure1 != null && measure2 != null){ 
    			
    	        if(getSongManager().getTrackManager().isFirstMeasure(measure1) && 
    	           getSongManager().getTrackManager().isLastMeasure(caret.getSongTrackCoords().getTrack(),measure2)){
    	        	TuxGuitar.instance().getSongManager().newSong();
    	        	getEditor().resetDefaults();
    	        	TuxGuitar.instance().getMixer().update();
    	        	TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();        	
    	        	redraw();
    	        	return;
    	        }
    	        
    	        
    	        long p1 = measure1.getStart();
    	        long p2 = measure2.getStart();
    	        
    	        //comienza el undoable
    	        UndoableRemoveMeasure undoable = new UndoableRemoveMeasure(p1,p2);
    	        
    	        //borro los compases
    	        getSongManager().removeMeasures(p1,p2);            	        
        		
    	        updateTablature();
    		     
    	        int measureCount = getEditor().getSongManager().countMeasures();
    	        if(caret.getMeasureCoords().getMeasure().getNumber() > measureCount){
    	        	SongTrack track = getSongManager().getTrack(caret.getSongTrackCoords().getTrack().getNumber());
    	        	Measure measure = getSongManager().getTrackManager().getMeasure(track,measureCount);
    	        	caret.update(track.getNumber(),measure.getStart(),1);
    	        }    	        
    	        
                //termia el undoable
                getEditor().getUndoManager().addEdit(undoable.endUndo());    	        
    		}
    	}
    }
}
