/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.help;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class ShowAboutHelpAction extends Action {
	public static final String NAME = "SHOW_ABOUT_HELP";

	private static final int IMAGE_WIDTH = 100;
	private static final int IMAGE_HEIGHT = 100;
	
	public ShowAboutHelpAction(TablatureEditor tablatureEditor) {
		super(NAME, true, tablatureEditor);
	}

	public boolean doAction(TypedEvent e) {
		showDialog(getEditor().getTablature().getShell());
		return true;
	}

	public void showDialog(Shell shell) {

		final Shell dialog = new Shell(shell,SWT.DIALOG_TRIM|SWT.APPLICATION_MODAL);

		GridLayout layout = new GridLayout();
		layout.marginTop = 20;
		layout.marginLeft = 20;
		layout.marginRight = 20;
		layout.verticalSpacing = 10;
		layout.horizontalSpacing = 10;
		dialog.setLayout(new GridLayout());
		dialog.setText(TuxGuitar.getProperty("help.about"));

		
		//--------------------HEADER----------------------------------
		final Composite header = new Composite(dialog,SWT.NONE);
		final Canvas imageCanvas = new Canvas(header,SWT.NONE);
		final Image image = new Image(dialog.getDisplay(), TuxGuitar.getResourcePath(this, "splash.png"));
		final Label title = new Label(header,SWT.NONE);
		
		header.setLayout(new GridLayout(2,false));		
		
		imageCanvas.setLayoutData(new GridData(IMAGE_WIDTH,IMAGE_HEIGHT));
		imageCanvas.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				e.gc.drawImage(image,0,0,image.getBounds().width,image.getBounds().height,0,0,IMAGE_WIDTH,IMAGE_HEIGHT);
			}
		});
		
		
		title.setFont(new Font(dialog.getDisplay(),"Serif",18, SWT.BOLD | SWT.ITALIC));
		title.setText(TuxGuitar.getProperty("tuxguitar.version"));
		
		
		//--------------------TEXT------------------------------------
		final Text text = new Text(dialog,SWT.BORDER | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		text.setLayoutData(new GridData(300,80));
		text.setEditable(false);
		
		text.append(TuxGuitar.getProperty("tuxguitar.description"));
		text.setSelection(0);
		// -----------------------------------------------------------
		Button buttonExit = new Button(dialog, SWT.PUSH);
		buttonExit.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		buttonExit.setText(TuxGuitar.getProperty("exit"));
		buttonExit.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				dialog.dispose();
			}
		});

		dialog.pack();
		dialog.open();

		int x = shell.getBounds().x
				+ (shell.getBounds().width - dialog.getSize().x) / 2;
		int y = shell.getBounds().y
				+ (shell.getBounds().height - dialog.getSize().y) / 2;
		dialog.setLocation(x, y);

	}

}
