/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.bend.BendEditor;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.undo.undoables.component.UndoableComponentGeneric;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Measure;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeBendNoteAction extends Action{
    public static final String NAME = "CHANGE_BEND_NOTE";
    private BendEditor editor;
    private DefaultBend[] defaultBends;
    private boolean isEditing;
    
    public ChangeBendNoteAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        Caret caret = getEditor().getTablature().getCaret();
        MeasureComponent component = caret.getMeasureCoords().getComponent(caret.getPosition(),caret.getSelectedString().getNumber());
        if(component instanceof NoteCoords){
            showEditor(getEditor().getTablature().getShell(),(NoteCoords)component);
        }        
        return true;
    }
    

    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }        

        
    private void showEditor(Shell shell,final NoteCoords note){
        final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;      
        layout.horizontalSpacing = 10;     
        dialog.setLayout(layout);        
        dialog.setText(TuxGuitar.getProperty("bend.editor"));
        
        
        Composite editorComposite = new Composite(dialog,SWT.NONE); 
        editorComposite.setLayout(new GridLayout(1, false));         
        
        this.isEditing = (note.getNote().getEffect().isBend());
        
                
        this.editor = new BendEditor(editorComposite,SWT.BORDER);
        this.editor.setLayoutData(new GridData(editor.getWidth() + (BendEditor.X_SPAN * 2),editor.getHeight() + (BendEditor.Y_SPAN * 2)));   
        if(isEditing){
            this.editor.setBend(note.getNote().getEffect().getBend());
        }                

        
        Composite rightComposite = new Composite(dialog,SWT.NONE); 
        rightComposite.setLayout(new GridLayout(2, false));              
        
        final List defaultBendList = new List(rightComposite,SWT.BORDER); 
        GridData listData = new GridData();        
        listData.verticalAlignment = GridData.BEGINNING;
        listData.horizontalSpan = 2;
        defaultBendList.setLayoutData(listData);        
        this.resetDefaultBends();
        for(int i = 0;i < defaultBends.length;i++){
            defaultBendList.add(this.defaultBends[i].getName());
        }
        
        defaultBendList.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                if(!isEditing){
                    editor.setBend(defaultBends[defaultBendList.getSelectionIndex()].getBend());
                    editor.redraw();
                }
                isEditing = false;
            }
        });                                    
        
        
         
        
        final Button buttonOK = new Button(rightComposite, SWT.PUSH);
        GridData leftButtonData = new GridData();
        leftButtonData.horizontalAlignment = GridData.BEGINNING;
        buttonOK.setLayoutData(leftButtonData);         
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
        buttonOK.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {       
                //comienza el undoable
            	UndoableComponentGeneric undoable = UndoableComponentGeneric.startUndo(); 
            	
                Measure measure = getEditor().getTablature().getCaret().getMeasureCoords().getMeasure();
                
                if(editor.isEmpty()){
                	getSongManager().getMeasureManager().changeBendNote(measure,note.getNote().getStart(),note.getNote().getString(),null);
                }else{
                    BendEffect bend = new BendEffect();
                
                    editor.addBendPoints(bend);
                         
                    getSongManager().getMeasureManager().changeBendNote(measure,note.getNote().getStart(),note.getNote().getString(),bend);
                }
                updateTablature();
                
                //termia el undoable
                getEditor().getUndoManager().addEdit(undoable.endUndo());    
                    
                dialog.dispose();
            }
        });

        Button buttonCancel = new Button(rightComposite, SWT.PUSH);
        GridData rightButtonData = new GridData();
        rightButtonData.horizontalAlignment = GridData.END;
        buttonCancel.setLayoutData(rightButtonData);         
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });

        dialog.pack();
        dialog.open();        
        
        
    }    
    
    private void resetDefaultBends(){
        this.defaultBends = new DefaultBend[5];
        
        this.defaultBends[0] = new DefaultBend(TuxGuitar.getProperty("bend.bend"),new BendEffect());        
        this.defaultBends[0].getBend().addPoint(0,0);
        this.defaultBends[0].getBend().addPoint(6,8);
        this.defaultBends[0].getBend().addPoint(12,8);               
        
        this.defaultBends[1] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release"),new BendEffect());         
        this.defaultBends[1].getBend().addPoint(0,0);
        this.defaultBends[1].getBend().addPoint(3,8);
        this.defaultBends[1].getBend().addPoint(6,8);
        this.defaultBends[1].getBend().addPoint(9,0);
        this.defaultBends[1].getBend().addPoint(12,0);
        
        
        this.defaultBends[2] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release-bend"),new BendEffect());         
        this.defaultBends[2].getBend().addPoint(0,0);
        this.defaultBends[2].getBend().addPoint(2,8);
        this.defaultBends[2].getBend().addPoint(4,8);
        this.defaultBends[2].getBend().addPoint(6,0);
        this.defaultBends[2].getBend().addPoint(8,0);
        this.defaultBends[2].getBend().addPoint(10,8);
        this.defaultBends[2].getBend().addPoint(12,8);
        
        this.defaultBends[3] = new DefaultBend(TuxGuitar.getProperty("bend.prebend"),new BendEffect());         
        this.defaultBends[3].getBend().addPoint(0,8);
        this.defaultBends[3].getBend().addPoint(12,8);
        
        this.defaultBends[4] = new DefaultBend(TuxGuitar.getProperty("bend.prebend-release"),new BendEffect());         
        this.defaultBends[4].getBend().addPoint(0,8);
        this.defaultBends[4].getBend().addPoint(4,8);
        this.defaultBends[4].getBend().addPoint(8,0);
        this.defaultBends[4].getBend().addPoint(12,0);
    }       
    

    
    private class DefaultBend{
        private String name;
        private BendEffect bend;
        
        public DefaultBend(String name,BendEffect bend){
            this.name = name;
            this.bend = bend;
        }
        
        
        public BendEffect getBend() {
            return bend;
        }
        public String getName() {
            return name;
        }
    }
}
