/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.midiplayer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.midiplayer.MeasureStartMetaEventListener;
import org.herac.tuxguitar.play.models.midiplayer.SongSequence;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongPlayer
implements Player {
    private static int DELAY = 100;
    private SongManager songManager;
    private Sequencer sequencer;
    private Synthesizer synthesizer;
    private Soundbank soundbank;
    private MeasureStartMetaEventListener controller;
    private boolean realTimeSequencer;
    private boolean running;
    private boolean changeTickPosition;
    private long tickPosition;

    public SongPlayer(SongManager songManager) {
        this.songManager = songManager;
        this.controller = new MeasureStartMetaEventListener();
        this.init();
        this.reset();
    }

    private Sequencer getSequencer() {
        try {
            if (this.sequencer == null) {
                this.sequencer = MidiSystem.getSequencer();
                this.sequencer.addMetaEventListener(this.controller);
            }
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
            }
            return this.sequencer;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
            return null;
        }
    }

    public Synthesizer getSynthesizer() {
        try {
            if (this.synthesizer == null) {
                Sequencer sequencer = this.getSequencer();
                if (sequencer instanceof Synthesizer) {
                    this.synthesizer = MidiSystem.getSynthesizer();
                    this.synthesizer.open();
                    this.realTimeSequencer = false;
                } else {
                    this.synthesizer = MidiSystem.getSynthesizer();
                    this.synthesizer.open();
                    this.realTimeSequencer = true;
                    Receiver receiver = this.synthesizer.getReceiver();
                    Transmitter transmitter = sequencer.getTransmitter();
                    transmitter.setReceiver(receiver);
                }
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        return this.synthesizer;
    }

    public Soundbank getDefaultSoundbank() {
        if (this.soundbank == null) {
            Synthesizer synthesizer = this.getSynthesizer();
            this.soundbank = synthesizer.getDefaultSoundbank();
        }
        return this.soundbank;
    }

    public void init() {
        this.getSynthesizer();
        this.getSequencer();
    }

    public void reset() {
        this.stop();
        this.tickPosition = 1000L;
        this.setChangeTickPosition(false);
        this.controller.reset();
    }

    public void close() {
        Sequencer sequencer;
        Synthesizer synthesizer = this.getSynthesizer();
        if (synthesizer != null) {
            synthesizer.close();
        }
        if ((sequencer = this.getSequencer()) != null) {
            sequencer.close();
        }
        this.setRunning(false);
    }

    public void stop() {
        Sequencer sequencer = this.getSequencer();
        if (sequencer != null && sequencer.isRunning()) {
            sequencer.stop();
        }
        this.setRunning(false);
    }

    public boolean isRealTimeSequencer() {
        return this.realTimeSequencer;
    }

    public void play() {
        this.stop();
        this.setRunning(true);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SongPlayer.this.addSecuence();
                    SongPlayer.this.setChangeTickPosition(true);
                    SongPlayer.this.getSequencer().start();
                    while (SongPlayer.this.getSequencer().isRunning()) {
                        if (SongPlayer.this.isChangeTickPosition()) {
                            SongPlayer.this.getSequencer().setTickPosition(SongPlayer.this.tickPosition - (long)DELAY);
                            SongPlayer.this.updateChannels();
                            SongPlayer.this.setChangeTickPosition(false);
                        }
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    SongPlayer.this.close();
                    SongPlayer.this.init();
                    invalidMidiDataException.printStackTrace();
                }
                finally {
                    SongPlayer.this.reset();
                }
            }
        }).start();
    }

    public void setTickPosition(long l) {
        this.tickPosition = l;
        this.setChangeTickPosition(true);
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isRunning() {
        return this.running;
    }

    private boolean isChangeTickPosition() {
        return this.changeTickPosition;
    }

    private void setChangeTickPosition(boolean bl) {
        this.changeTickPosition = bl;
    }

    public long getTickPosition() {
        if (this.sequencer.getTickPosition() >= this.tickPosition + (long)DELAY) {
            return this.sequencer.getTickPosition() - this.controller.getStartMove();
        }
        return 0L;
    }

    public void addSecuence() throws InvalidMidiDataException {
        SongSequence songSequence = new SongSequence(this.songManager);
        songSequence.createSongSecuence(this.isRealTimeSequencer(), true);
        this.getSequencer().setSequence(songSequence.getSongSecuence());
    }

    public void loadSoundbank(File file) {
        try {
            Soundbank soundbank = MidiSystem.getSoundbank(file);
            if (soundbank != null && this.getSynthesizer().isSoundbankSupported(soundbank)) {
                this.getSynthesizer().loadAllInstruments(soundbank);
                this.soundbank = soundbank;
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void updateChannels() {
        if (this.isRealTimeSequencer()) {
            for (SongTrack songTrack : this.songManager.getSong().getTracks()) {
                this.updateChannel(songTrack.getChannel());
            }
        }
    }

    public void updateChannel(SongChannel songChannel) {
        double d = (double)this.songManager.getSong().getVolume() / 10.0;
        int n = (int)(d * (double)songChannel.getVolume());
        short s = songChannel.getBalance();
        boolean bl = songChannel.isSolo();
        boolean bl2 = songChannel.isMute();
        Synthesizer synthesizer = this.getSynthesizer();
        MidiChannel[] midiChannelArray = synthesizer.getChannels();
        midiChannelArray[songChannel.getChannel()].controlChange(7, n);
        midiChannelArray[songChannel.getChannel()].controlChange(10, s);
        midiChannelArray[songChannel.getChannel()].setSolo(bl);
        midiChannelArray[songChannel.getChannel()].setMute(bl2);
        if (songChannel.getChannel() != songChannel.getEffectChannel()) {
            midiChannelArray[songChannel.getEffectChannel()].controlChange(7, n);
            midiChannelArray[songChannel.getEffectChannel()].controlChange(10, s);
            midiChannelArray[songChannel.getEffectChannel()].setSolo(bl);
            midiChannelArray[songChannel.getEffectChannel()].setMute(bl2);
        }
    }

    public void playBeat(final SongTrack songTrack, List list) {
        final MidiChannel[] midiChannelArray = this.getSynthesizer().getChannels();
        for (Note note : list) {
            final int n = note.getValue() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
            final short s = note.getEffect().hasEffects() ? songTrack.getChannel().getEffectChannel() : songTrack.getChannel().getChannel();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        midiChannelArray[s].controlChange(7, 127);
                        midiChannelArray[s].controlChange(10, 64);
                        midiChannelArray[s].programChange(songTrack.getChannel().getInstrument());
                        midiChannelArray[s].noteOn(n, 64);
                        Thread.sleep(750L);
                        midiChannelArray[s].noteOff(n, 32);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void write(OutputStream outputStream) {
        try {
            SongSequence songSequence = new SongSequence(this.songManager);
            songSequence.createSongSecuence(false, false);
            int n = this.songManager.countTracks() > 1 ? 1 : 0;
            MidiSystem.write(songSequence.getSongSecuence(), n, outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

