/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;
import org.herac.tuxguitar.song.models.Tupleto;

public class TGOutputStream {
    private static final String TG_VERSION = "TG_DEVEL-0.01";
    private DataOutputStream dataOutputStream;

    public TGOutputStream(FileOutputStream fileOutputStream) throws FileNotFoundException {
        this.dataOutputStream = new DataOutputStream(fileOutputStream);
    }

    public TGOutputStream(String string) throws FileNotFoundException {
        this(new FileOutputStream(new File(string)));
    }

    public void write(Song song) {
        try {
            this.writeVersion();
            this.writeSong(song);
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeVersion() {
        this.writeString(TG_VERSION);
    }

    private void writeSong(Song song) {
        this.writeString(song.getName());
        this.writeString(song.getInterpret());
        this.writeString(song.getAlbum());
        this.writeString(song.getAuthor());
        this.writeInt(song.getTracks().size());
        for (SongTrack songTrack : song.getTracks()) {
            this.writeTrack(songTrack);
        }
    }

    private void writeTrack(SongTrack songTrack) {
        this.writeLong(songTrack.getNumber());
        this.writeString(songTrack.getName());
        this.writeChannel(songTrack.getChannel());
        this.writeInt(songTrack.getMeasures().size());
        for (Object object : songTrack.getMeasures()) {
            this.writeMeasure((Measure)object);
        }
        this.writeInt(songTrack.getStrings().size());
        for (InstrumentString instrumentString : songTrack.getStrings()) {
            this.writeInstrumentString(instrumentString);
        }
        this.writeTrackColor(songTrack.getColor());
    }

    private void writeMeasure(Measure measure) {
        this.writeInt(measure.getNumber());
        this.writeLong(measure.getStart());
        this.writeInt(measure.getNotes().size());
        for (Object object : measure.getNotes()) {
            this.writeNote((Note)object);
        }
        this.writeInt(measure.getSilences().size());
        for (Silence silence : measure.getSilences()) {
            this.writeSilence(silence);
        }
        this.writeTimeSignature(measure.getTimeSignature());
        this.writeTempo(measure.getTempo());
        this.writeBoolean(measure.isRepeatStart());
        this.writeInt(measure.getNumberOfRepetitions());
    }

    private void writeNote(Note note) {
        this.writeInt(note.getValue());
        this.writeLong(note.getStart());
        this.writeDuration(note.getDuration());
        this.writeInt(note.getVelocity());
        this.writeInt(note.getString());
        this.writeBoolean(note.isTiedNote());
        this.writeNoteEffect(note.getEffect());
    }

    private void writeChannel(SongChannel songChannel) {
        this.writeShort(songChannel.getChannel());
        this.writeShort(songChannel.getEffectChannel());
        this.writeShort(songChannel.getInstrument());
        this.writeShort(songChannel.getVolume());
        this.writeShort(songChannel.getBalance());
        this.writeShort(songChannel.getChorus());
        this.writeShort(songChannel.getReverb());
        this.writeShort(songChannel.getPhaser());
        this.writeShort(songChannel.getTremolo());
        this.writeBoolean(songChannel.isSolo());
        this.writeBoolean(songChannel.isMute());
    }

    private void writeSilence(Silence silence) {
        this.writeLong(silence.getStart());
        this.writeDuration(silence.getDuration());
    }

    private void writeInstrumentString(InstrumentString instrumentString) {
        this.writeInt(instrumentString.getNumber());
        this.writeInt(instrumentString.getValue());
    }

    private void writeTempo(Tempo tempo) {
        this.writeInt(tempo.getValue());
    }

    private void writeTimeSignature(TimeSignature timeSignature) {
        this.writeInt(timeSignature.getNumerator());
        this.writeDuration(timeSignature.getDenominator());
    }

    private void writeDuration(Duration duration) {
        this.writeInt(duration.getValue());
        this.writeBoolean(duration.isDotted());
        this.writeBoolean(duration.isDoubleDotted());
        this.writeTupleto(duration.getTupleto());
    }

    private void writeTupleto(Tupleto tupleto) {
        this.writeInt(tupleto.getEnters());
        this.writeInt(tupleto.getTimes());
    }

    private void writeNoteEffect(NoteEffect noteEffect) {
        this.writeBoolean(noteEffect.isVibrato());
        this.writeBoolean(noteEffect.isBend());
        if (noteEffect.isBend()) {
            this.writeBendEffect(noteEffect.getBend());
        }
        this.writeBoolean(noteEffect.isDeadNote());
        this.writeBoolean(noteEffect.isSlide());
        this.writeBoolean(noteEffect.isHammer());
    }

    private void writeBendEffect(BendEffect bendEffect) {
        this.writeInt(bendEffect.getPoints().size());
        for (BendEffect.BendPoint bendPoint : bendEffect.getPoints()) {
            this.writeInt(bendPoint.getPosition());
            this.writeInt(bendPoint.getValue());
        }
    }

    private void writeTrackColor(TrackColor trackColor) {
        this.writeInt(trackColor.getR());
        this.writeInt(trackColor.getG());
        this.writeInt(trackColor.getB());
    }

    private void writeString(String string) {
        try {
            this.dataOutputStream.write(string.length());
            this.dataOutputStream.writeChars(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeShort(short s) {
        try {
            this.dataOutputStream.writeShort(s);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeInt(int n) {
        try {
            this.dataOutputStream.writeInt(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeLong(long l) {
        try {
            this.dataOutputStream.writeLong(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeBoolean(boolean bl) {
        try {
            this.dataOutputStream.writeBoolean(bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

